/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.UrlComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfUtils {
    public static URL getConfResource(String name) {
        URL resource = ConfUtils.getResource(name);
        try {
            File loginConfig = ConfUtils.install(resource, name);
            if (loginConfig != null) {
                resource = loginConfig.toURI().toURL();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resource;
    }

    public static URL getResource(String name) {
        Enumeration<URL> resources = null;
        try {
            resources = Thread.currentThread().getContextClassLoader().getResources(name);
        }
        catch (IOException e) {
            return Thread.currentThread().getContextClassLoader().getResource(name);
        }
        URL resource = ConfUtils.select(resources);
        return resource;
    }

    private static URL select(Enumeration<URL> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<URL> urls = Collections.list(enumeration);
        if (urls.size() == 0) {
            return null;
        }
        if (urls.size() == 1) {
            return urls.get(0);
        }
        Collections.sort(urls, new UrlComparator(SystemInstance.get().getBase().getDirectory()));
        return urls.get(0);
    }

    public static File install(String source, String name) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL resource = cl.getResource(source);
        return ConfUtils.install(resource, name, false);
    }

    public static File install(URL resource, String name) throws IOException {
        return ConfUtils.install(resource, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File install(URL resource, String name, boolean overwrite) throws IOException {
        if (resource == null) {
            return null;
        }
        SystemInstance system = SystemInstance.get();
        FileUtils base = system.getBase();
        File conf = base.getDirectory("conf");
        if (!conf.exists()) {
            return null;
        }
        File file = new File(conf, name);
        if (file.exists() && !overwrite) {
            return file;
        }
        InputStream in = resource.openStream();
        in = new BufferedInputStream(in);
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        try {
            int b = in.read();
            while (b != -1) {
                out.write(b);
                b = in.read();
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException e) {}
        return file;
    }
}

