/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.apache.openejb.util.io.FieldDescriptor;
import org.apache.openejb.util.io.ObjectOutputStream;

public class ClassDescriptor
implements Serializable,
ObjectStreamConstants {
    private static final ObjectStreamField[] serialPersistentFields = ObjectStreamClass.NO_FIELDS;
    protected int flags = 0;
    private boolean serializable;
    private boolean externalizable;
    public static final FieldDescriptor[] NO_FIELDS = new FieldDescriptor[0];
    protected FieldDescriptor[] fields;
    private boolean hasWriteObjectMethod;
    private boolean hasReadObjectMethod;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private long suid;
    private String name;
    private Class forClass;
    private ClassDescriptor superdesc;
    private static ClassDescriptorEntry[] descriptorFor = new ClassDescriptorEntry[61];
    static final Class[] OIS_ARGS = new Class[]{ObjectInputStream.class};
    static final Class[] OOS_ARGS = new Class[]{java.io.ObjectOutputStream.class};

    protected ClassDescriptor(Class clazz, ClassDescriptor superdesc, boolean serializable, boolean externalizable) {
        if (externalizable) {
            serializable = false;
        }
        this.forClass = clazz;
        this.superdesc = superdesc;
        this.serializable = serializable;
        this.externalizable = externalizable;
        this.name = this.forClass.getName();
        ClassDescriptor.insertDescriptorFor(this);
        if (externalizable) {
            this.fields = NO_FIELDS;
        } else if (serializable) {
            AccessController.doPrivileged(new AccessibleFieldInitializer(this));
        }
        AccessController.doPrivileged(new SerializationPropertiesReflector(this));
        if (this.hasWriteObjectMethod) {
            this.flags |= 1;
        }
        if (serializable) {
            this.flags |= 2;
        }
        if (externalizable) {
            this.flags |= 4;
        }
    }

    protected void writeClassInfo(ObjectOutputStream out) throws IOException {
        out.writeByte(this.flags);
        out.writeShort(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].writeDesc(out);
        }
    }

    protected boolean isSerializable() {
        return this.serializable;
    }

    protected boolean isExternalizable() {
        return this.externalizable;
    }

    protected boolean isNonSerializable() {
        return !this.externalizable && !this.serializable;
    }

    public FieldDescriptor[] getFields() {
        return this.fields;
    }

    public void setFields(FieldDescriptor[] fields) {
        this.fields = fields;
    }

    public boolean hasWriteObjectMethod() {
        return this.hasWriteObjectMethod;
    }

    public void hasWriteObjectMethod(boolean b) {
        this.hasWriteObjectMethod = b;
    }

    public Method getWriteObjectMethod() {
        return this.writeObjectMethod;
    }

    protected void setWriteObjectMethod(Method method) {
        this.writeObjectMethod = method;
        this.hasWriteObjectMethod = method != null;
    }

    public boolean hasReadObjectMethod() {
        return this.hasReadObjectMethod;
    }

    public void hasReadObjectMethod(boolean b) {
        this.hasReadObjectMethod = b;
    }

    public Method getReadObjectMethod() {
        return this.readObjectMethod;
    }

    protected void setReadObjectMethod(Method method) {
        this.readObjectMethod = method;
        this.hasReadObjectMethod = method != null;
    }

    public long getSerialVersionUID() {
        return this.suid;
    }

    protected void setSerialVersionUID(long suid) {
        this.suid = suid;
    }

    public String getName() {
        return this.name;
    }

    public Class forClass() {
        return this.forClass;
    }

    protected ClassDescriptor getSuperclass() {
        return this.superdesc;
    }

    protected void setSuperclass(ClassDescriptor s) {
        this.superdesc = s;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(": static final long serialVersionUID = ");
        sb.append(Long.toString(this.suid));
        sb.append("L;");
        return sb.toString();
    }

    public static StringBuffer getSignature(Class clazz) {
        StringBuffer buf = new StringBuffer();
        return ClassDescriptor.getSignature(clazz, buf);
    }

    public static StringBuffer getSignature(Class clazz, StringBuffer buf) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                buf.append('I');
            } else if (clazz == Byte.TYPE) {
                buf.append('B');
            } else if (clazz == Long.TYPE) {
                buf.append('J');
            } else if (clazz == Float.TYPE) {
                buf.append('F');
            } else if (clazz == Double.TYPE) {
                buf.append('D');
            } else if (clazz == Short.TYPE) {
                buf.append('S');
            } else if (clazz == Character.TYPE) {
                buf.append('C');
            } else if (clazz == Boolean.TYPE) {
                buf.append('Z');
            } else if (clazz == Void.TYPE) {
                buf.append('V');
            }
        } else if (clazz.isArray()) {
            Class<?> cl = clazz;
            while (cl.isArray()) {
                buf.append('[');
                cl = cl.getComponentType();
            }
            buf.append(ClassDescriptor.getSignature(cl).toString());
        } else {
            buf.append('L');
            buf.append(clazz.getName().replace('.', '/'));
            buf.append(';');
        }
        return buf;
    }

    public static ClassDescriptor lookup(Class clazz) {
        ClassDescriptor desc = ClassDescriptor.lookupInternal(clazz);
        if (desc.isSerializable() || desc.isExternalizable()) {
            return desc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClassDescriptor lookupInternal(Class clazz) {
        ClassDescriptor desc = null;
        ClassDescriptorEntry[] classDescriptorEntryArray = descriptorFor;
        synchronized (descriptorFor) {
            Class superclass;
            desc = ClassDescriptor.findDescriptorFor(clazz);
            if (desc != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return desc;
            }
            boolean serializable = Serializable.class.isAssignableFrom(clazz);
            ClassDescriptor superdesc = null;
            if (serializable && (superclass = clazz.getSuperclass()) != null) {
                superdesc = ClassDescriptor.lookup(superclass);
            }
            boolean externalizable = false;
            if (serializable) {
                boolean bl = externalizable = superdesc != null && superdesc.isExternalizable() || Externalizable.class.isAssignableFrom(clazz);
                if (externalizable) {
                    serializable = false;
                }
            }
            desc = new ClassDescriptor(clazz, superdesc, serializable, externalizable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return desc;
        }
    }

    private static ClassDescriptor findDescriptorFor(Class clazz) {
        ClassDescriptorEntry e;
        int hash = clazz.hashCode();
        int index = (hash & Integer.MAX_VALUE) % descriptorFor.length;
        while ((e = descriptorFor[index]) != null && e.get() == null) {
            ClassDescriptor.descriptorFor[index] = e.next;
        }
        ClassDescriptorEntry prev = e;
        while (e != null) {
            ClassDescriptor desc = (ClassDescriptor)e.get();
            if (desc == null) {
                prev.next = e.next;
            } else {
                if (desc.forClass == clazz) {
                    return desc;
                }
                prev = e;
            }
            e = e.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ClassDescriptor desc) {
        if (ClassDescriptor.findDescriptorFor(desc.forClass) != null) {
            return;
        }
        int hash = desc.forClass.hashCode();
        int index = (hash & Integer.MAX_VALUE) % descriptorFor.length;
        ClassDescriptorEntry e = new ClassDescriptorEntry(desc);
        e.next = descriptorFor[index];
        ClassDescriptor.descriptorFor[index] = e;
    }

    private static class AccessibleFieldInitializer
    implements PrivilegedAction {
        ClassDescriptor desc;

        public AccessibleFieldInitializer(ClassDescriptor desc) {
            this.desc = desc;
        }

        public Object run() {
            Object[] fields = this.getDeclaredSerialPersistentFields(this.desc.forClass());
            if (fields == null) {
                fields = this.reflectForFields(this.desc.forClass());
            }
            if (fields.length > 1) {
                Arrays.sort(fields);
            }
            this.desc.setFields((FieldDescriptor[])fields);
            return null;
        }

        private FieldDescriptor[] getDeclaredSerialPersistentFields(Class clazz) throws SecurityException {
            ObjectStreamField[] outputStreamFields;
            Field[] tmpFields = null;
            try {
                Field serialPersistentFields = clazz.getDeclaredField("serialPersistentFields");
                if (!Modifier.isPrivate(serialPersistentFields.getModifiers())) {
                    return null;
                }
                serialPersistentFields.setAccessible(true);
                outputStreamFields = (ObjectStreamField[])serialPersistentFields.get(clazz);
                tmpFields = new Field[outputStreamFields.length];
            }
            catch (NoSuchFieldException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            int validFields = 0;
            for (int i = outputStreamFields.length - 1; i >= 0; --i) {
                try {
                    Field reflectedField = clazz.getDeclaredField(outputStreamFields[i].getName());
                    if (outputStreamFields[i].getType() != reflectedField.getType()) continue;
                    reflectedField.setAccessible(true);
                    tmpFields[validFields++] = reflectedField;
                    continue;
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            FieldDescriptor[] validFieldDescriptors = new FieldDescriptor[validFields];
            --validFields;
            while (validFields >= 0) {
                validFieldDescriptors[validFields] = new FieldDescriptor(tmpFields[validFields]);
                --validFields;
            }
            return validFieldDescriptors;
        }

        private FieldDescriptor[] reflectForFields(Class clazz) {
            AccessibleObject[] allFields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(allFields, true);
            Field[] tmpFields = new Field[allFields.length];
            int validFields = 0;
            for (int i = 0; i < allFields.length; ++i) {
                int modifiers = ((Field)allFields[i]).getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                tmpFields[validFields++] = allFields[i];
            }
            FieldDescriptor[] validFieldDescriptors = new FieldDescriptor[validFields];
            --validFields;
            while (validFields >= 0) {
                validFieldDescriptors[validFields] = new FieldDescriptor(tmpFields[validFields]);
                --validFields;
            }
            return validFieldDescriptors;
        }
    }

    private class SerializationPropertiesReflector
    implements PrivilegedAction {
        ClassDescriptor desc;

        public SerializationPropertiesReflector(ClassDescriptor desc) {
            this.desc = desc;
        }

        public Object run() {
            try {
                Field field = null;
                field = this.desc.forClass().getDeclaredField("serialVersionUID");
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                    field.setAccessible(true);
                    this.desc.setSerialVersionUID(field.getLong(this.desc.forClass()));
                } else {
                    this.desc.setSerialVersionUID(this.computeSerialVersionUID(this.desc.forClass()));
                }
            }
            catch (NoSuchFieldException ex) {
                this.desc.setSerialVersionUID(this.computeSerialVersionUID(this.desc.forClass()));
            }
            catch (IllegalAccessException ex) {
                this.desc.setSerialVersionUID(this.computeSerialVersionUID(this.desc.forClass()));
            }
            if (ClassDescriptor.this.serializable) {
                this.desc.setWriteObjectMethod(this.getDeclaredMethod("writeObject", OOS_ARGS, 2, 8));
                this.desc.setWriteObjectMethod(this.getDeclaredMethod("readObject", OIS_ARGS, 2, 8));
            }
            return null;
        }

        private Method getDeclaredMethod(String methodName, Class[] args, int requiredModifierMask, int disallowedModifierMask) {
            Method method = null;
            try {
                method = ClassDescriptor.this.forClass.getDeclaredMethod(methodName, args);
                if (method != null) {
                    int mods = method.getModifiers();
                    if ((mods & disallowedModifierMask) != 0 || (mods & requiredModifierMask) != requiredModifierMask) {
                        method = null;
                    } else {
                        method.setAccessible(true);
                    }
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return method;
        }

        private long computeSerialVersionUID(Class clazz) {
            return 42L;
        }
    }

    private static class ClassDescriptorEntry
    extends SoftReference {
        ClassDescriptorEntry next;

        ClassDescriptorEntry(ClassDescriptor c) {
            super(c);
        }
    }
}

