/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.Assembler;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.openejb.util.SafeToolkit;

public final class OpenEJB {
    private static Instance instance;
    private static Messages messages;
    private static Logger logger;

    public static ApplicationServer getApplicationServer() {
        return (ApplicationServer)SystemInstance.get().getComponent(ApplicationServer.class);
    }

    public static TransactionManager getTransactionManager() {
        return (TransactionManager)SystemInstance.get().getComponent(TransactionManager.class);
    }

    public static void destroy() {
        Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        assembler.destroy();
        SystemInstance.get().removeComponent(ContainerSystem.class);
        SystemInstance.get().removeComponent(Assembler.class);
        SystemInstance.get().removeComponent(TransactionManager.class);
        SystemInstance.get().removeComponent(SecurityService.class);
        SystemInstance.reset();
        instance = null;
    }

    public static void init(Properties props) throws OpenEJBException {
        OpenEJB.init(props, null);
    }

    public static void init(Properties initProps, ApplicationServer appServer) throws OpenEJBException {
        if (OpenEJB.isInitialized()) {
            if (instance != null) {
                String msg = messages.message("startup.alreadyInitialized");
                logger.error(msg, instance.initialized);
                throw new OpenEJBException(msg, instance.initialized);
            }
            String msg = messages.message("startup.alreadyInitialized");
            logger.error(msg);
            throw new OpenEJBException(msg);
        }
        instance = new Instance(initProps, appServer);
    }

    public static boolean isInitialized() {
        return instance != null || SystemInstance.get().getComponent(ContainerSystem.class) != null;
    }

    static {
        messages = new Messages("org.apache.openejb.util.resources");
        logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, "org.apache.openejb.util.resources");
    }

    public static class Instance {
        private static Messages messages = new Messages("org.apache.openejb.util.resources");
        private final Throwable initialized = new Exception("Initialized at " + new Date()).fillInStackTrace();

        public Instance(Properties props) throws OpenEJBException {
            this(props, null);
        }

        public Instance(Properties initProps, ApplicationServer appServer) throws OpenEJBException {
            SecurityService securityService;
            Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, "org.apache.openejb.util.resources");
            try {
                SystemInstance.init((Properties)initProps);
            }
            catch (Exception e) {
                throw new OpenEJBException(e);
            }
            SystemInstance system = SystemInstance.get();
            SafeToolkit toolkit = SafeToolkit.getToolkit("OpenEJB");
            if (appServer == null) {
                ApplicationServer defaultServer;
                appServer = defaultServer = (ApplicationServer)toolkit.newInstance("org.apache.openejb.core.ServerFederation");
            }
            system.setComponent(ApplicationServer.class, (Object)appServer);
            OpenEjbVersion versionInfo = OpenEjbVersion.get();
            if (initProps.getProperty("openejb.nobanner") == null) {
                System.out.println("Apache OpenEJB " + versionInfo.getVersion() + "    build: " + versionInfo.getDate() + "-" + versionInfo.getTime());
                System.out.println("" + versionInfo.getUrl());
            }
            Logger logger2 = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
            logger2.info("startup.banner", versionInfo.getUrl(), new Date(), versionInfo.getCopyright(), versionInfo.getVersion(), versionInfo.getDate(), versionInfo.getTime());
            logger.info("openejb.home = " + SystemInstance.get().getHome().getDirectory().getAbsolutePath());
            logger.info("openejb.base = " + SystemInstance.get().getBase().getDirectory().getAbsolutePath());
            Properties props = new Properties(SystemInstance.get().getProperties());
            if (initProps == null) {
                logger.debug("startup.noInitializationProperties");
            } else {
                props.putAll((Map<?, ?>)initProps);
            }
            String className = props.getProperty("org/openejb/assembler_class");
            if (className == null) {
                className = props.getProperty("openejb.assembler", "org.apache.openejb.assembler.classic.Assembler");
            } else {
                logger.warning("startup.deprecatedPropertyName", "org/openejb/assembler_class");
            }
            logger.debug("startup.instantiatingAssemblerClass", className);
            Assembler assembler = null;
            try {
                assembler = (Assembler)toolkit.newInstance(className);
            }
            catch (OpenEJBException oe) {
                logger.fatal("startup.assemblerCannotBeInstantiated", oe);
                throw oe;
            }
            catch (Throwable t) {
                String msg = messages.message("startup.openejbEncounteredUnexpectedError");
                logger.fatal(msg, t);
                throw new OpenEJBException(msg, t);
            }
            SystemInstance.get().setComponent(Assembler.class, (Object)assembler);
            try {
                assembler.init(props);
            }
            catch (OpenEJBException oe) {
                logger.fatal("startup.assemblerFailedToInitialize", oe);
                throw oe;
            }
            catch (Throwable t) {
                String msg = messages.message("startup.assemblerEncounteredUnexpectedError");
                logger.fatal(msg, t);
                throw new OpenEJBException(msg, t);
            }
            try {
                assembler.build();
            }
            catch (OpenEJBException oe) {
                logger.fatal("startup.assemblerFailedToBuild", oe);
                throw oe;
            }
            catch (Throwable t) {
                String msg = messages.message("startup.assemblerEncounterUnexpectedBuildError");
                logger.fatal(msg, t);
                throw new OpenEJBException(msg, t);
            }
            ContainerSystem containerSystem = assembler.getContainerSystem();
            if (containerSystem == null) {
                String msg = messages.message("startup.assemblerReturnedNullContainer");
                logger.fatal(msg);
                throw new OpenEJBException(msg);
            }
            system.setComponent(ContainerSystem.class, (Object)containerSystem);
            if (logger.isDebugEnabled()) {
                String entry;
                int i;
                logger.debug("startup.debugContainers", containerSystem.containers().length);
                if (containerSystem.containers().length > 0) {
                    Container[] c = containerSystem.containers();
                    logger.debug("startup.debugContainersType");
                    for (i = 0; i < c.length; ++i) {
                        entry = "   ";
                        switch (c[i].getContainerType()) {
                            case BMP_ENTITY: {
                                entry = entry + "BMP ENTITY  ";
                                break;
                            }
                            case CMP_ENTITY: {
                                entry = entry + "CMP ENTITY  ";
                                break;
                            }
                            case STATEFUL: {
                                entry = entry + "STATEFUL    ";
                                break;
                            }
                            case STATELESS: {
                                entry = entry + "STATELESS   ";
                                break;
                            }
                            case MESSAGE_DRIVEN: {
                                entry = entry + "MESSAGE     ";
                            }
                        }
                        entry = entry + c[i].getContainerID();
                        logger.debug("startup.debugEntry", entry);
                    }
                }
                logger.debug("startup.debugDeployments", containerSystem.deployments().length);
                if (containerSystem.deployments().length > 0) {
                    logger.debug("startup.debugDeploymentsType");
                    DeploymentInfo[] d = containerSystem.deployments();
                    for (i = 0; i < d.length; ++i) {
                        entry = "   ";
                        switch (d[i].getComponentType()) {
                            case BMP_ENTITY: {
                                entry = entry + "BMP_ENTITY  ";
                                break;
                            }
                            case CMP_ENTITY: {
                                entry = entry + "CMP_ENTITY  ";
                                break;
                            }
                            case STATEFUL: {
                                entry = entry + "STATEFUL    ";
                                break;
                            }
                            case STATELESS: {
                                entry = entry + "STATELESS   ";
                                break;
                            }
                            case SINGLETON: {
                                entry = entry + "SINGLETON   ";
                                break;
                            }
                            case MESSAGE_DRIVEN: {
                                entry = entry + "MESSAGE     ";
                            }
                        }
                        entry = entry + d[i].getDeploymentID();
                        logger.debug("startup.debugEntry", entry);
                    }
                }
            }
            if ((securityService = assembler.getSecurityService()) == null) {
                String msg = messages.message("startup.assemblerReturnedNullSecurityService");
                logger.fatal(msg);
                throw new OpenEJBException(msg);
            }
            logger.debug("startup.securityService", securityService.getClass().getName());
            system.setComponent(SecurityService.class, (Object)securityService);
            TransactionManager transactionManager = assembler.getTransactionManager();
            if (transactionManager == null) {
                String msg = messages.message("startup.assemblerReturnedNullTransactionManager");
                logger.fatal(msg);
                throw new OpenEJBException(msg);
            }
            logger.debug("startup.transactionManager", transactionManager.getClass().getName());
            SystemInstance.get().setComponent(TransactionManager.class, (Object)transactionManager);
            logger.debug("startup.ready");
        }

        public Throwable getInitialized() {
            return this.initialized;
        }
    }
}

