/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.client.LocalInitialContextFactory;
import org.apache.openejb.core.ivm.ClientSecurity;
import org.apache.openejb.core.ivm.naming.ContextWrapper;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalInitialContext
extends ContextWrapper {
    private static final String OPENEJB_EMBEDDED_REMOTABLE = "openejb.embedded.remotable";
    private static Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, LocalInitialContext.class);
    private final LocalInitialContextFactory factory;
    private Properties properties = new Properties();
    private Object clientIdentity;
    private Object serviceManager;
    private static final String ON_CLOSE = "openejb.embedded.initialcontext.close";
    private Close onClose;

    public LocalInitialContext(Hashtable env, LocalInitialContextFactory factory) throws NamingException {
        super(LocalInitialContext.getContainerSystemEjbContext());
        this.properties.putAll((Map<?, ?>)env);
        this.onClose = Options.getEnum(this.properties, ON_CLOSE, Close.LOGOUT);
        this.factory = factory;
        this.login();
        this.startNetworkServices();
        Properties properties = new Properties();
        this.createEJBContainer(properties, new String[0]);
    }

    public void createEJBContainer(Map<?, ?> properties, String ... modules) {
    }

    @Override
    public void close() throws NamingException {
        logger.debug("LocalIntialContext.close()");
        switch (this.onClose) {
            case LOGOUT: {
                this.logout();
                break;
            }
            case DESTROY: {
                this.logout();
                this.destroy();
            }
        }
    }

    private void destroy() throws NamingException {
        this.stopNetworkServices();
        this.tearDownOpenEJB();
    }

    private void tearDownOpenEJB() throws NamingException {
        if (this.factory.bootedOpenEJB()) {
            logger.info("Destroying container system");
            this.factory.close();
            this.context.close();
            OpenEJB.destroy();
        }
    }

    private void login() throws AuthenticationException {
        String user = (String)this.properties.get("java.naming.security.principal");
        String pass = (String)this.properties.get("java.naming.security.credentials");
        String realmName = (String)this.properties.get("openejb.authentication.realmName");
        if (user != null && pass != null) {
            try {
                logger.info("Logging in");
                SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
                this.clientIdentity = realmName == null ? securityService.login(user, pass) : securityService.login(realmName, user, pass);
                ClientSecurity.setIdentity(this.clientIdentity);
            }
            catch (LoginException e) {
                throw (AuthenticationException)new AuthenticationException("User could not be authenticated: " + user).initCause(e);
            }
        }
    }

    private void logout() {
        if (this.clientIdentity != null) {
            logger.info("Logging out");
            ClientSecurity.setIdentity(null);
        }
    }

    private void startNetworkServices() {
        if (!this.properties.getProperty(OPENEJB_EMBEDDED_REMOTABLE, "false").equalsIgnoreCase("true")) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> serviceManagerClass = classLoader.loadClass("org.apache.openejb.server.ServiceManager");
            Method get = serviceManagerClass.getMethod("get", new Class[0]);
            try {
                if (get.invoke(null, new Object[0]) != null) {
                    return;
                }
            }
            catch (InvocationTargetException e) {
                return;
            }
            logger.info("Starting network services");
            Method getManager = serviceManagerClass.getMethod("getManager", new Class[0]);
            Method init = serviceManagerClass.getMethod("init", new Class[0]);
            Method start = serviceManagerClass.getMethod("start", Boolean.TYPE);
            try {
                this.serviceManager = getManager.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException e) {
                String msg = "Option Enabled 'openejb.embedded.remotable'.  Error, unable to instantiate ServiceManager class 'org.apache.openejb.server.ServiceManager'.";
                throw new IllegalStateException(msg, e);
            }
            try {
                init.invoke(this.serviceManager, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                String msg = "Option Enabled 'openejb.embedded.remotable'.  Error, unable to initialize ServiceManager.  Cause: " + cause.getClass().getName() + ": " + cause.getMessage();
                throw new IllegalStateException(msg, cause);
            }
            try {
                start.invoke(this.serviceManager, false);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                String msg = "Option Enabled 'openejb.embedded.remotable'.  Error, unable to start ServiceManager.  Cause: " + cause.getClass().getName() + ": " + cause.getMessage();
                throw new IllegalStateException(msg, cause);
            }
        }
        catch (ClassNotFoundException e) {
            String msg = "Enabling option 'openejb.embedded.remotable' requires class 'org.apache.openejb.server.ServiceManager' to be available.  Make sure you have the openejb-server-*.jar in your classpath and at least one protocol implementation such as openejb-ejbd-*.jar.";
            throw new IllegalStateException(msg, e);
        }
        catch (NoSuchMethodException e) {
            String msg = "Option Enabled 'openejb.embedded.remotable'.  Error, 'init' and 'start' methods not found on as expected on class 'org.apache.openejb.server.ServiceManager'.  This should never happen.";
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Option Enabled 'openejb.embedded.remotable'.  Error, 'init' and 'start' methods cannot be accessed on class 'org.apache.openejb.server.ServiceManager'.  The VM SecurityManager settings must be adjusted.";
            throw new IllegalStateException(msg, e);
        }
    }

    private void stopNetworkServices() {
        if (this.serviceManager != null) {
            logger.info("Stopping network services");
            try {
                Method stop = this.serviceManager.getClass().getMethod("stop", new Class[0]);
                stop.invoke(this.serviceManager, new Object[0]);
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Context getContainerSystemEjbContext() throws NamingException {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        Context context = containerSystem.getJNDIContext();
        context = (Context)context.lookup("java:openejb/ejb");
        return context;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Close {
        LOGOUT,
        DESTROY;

    }
}

