/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.jpa.EntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppModule
implements DeploymentModule {
    private final ValidationContext validation;
    private final List<URL> additionalLibraries = new ArrayList<URL>();
    private final List<ConnectorModule> connectorModules = new ArrayList<ConnectorModule>();
    private final List<WebModule> webModules = new ArrayList<WebModule>();
    private final List<ClientModule> clientModules = new ArrayList<ClientModule>();
    private final List<EjbModule> ejbModules = new ArrayList<EjbModule>();
    private final List<PersistenceModule> persistenceModules = new ArrayList<PersistenceModule>();
    private final String jarLocation;
    private final ClassLoader classLoader;
    private EntityMappings cmpMappings;
    private final Map<String, Object> altDDs = new HashMap<String, Object>();
    private final String moduleId;
    private final Set<String> watchedResources = new TreeSet<String>();

    public AppModule(ClassLoader classLoader, String jarLocation) {
        this.classLoader = classLoader;
        this.jarLocation = jarLocation;
        File file = new File(jarLocation);
        this.moduleId = file.getName();
        this.validation = new ValidationContext(AppModule.class, jarLocation);
    }

    @Override
    public ValidationContext getValidation() {
        return this.validation;
    }

    public boolean hasWarnings() {
        if (this.validation.hasWarnings()) {
            return true;
        }
        for (EjbModule ejbModule : this.ejbModules) {
            if (!ejbModule.getValidation().hasWarnings()) continue;
            return true;
        }
        for (ClientModule clientModule : this.clientModules) {
            if (!clientModule.getValidation().hasWarnings()) continue;
            return true;
        }
        for (ConnectorModule connectorModule : this.connectorModules) {
            if (!connectorModule.getValidation().hasWarnings()) continue;
            return true;
        }
        for (WebModule webModule : this.webModules) {
            if (!webModule.getValidation().hasWarnings()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFailures() {
        if (this.validation.hasFailures()) {
            return true;
        }
        for (EjbModule ejbModule : this.ejbModules) {
            if (!ejbModule.getValidation().hasFailures()) continue;
            return true;
        }
        for (ClientModule clientModule : this.clientModules) {
            if (!clientModule.getValidation().hasFailures()) continue;
            return true;
        }
        for (ConnectorModule connectorModule : this.connectorModules) {
            if (!connectorModule.getValidation().hasFailures()) continue;
            return true;
        }
        for (WebModule webModule : this.webModules) {
            if (!webModule.getValidation().hasFailures()) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors() {
        if (this.validation.hasErrors()) {
            return true;
        }
        for (EjbModule ejbModule : this.ejbModules) {
            if (!ejbModule.getValidation().hasErrors()) continue;
            return true;
        }
        for (ClientModule clientModule : this.clientModules) {
            if (!clientModule.getValidation().hasErrors()) continue;
            return true;
        }
        for (ConnectorModule connectorModule : this.connectorModules) {
            if (!connectorModule.getValidation().hasErrors()) continue;
            return true;
        }
        for (WebModule webModule : this.webModules) {
            if (!webModule.getValidation().hasErrors()) continue;
            return true;
        }
        return false;
    }

    public List<ValidationContext> getValidationContexts() {
        ArrayList<ValidationContext> contexts = new ArrayList<ValidationContext>();
        contexts.add(this.getValidation());
        for (EjbModule ejbModule : this.ejbModules) {
            contexts.add(ejbModule.getValidation());
        }
        for (ClientModule clientModule : this.clientModules) {
            contexts.add(clientModule.getValidation());
        }
        for (ConnectorModule connectorModule : this.connectorModules) {
            contexts.add(connectorModule.getValidation());
        }
        for (WebModule webModule : this.webModules) {
            contexts.add(webModule.getValidation());
        }
        return contexts;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public Map<String, Object> getAltDDs() {
        return this.altDDs;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<ClientModule> getClientModules() {
        return this.clientModules;
    }

    public List<EjbModule> getEjbModules() {
        return this.ejbModules;
    }

    public List<PersistenceModule> getPersistenceModules() {
        return this.persistenceModules;
    }

    @Override
    public String getJarLocation() {
        return this.jarLocation;
    }

    public List<URL> getAdditionalLibraries() {
        return this.additionalLibraries;
    }

    public EntityMappings getCmpMappings() {
        return this.cmpMappings;
    }

    public void setCmpMappings(EntityMappings cmpMappings) {
        this.cmpMappings = cmpMappings;
    }

    public List<ConnectorModule> getResourceModules() {
        return this.connectorModules;
    }

    public List<WebModule> getWebModules() {
        return this.webModules;
    }

    @Override
    public Set<String> getWatchedResources() {
        return this.watchedResources;
    }

    public Collection<DeploymentModule> getDeploymentModule() {
        ArrayList<DeploymentModule> modules = new ArrayList<DeploymentModule>();
        modules.addAll(this.ejbModules);
        modules.addAll(this.webModules);
        modules.addAll(this.connectorModules);
        modules.addAll(this.clientModules);
        return modules;
    }
}

