/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.jee.Connector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorModule
implements DeploymentModule {
    private final ValidationContext validation;
    private final Map<String, Object> altDDs = new HashMap<String, Object>();
    private Connector connector;
    private ClassLoader classLoader;
    private String jarLocation;
    private final String moduleId;
    private final List<URL> libraries = new ArrayList<URL>();
    private final Set<String> watchedResources = new TreeSet<String>();

    public ConnectorModule(Connector connector) {
        this(connector, Thread.currentThread().getContextClassLoader(), null, null);
    }

    public ConnectorModule(Connector connector, ClassLoader classLoader, String jarLocation, String moduleId) {
        this.connector = connector;
        this.classLoader = classLoader;
        this.jarLocation = jarLocation;
        if (moduleId == null) {
            if (connector != null && connector.getId() != null) {
                moduleId = connector.getId();
            } else {
                File file = new File(jarLocation);
                moduleId = file.getName();
                if (moduleId.endsWith(".unpacked")) {
                    moduleId = moduleId.substring(0, moduleId.length() - ".unpacked".length());
                }
                if (moduleId.endsWith(".rar")) {
                    moduleId = moduleId.substring(0, moduleId.length() - ".rar".length());
                }
            }
        }
        this.moduleId = moduleId;
        this.validation = new ValidationContext(ConnectorModule.class, jarLocation);
    }

    @Override
    public ValidationContext getValidation() {
        return this.validation;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public Map<String, Object> getAltDDs() {
        return this.altDDs;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getJarLocation() {
        return this.jarLocation;
    }

    public void setJarLocation(String jarLocation) {
        this.jarLocation = jarLocation;
    }

    public List<URL> getLibraries() {
        return this.libraries;
    }

    @Override
    public Set<String> getWatchedResources() {
        return this.watchedResources;
    }
}

