/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.ApplicationExceptionInfo;
import org.apache.openejb.assembler.classic.CallbackInfo;
import org.apache.openejb.assembler.classic.CmrFieldInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.EntityBeanInfo;
import org.apache.openejb.assembler.classic.InitMethodInfo;
import org.apache.openejb.assembler.classic.InterceptorBindingInfo;
import org.apache.openejb.assembler.classic.InterceptorInfo;
import org.apache.openejb.assembler.classic.JndiNameInfo;
import org.apache.openejb.assembler.classic.MessageDrivenBeanInfo;
import org.apache.openejb.assembler.classic.MethodConcurrencyInfo;
import org.apache.openejb.assembler.classic.MethodInfo;
import org.apache.openejb.assembler.classic.MethodPermissionInfo;
import org.apache.openejb.assembler.classic.MethodTransactionInfo;
import org.apache.openejb.assembler.classic.NamedMethodInfo;
import org.apache.openejb.assembler.classic.QueryInfo;
import org.apache.openejb.assembler.classic.RemoveMethodInfo;
import org.apache.openejb.assembler.classic.SecurityRoleInfo;
import org.apache.openejb.assembler.classic.SecurityRoleReferenceInfo;
import org.apache.openejb.assembler.classic.SingletonBeanInfo;
import org.apache.openejb.assembler.classic.StatefulBeanInfo;
import org.apache.openejb.assembler.classic.StatelessBeanInfo;
import org.apache.openejb.config.ConfigUtils;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.ActivationConfig;
import org.apache.openejb.jee.ActivationConfigProperty;
import org.apache.openejb.jee.ApplicationException;
import org.apache.openejb.jee.CallbackMethod;
import org.apache.openejb.jee.CmpField;
import org.apache.openejb.jee.CmpVersion;
import org.apache.openejb.jee.ConcurrencyType;
import org.apache.openejb.jee.ContainerConcurrency;
import org.apache.openejb.jee.ContainerTransaction;
import org.apache.openejb.jee.EjbRelation;
import org.apache.openejb.jee.EjbRelationshipRole;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.ExcludeList;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.InitMethod;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.InterceptorBinding;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.Method;
import org.apache.openejb.jee.MethodParams;
import org.apache.openejb.jee.MethodPermission;
import org.apache.openejb.jee.Multiplicity;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.PersistenceType;
import org.apache.openejb.jee.Query;
import org.apache.openejb.jee.QueryMethod;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.RemoveMethod;
import org.apache.openejb.jee.ResultTypeMapping;
import org.apache.openejb.jee.SecurityRole;
import org.apache.openejb.jee.SecurityRoleRef;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.Jndi;
import org.apache.openejb.jee.oejb3.ResourceLink;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarInfoBuilder {
    public static Messages messages = new Messages("org.apache.openejb.util.resources");
    public static Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final List<String> deploymentIds = new ArrayList<String>();
    private final List<String> securityRoles = new ArrayList<String>();

    public EjbJarInfo buildInfo(EjbModule jar) throws OpenEJBException {
        this.deploymentIds.clear();
        this.securityRoles.clear();
        int beansDeployed = jar.getOpenejbJar().getEjbDeploymentCount();
        int beansInEjbJar = jar.getEjbJar().getEnterpriseBeans().length;
        if (beansInEjbJar != beansDeployed) {
            Map deployed = jar.getOpenejbJar().getDeploymentsByEjbName();
            for (EnterpriseBean bean : jar.getEjbJar().getEnterpriseBeans()) {
                if (deployed.containsKey(bean.getEjbName())) continue;
                ConfigUtils.logger.warning("conf.0018", bean.getEjbName(), jar.getJarLocation());
            }
            String message = messages.format("conf.0008", jar.getJarLocation(), "" + beansInEjbJar, "" + beansDeployed);
            logger.warning(message);
            throw new OpenEJBException(message);
        }
        Map ejbds = jar.getOpenejbJar().getDeploymentsByEjbName();
        HashMap<String, EnterpriseBeanInfo> infos = new HashMap<String, EnterpriseBeanInfo>();
        HashMap<String, EnterpriseBean> items = new HashMap<String, EnterpriseBean>();
        EjbJarInfo ejbJar = new EjbJarInfo();
        ejbJar.jarPath = jar.getJarLocation();
        ejbJar.moduleId = jar.getModuleId();
        if (ejbJar.moduleId == null) {
            ejbJar.moduleId = new File(ejbJar.jarPath).getName().replaceFirst(".jar$", "");
        }
        ejbJar.watchedResources.addAll(jar.getWatchedResources());
        ejbJar.properties.putAll((Map<?, ?>)jar.getOpenejbJar().getProperties());
        for (EnterpriseBean bean : jar.getEjbJar().getEnterpriseBeans()) {
            EnterpriseBeanInfo beanInfo;
            if (bean instanceof SessionBean) {
                beanInfo = this.initSessionBean((SessionBean)bean, ejbds);
            } else if (bean instanceof EntityBean) {
                beanInfo = this.initEntityBean((EntityBean)bean, ejbds);
            } else if (bean instanceof MessageDrivenBean) {
                beanInfo = this.initMessageBean((MessageDrivenBean)bean, ejbds);
            } else {
                throw new OpenEJBException("Unknown bean type: " + bean.getClass().getName());
            }
            ejbJar.enterpriseBeans.add(beanInfo);
            if (this.deploymentIds.contains(beanInfo.ejbDeploymentId)) {
                String message = messages.format("conf.0100", beanInfo.ejbDeploymentId, jar.getJarLocation(), beanInfo.ejbName);
                logger.warning(message);
                throw new OpenEJBException(message);
            }
            this.deploymentIds.add(beanInfo.ejbDeploymentId);
            beanInfo.codebase = jar.getJarLocation();
            infos.put(beanInfo.ejbName, beanInfo);
            items.put(beanInfo.ejbName, bean);
            if (bean.getSecurityIdentity() != null) {
                beanInfo.runAs = bean.getSecurityIdentity().getRunAs();
            }
            this.initJndiNames(ejbds, bean, beanInfo);
        }
        if (jar.getEjbJar().getAssemblyDescriptor() != null) {
            this.initInterceptors(jar, ejbJar, infos);
            this.initSecurityRoles(jar, ejbJar);
            this.initMethodPermissions(jar, ejbds, ejbJar);
            this.initExcludesList(jar, ejbds, ejbJar);
            this.initMethodTransactions(jar, ejbds, ejbJar);
            this.initMethodConcurrency(jar, ejbds, ejbJar);
            this.initApplicationExceptions(jar, ejbJar);
            for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                this.resolveRoleLinks(jar, bean, (JndiConsumer)items.get(bean.ejbName));
            }
        }
        if (jar.getEjbJar().getRelationships() != null) {
            this.initRelationships(jar, infos);
        }
        return ejbJar;
    }

    private void initJndiNames(Map<String, EjbDeployment> ejbds, EnterpriseBean bean, EnterpriseBeanInfo info) {
        EjbDeployment deployment = ejbds.get(info.ejbName);
        if (deployment != null) {
            for (Jndi jndi : deployment.getJndi()) {
                JndiNameInfo jndiNameInfo = new JndiNameInfo();
                jndiNameInfo.intrface = jndi.getInterface();
                jndiNameInfo.name = jndi.getName();
                info.jndiNamess.add(jndiNameInfo);
            }
        }
    }

    private void initRelationships(EjbModule jar, Map<String, EnterpriseBeanInfo> infos) throws OpenEJBException {
        for (EjbRelation ejbRelation : jar.getEjbJar().getRelationships().getEjbRelation()) {
            CmrFieldInfo rightCmrFieldInfo;
            Iterator iterator = ejbRelation.getEjbRelationshipRole().iterator();
            EjbRelationshipRole left = (EjbRelationshipRole)iterator.next();
            EjbRelationshipRole right = (EjbRelationshipRole)iterator.next();
            CmrFieldInfo leftCmrFieldInfo = this.initRelationshipRole(left, right, infos);
            leftCmrFieldInfo.mappedBy = rightCmrFieldInfo = this.initRelationshipRole(right, left, infos);
            rightCmrFieldInfo.mappedBy = leftCmrFieldInfo;
        }
    }

    private CmrFieldInfo initRelationshipRole(EjbRelationshipRole role, EjbRelationshipRole relatedRole, Map<String, EnterpriseBeanInfo> infos) throws OpenEJBException {
        EntityBeanInfo entityBeanInfo;
        CmrFieldInfo cmrFieldInfo = new CmrFieldInfo();
        String ejbName = role.getRelationshipRoleSource().getEjbName();
        EnterpriseBeanInfo enterpriseBeanInfo = infos.get(ejbName);
        if (enterpriseBeanInfo == null) {
            throw new OpenEJBException("Relation role source ejb not found " + ejbName);
        }
        if (!(enterpriseBeanInfo instanceof EntityBeanInfo)) {
            throw new OpenEJBException("Relation role source ejb is not an entity bean " + ejbName);
        }
        cmrFieldInfo.roleSource = entityBeanInfo = (EntityBeanInfo)enterpriseBeanInfo;
        cmrFieldInfo.roleName = role.getEjbRelationshipRoleName();
        boolean bl = cmrFieldInfo.synthetic = role.getCmrField() == null;
        if (role.getCmrField() != null) {
            cmrFieldInfo.fieldName = role.getCmrField().getCmrFieldName();
            if (role.getCmrField().getCmrFieldType() != null) {
                cmrFieldInfo.fieldType = role.getCmrField().getCmrFieldType().toString();
            }
        } else {
            String relatedEjbName = relatedRole.getRelationshipRoleSource().getEjbName();
            EnterpriseBeanInfo relatedEjb = infos.get(relatedEjbName);
            if (relatedEjb == null) {
                throw new OpenEJBException("Relation role source ejb not found " + relatedEjbName);
            }
            if (!(relatedEjb instanceof EntityBeanInfo)) {
                throw new OpenEJBException("Relation role source ejb is not an entity bean " + relatedEjbName);
            }
            EntityBeanInfo relatedEntity = (EntityBeanInfo)relatedEjb;
            relatedRole.getRelationshipRoleSource();
            cmrFieldInfo.fieldName = relatedEntity.abstractSchemaName + "_" + relatedRole.getCmrField().getCmrFieldName();
            if (relatedRole.getMultiplicity() == Multiplicity.MANY) {
                cmrFieldInfo.fieldType = Collection.class.getName();
            }
        }
        cmrFieldInfo.cascadeDelete = role.getCascadeDelete();
        cmrFieldInfo.many = role.getMultiplicity() == Multiplicity.MANY;
        entityBeanInfo.cmrFields.add(cmrFieldInfo);
        return cmrFieldInfo;
    }

    private void initInterceptors(EjbModule jar, EjbJarInfo ejbJar, Map<String, EnterpriseBeanInfo> beanInfos) throws OpenEJBException {
        if (jar.getEjbJar().getInterceptors().length == 0) {
            return;
        }
        if (jar.getEjbJar().getAssemblyDescriptor() == null) {
            return;
        }
        if (jar.getEjbJar().getAssemblyDescriptor().getInterceptorBinding() == null) {
            return;
        }
        for (Interceptor s : jar.getEjbJar().getInterceptors()) {
            InterceptorInfo info = new InterceptorInfo();
            info.clazz = s.getInterceptorClass();
            this.copyCallbacks(s.getAroundInvoke(), info.aroundInvoke);
            this.copyCallbacks(s.getPostConstruct(), info.postConstruct);
            this.copyCallbacks(s.getPreDestroy(), info.preDestroy);
            this.copyCallbacks(s.getPostActivate(), info.postActivate);
            this.copyCallbacks(s.getPrePassivate(), info.prePassivate);
            ejbJar.interceptors.add(info);
        }
        for (InterceptorBinding binding : jar.getEjbJar().getAssemblyDescriptor().getInterceptorBinding()) {
            InterceptorBindingInfo info = new InterceptorBindingInfo();
            info.ejbName = binding.getEjbName();
            info.excludeClassInterceptors = binding.getExcludeClassInterceptors();
            info.excludeDefaultInterceptors = binding.getExcludeDefaultInterceptors();
            info.interceptors.addAll(binding.getInterceptorClass());
            if (binding.getInterceptorOrder() != null) {
                info.interceptorOrder.addAll(binding.getInterceptorOrder().getInterceptorClass());
            }
            info.method = this.toInfo(binding.getMethod());
            ejbJar.interceptorBindings.add(info);
        }
    }

    private void initMethodTransactions(EjbModule jar, Map ejbds, EjbJarInfo ejbJarInfo) {
        List containerTransactions = jar.getEjbJar().getAssemblyDescriptor().getContainerTransaction();
        for (ContainerTransaction cTx : containerTransactions) {
            MethodTransactionInfo info = new MethodTransactionInfo();
            info.description = cTx.getDescription();
            info.transAttribute = cTx.getTransAttribute().toString();
            info.methods.addAll(this.getMethodInfos(cTx.getMethod(), ejbds));
            ejbJarInfo.methodTransactions.add(info);
        }
    }

    private void initMethodConcurrency(EjbModule jar, Map ejbds, EjbJarInfo ejbJarInfo) {
        List containerConcurrency = jar.getEjbJar().getAssemblyDescriptor().getContainerConcurrency();
        for (ContainerConcurrency att : containerConcurrency) {
            MethodConcurrencyInfo info = new MethodConcurrencyInfo();
            info.description = att.getDescription();
            info.concurrencyAttribute = att.getConcurrencyAttribute().toString();
            info.methods.addAll(this.getMethodInfos(att.getMethod(), ejbds));
            ejbJarInfo.methodConcurrency.add(info);
        }
    }

    private void initApplicationExceptions(EjbModule jar, EjbJarInfo ejbJarInfo) {
        for (ApplicationException applicationException : jar.getEjbJar().getAssemblyDescriptor().getApplicationException()) {
            ApplicationExceptionInfo info = new ApplicationExceptionInfo();
            info.exceptionClass = applicationException.getExceptionClass();
            info.rollback = applicationException.getRollback();
            ejbJarInfo.applicationException.add(info);
        }
    }

    private void initSecurityRoles(EjbModule jar, EjbJarInfo ejbJarInfo) {
        List roles = jar.getEjbJar().getAssemblyDescriptor().getSecurityRole();
        for (SecurityRole sr : roles) {
            SecurityRoleInfo info = new SecurityRoleInfo();
            info.description = sr.getDescription();
            info.roleName = sr.getRoleName();
            if (this.securityRoles.contains(sr.getRoleName())) {
                ConfigUtils.logger.warning("conf.0102", jar.getJarLocation(), sr.getRoleName());
            } else {
                this.securityRoles.add(sr.getRoleName());
            }
            ejbJarInfo.securityRoles.add(info);
        }
    }

    private void initMethodPermissions(EjbModule jar, Map ejbds, EjbJarInfo ejbJarInfo) {
        List methodPermissions = jar.getEjbJar().getAssemblyDescriptor().getMethodPermission();
        for (MethodPermission mp : methodPermissions) {
            MethodPermissionInfo info = new MethodPermissionInfo();
            info.description = mp.getDescription();
            info.roleNames.addAll(mp.getRoleName());
            info.methods.addAll(this.getMethodInfos(mp.getMethod(), ejbds));
            info.unchecked = mp.getUnchecked();
            ejbJarInfo.methodPermissions.add(info);
        }
    }

    private void initExcludesList(EjbModule jar, Map ejbds, EjbJarInfo ejbJarInfo) {
        ExcludeList methodPermissions = jar.getEjbJar().getAssemblyDescriptor().getExcludeList();
        for (Method excludedMethod : methodPermissions.getMethod()) {
            ejbJarInfo.excludeList.add(this.getMethodInfo(excludedMethod, ejbds));
        }
    }

    private void resolveRoleLinks(EjbModule jar, EnterpriseBeanInfo bean, JndiConsumer item) {
        if (!(item instanceof RemoteBean)) {
            return;
        }
        RemoteBean rb = (RemoteBean)item;
        List refs = rb.getSecurityRoleRef();
        for (SecurityRoleRef ref : refs) {
            SecurityRoleReferenceInfo info = new SecurityRoleReferenceInfo();
            info.description = ref.getDescription();
            info.roleLink = ref.getRoleLink();
            info.roleName = ref.getRoleName();
            if (info.roleLink == null) {
                info.roleLink = info.roleName;
            }
            bean.securityRoleReferences.add(info);
        }
    }

    private List<MethodInfo> getMethodInfos(List<Method> ms, Map ejbds) {
        if (ms == null) {
            return Collections.emptyList();
        }
        ArrayList<MethodInfo> mi = new ArrayList<MethodInfo>(ms.size());
        for (Method method : ms) {
            MethodInfo methodInfo = this.getMethodInfo(method, ejbds);
            mi.add(methodInfo);
        }
        return mi;
    }

    private MethodInfo getMethodInfo(Method method, Map ejbds) {
        MethodParams mp;
        MethodInfo methodInfo = new MethodInfo();
        EjbDeployment d = (EjbDeployment)ejbds.get(method.getEjbName());
        methodInfo.description = method.getDescription();
        methodInfo.ejbDeploymentId = d == null ? null : d.getDeploymentId();
        methodInfo.ejbName = method.getEjbName();
        methodInfo.methodIntf = method.getMethodIntf() == null ? null : method.getMethodIntf().toString();
        methodInfo.methodName = method.getMethodName();
        if (methodInfo.methodName == null || methodInfo.methodName.equals("")) {
            methodInfo.methodName = "*";
        }
        methodInfo.className = method.getClassName();
        if (methodInfo.className == null || methodInfo.className.equals("")) {
            methodInfo.className = "*";
        }
        if ((mp = method.getMethodParams()) != null) {
            methodInfo.methodParams = mp.getMethodParam();
        }
        return methodInfo;
    }

    private EnterpriseBeanInfo initSessionBean(SessionBean s, Map m) throws OpenEJBException {
        EnterpriseBeanInfo bean = null;
        if (s.getSessionType() == SessionType.STATEFUL) {
            StatefulBeanInfo stateful = bean = new StatefulBeanInfo();
            this.copyCallbacks(s.getPostActivate(), stateful.postActivate);
            this.copyCallbacks(s.getPrePassivate(), stateful.prePassivate);
            for (InitMethod initMethod : s.getInitMethod()) {
                InitMethodInfo init = new InitMethodInfo();
                init.beanMethod = this.toInfo(initMethod.getBeanMethod());
                init.createMethod = this.toInfo(initMethod.getCreateMethod());
                stateful.initMethods.add(init);
            }
            for (RemoveMethod removeMethod : s.getRemoveMethod()) {
                RemoveMethodInfo remove = new RemoveMethodInfo();
                remove.beanMethod = this.toInfo(removeMethod.getBeanMethod());
                remove.retainIfException = removeMethod.getRetainIfException();
                stateful.removeMethods.add(remove);
            }
        } else if (s.getSessionType() == SessionType.SINGLETON) {
            bean = new SingletonBeanInfo();
            ConcurrencyType type = s.getConcurrencyType();
            bean.concurrencyType = type != null ? type.toString() : ConcurrencyType.CONTAINER.toString();
            bean.loadOnStartup = s.getLoadOnStartup();
        } else {
            bean = new StatelessBeanInfo();
        }
        bean.timeoutMethod = this.toInfo(s.getTimeoutMethod());
        this.copyCallbacks(s.getAroundInvoke(), bean.aroundInvoke);
        this.copyCallbacks(s.getPostConstruct(), bean.postConstruct);
        this.copyCallbacks(s.getPreDestroy(), bean.preDestroy);
        EjbDeployment d = (EjbDeployment)m.get(s.getEjbName());
        if (d == null) {
            throw new OpenEJBException("No deployment information in openejb-jar.xml for bean " + s.getEjbName() + ". Please redeploy the jar");
        }
        bean.ejbDeploymentId = d.getDeploymentId();
        bean.containerId = d.getContainerId();
        Icon icon = s.getIcon();
        bean.largeIcon = icon == null ? null : icon.getLargeIcon();
        bean.smallIcon = icon == null ? null : icon.getSmallIcon();
        bean.description = s.getDescription();
        bean.displayName = s.getDisplayName();
        bean.ejbClass = s.getEjbClass();
        bean.ejbName = s.getEjbName();
        bean.home = s.getHome();
        bean.remote = s.getRemote();
        bean.localHome = s.getLocalHome();
        bean.local = s.getLocal();
        bean.businessLocal.addAll(s.getBusinessLocal());
        bean.businessRemote.addAll(s.getBusinessRemote());
        TransactionType txType = s.getTransactionType();
        bean.transactionType = txType != null ? txType.toString() : TransactionType.CONTAINER.toString();
        bean.serviceEndpoint = s.getServiceEndpoint();
        return bean;
    }

    private EnterpriseBeanInfo initMessageBean(MessageDrivenBean mdb, Map m) throws OpenEJBException {
        ActivationConfig activationConfig;
        MessageDrivenBeanInfo bean = new MessageDrivenBeanInfo();
        bean.timeoutMethod = this.toInfo(mdb.getTimeoutMethod());
        this.copyCallbacks(mdb.getAroundInvoke(), bean.aroundInvoke);
        this.copyCallbacks(mdb.getPostConstruct(), bean.postConstruct);
        this.copyCallbacks(mdb.getPreDestroy(), bean.preDestroy);
        EjbDeployment d = (EjbDeployment)m.get(mdb.getEjbName());
        if (d == null) {
            throw new OpenEJBException("No deployment information in openejb-jar.xml for bean " + mdb.getEjbName() + ". Please redeploy the jar");
        }
        bean.ejbDeploymentId = d.getDeploymentId();
        bean.containerId = d.getContainerId();
        Icon icon = mdb.getIcon();
        bean.largeIcon = icon == null ? null : icon.getLargeIcon();
        bean.smallIcon = icon == null ? null : icon.getSmallIcon();
        bean.description = mdb.getDescription();
        bean.displayName = mdb.getDisplayName();
        bean.ejbClass = mdb.getEjbClass();
        bean.ejbName = mdb.getEjbName();
        TransactionType txType = mdb.getTransactionType();
        bean.transactionType = txType != null ? txType.toString() : TransactionType.CONTAINER.toString();
        bean.mdbInterface = mdb.getMessagingType() != null ? mdb.getMessagingType() : "javax.jms.MessageListener";
        ResourceLink resourceLink = d.getResourceLink("openejb/destination");
        if (resourceLink != null) {
            bean.destinationId = resourceLink.getResId();
        }
        if (mdb.getMessageDestinationType() != null) {
            bean.activationProperties.put("destinationType", mdb.getMessageDestinationType());
        }
        if ((activationConfig = mdb.getActivationConfig()) != null) {
            for (ActivationConfigProperty property : activationConfig.getActivationConfigProperty()) {
                String name = property.getActivationConfigPropertyName();
                String value = property.getActivationConfigPropertyValue();
                bean.activationProperties.put(name, value);
            }
        }
        return bean;
    }

    private NamedMethodInfo toInfo(NamedMethod method) {
        if (method == null) {
            return null;
        }
        NamedMethodInfo info = new NamedMethodInfo();
        info.methodName = method.getMethodName();
        if (method.getMethodParams() != null) {
            info.methodParams = method.getMethodParams().getMethodParam();
        }
        return info;
    }

    private void copyCallbacks(List<? extends CallbackMethod> from, List<CallbackInfo> to) {
        for (CallbackMethod callbackMethod : from) {
            CallbackInfo info = new CallbackInfo();
            info.className = callbackMethod.getClassName();
            info.method = callbackMethod.getMethodName();
            to.add(info);
        }
    }

    private EnterpriseBeanInfo initEntityBean(EntityBean e, Map m) throws OpenEJBException {
        EntityBeanInfo bean = new EntityBeanInfo();
        EjbDeployment d = (EjbDeployment)m.get(e.getEjbName());
        if (d == null) {
            throw new OpenEJBException("No deployment information in openejb-jar.xml for bean " + e.getEjbName() + ". Please redeploy the jar");
        }
        bean.ejbDeploymentId = d.getDeploymentId();
        bean.containerId = d.getContainerId();
        Icon icon = e.getIcon();
        bean.largeIcon = icon == null ? null : icon.getLargeIcon();
        bean.smallIcon = icon == null ? null : icon.getSmallIcon();
        bean.description = e.getDescription();
        bean.displayName = e.getDisplayName();
        bean.ejbClass = e.getEjbClass();
        bean.abstractSchemaName = e.getAbstractSchemaName();
        bean.ejbName = e.getEjbName();
        bean.home = e.getHome();
        bean.remote = e.getRemote();
        bean.localHome = e.getLocalHome();
        bean.local = e.getLocal();
        bean.transactionType = "Container";
        bean.primKeyClass = e.getPrimKeyClass();
        bean.primKeyField = e.getPrimkeyField();
        bean.persistenceType = e.getPersistenceType().toString();
        bean.reentrant = e.getReentrant() + "";
        CmpVersion cmpVersion = e.getCmpVersion();
        if (e.getPersistenceType() == PersistenceType.CONTAINER) {
            bean.cmpVersion = cmpVersion != null && cmpVersion == CmpVersion.CMP1 ? 1 : 2;
        }
        List cmpFields = e.getCmpField();
        for (CmpField cmpField : cmpFields) {
            bean.cmpFieldNames.add(cmpField.getFieldName());
        }
        if (bean.persistenceType.equalsIgnoreCase("Container")) {
            QueryMethod qm;
            MethodInfo method;
            QueryInfo query;
            for (Query q : e.getQuery()) {
                query = new QueryInfo();
                query.queryStatement = q.getEjbQl().trim();
                method = new MethodInfo();
                method.ejbName = bean.ejbName;
                method.className = "*";
                qm = q.getQueryMethod();
                method.methodName = qm.getMethodName();
                if (qm.getMethodParams() != null) {
                    method.methodParams = qm.getMethodParams().getMethodParam();
                }
                query.method = method;
                ResultTypeMapping resultType = q.getResultTypeMapping();
                if (ResultTypeMapping.REMOTE.equals((Object)resultType)) {
                    query.remoteResultType = true;
                }
                bean.queries.add(query);
            }
            for (Query q : d.getQuery()) {
                query = new QueryInfo();
                query.description = q.getDescription();
                query.queryStatement = q.getObjectQl().trim();
                method = new MethodInfo();
                method.ejbName = bean.ejbName;
                method.className = "*";
                qm = q.getQueryMethod();
                method.methodName = qm.getMethodName();
                if (qm.getMethodParams() != null) {
                    method.methodParams = qm.getMethodParams().getMethodParam();
                }
                query.method = method;
                bean.queries.add(query);
            }
        }
        return bean;
    }
}

