/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.WsModule;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.Webservices;
import org.apache.openejb.jee.oejb3.OpenejbJar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbModule
implements WsModule {
    private final ValidationContext validation;
    private ClassLoader classLoader;
    private String jarLocation;
    private EjbJar ejbJar;
    private OpenejbJar openejbJar;
    private Webservices webservices;
    private String moduleId;
    private final Map<String, Object> altDDs = new HashMap<String, Object>();
    private final Set<String> watchedResources = new TreeSet<String>();

    public EjbModule(EjbJar ejbJar) {
        this(Thread.currentThread().getContextClassLoader(), null, ejbJar, null);
    }

    public EjbModule(EjbJar ejbJar, OpenejbJar openejbJar) {
        this(Thread.currentThread().getContextClassLoader(), null, ejbJar, openejbJar);
    }

    public EjbModule(ClassLoader classLoader, String moduleId, String jarURI, EjbJar ejbJar, OpenejbJar openejbJar) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        this.classLoader = classLoader;
        this.ejbJar = ejbJar;
        this.openejbJar = openejbJar;
        if (jarURI == null) {
            jarURI = moduleId != null ? moduleId : (ejbJar.getId() != null && !ejbJar.getId().equals("") ? ejbJar.getId() : ejbJar.toString());
        }
        this.jarLocation = jarURI;
        if (moduleId == null) {
            if (ejbJar != null && ejbJar.getId() != null && !ejbJar.getId().equals("")) {
                moduleId = ejbJar.getId();
            } else {
                File file = new File(jarURI);
                moduleId = file.getName();
                if (moduleId == null) {
                    moduleId = jarURI;
                }
            }
        }
        this.moduleId = moduleId;
        this.validation = new ValidationContext(EjbModule.class, this.jarLocation);
    }

    public EjbModule(ClassLoader classLoader, String jarURI, EjbJar ejbJar, OpenejbJar openejbJar) {
        this(classLoader, null, jarURI, ejbJar, openejbJar);
    }

    @Override
    public ValidationContext getValidation() {
        return this.validation;
    }

    @Override
    public Map<String, Object> getAltDDs() {
        return this.altDDs;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public EjbJar getEjbJar() {
        return this.ejbJar;
    }

    public void setEjbJar(EjbJar ejbJar) {
        this.ejbJar = ejbJar;
    }

    @Override
    public String getJarLocation() {
        return this.jarLocation;
    }

    public void setJarLocation(String jarLocation) {
        this.jarLocation = jarLocation;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public OpenejbJar getOpenejbJar() {
        return this.openejbJar;
    }

    public void setOpenejbJar(OpenejbJar openejbJar) {
        this.openejbJar = openejbJar;
    }

    @Override
    public Webservices getWebservices() {
        return this.webservices;
    }

    @Override
    public void setWebservices(Webservices webservices) {
        this.webservices = webservices;
    }

    @Override
    public Set<String> getWatchedResources() {
        return this.watchedResources;
    }
}

