/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.EnterpriseBean;

public class GeronimoMappedName
implements DynamicDeployer {
    private static final String MAPPED_NAME_PREFIX = "jndi:java:comp/geronimo/env/";

    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        this.mapReferences(appModule);
        return appModule;
    }

    private void mapReferences(AppModule appModule) {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            this.mapReferences(ejbModule.getEjbJar());
        }
    }

    private void mapReferences(EjbJar ejbJar) {
        if (ejbJar == null) {
            return;
        }
        for (EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
            String refName;
            for (EjbRef ref : enterpriseBean.getEjbRef()) {
                String mappedName = ref.getMappedName();
                if (mappedName != null && (mappedName.startsWith("jndi:corbaloc") || mappedName.startsWith("jndi:corbaname"))) {
                    String refName2 = ref.getEjbRefName();
                    ref.setMappedName(MAPPED_NAME_PREFIX + refName2);
                }
                if (null != mappedName || !ref.getEjbRefName().equals("ejb/MEJB")) continue;
                ref.setMappedName("mejb/ejb/mgmt/MEJB");
            }
            for (EjbRef ref : enterpriseBean.getMessageDestinationRef()) {
                refName = ref.getMessageDestinationRefName();
                ref.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
            for (EjbRef ref : enterpriseBean.getPersistenceContextRef()) {
                refName = ref.getPersistenceContextRefName();
                ref.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
            for (EjbRef ref : enterpriseBean.getPersistenceUnitRef()) {
                refName = ref.getPersistenceUnitRefName();
                ref.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
            for (EjbRef ref : enterpriseBean.getResourceRef()) {
                refName = ref.getResRefName();
                ref.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
            for (EjbRef ref : enterpriseBean.getResourceEnvRef()) {
                refName = ref.getResourceEnvRefName();
                ref.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
            for (EjbRef ref : enterpriseBean.getServiceRef()) {
                refName = ref.getServiceRefName();
                ref.setMappedName(MAPPED_NAME_PREFIX + refName);
            }
        }
    }
}

