/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.PersistenceType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.codehaus.swizzle.stream.StringTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitEjbDeployments
implements DynamicDeployer {
    public static Messages messages = new Messages("org.apache.openejb.util.resources");
    public static Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final StringTemplate deploymentIdTemplate;
    private static final String DEPLOYMENT_ID_FORMAT = "openejb.deploymentId.format";

    public InitEjbDeployments() {
        String format = SystemInstance.get().getProperty(DEPLOYMENT_ID_FORMAT, "{ejbName}");
        this.deploymentIdTemplate = new StringTemplate(format);
    }

    @Override
    public synchronized AppModule deploy(AppModule appModule) throws OpenEJBException {
        HashMap<String, String> contextData = new HashMap<String, String>();
        contextData.put("appId", appModule.getModuleId());
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            contextData.put("ejbJarId", ejbModule.getModuleId());
            this.deploy(ejbModule, contextData);
        }
        contextData.clear();
        return appModule;
    }

    public EjbModule deploy(EjbModule ejbModule, Map<String, String> contextData) throws OpenEJBException {
        OpenejbJar openejbJar;
        contextData.put("moduleId", ejbModule.getModuleId());
        if (ejbModule.getOpenejbJar() != null) {
            openejbJar = ejbModule.getOpenejbJar();
        } else {
            openejbJar = new OpenejbJar();
            ejbModule.setOpenejbJar(openejbJar);
        }
        StringTemplate deploymentIdTemplate = this.deploymentIdTemplate;
        if (openejbJar.getProperties().containsKey(DEPLOYMENT_ID_FORMAT)) {
            String format = openejbJar.getProperties().getProperty(DEPLOYMENT_ID_FORMAT);
            logger.info("Using openejb.deploymentId.format '" + format + "'");
            deploymentIdTemplate = new StringTemplate(format);
        }
        for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            EntityBean entity;
            EjbDeployment ejbDeployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(bean.getEjbName());
            if (ejbDeployment == null) {
                ejbDeployment = new EjbDeployment();
                ejbDeployment.setEjbName(bean.getEjbName());
                ejbDeployment.setDeploymentId(this.autoAssignDeploymentId(bean, contextData, deploymentIdTemplate));
                logger.info("Auto-deploying ejb " + bean.getEjbName() + ": EjbDeployment(deployment-id=" + ejbDeployment.getDeploymentId() + ")");
                openejbJar.getEjbDeployment().add(ejbDeployment);
            } else if (ejbDeployment.getDeploymentId() == null) {
                ejbDeployment.setDeploymentId(this.autoAssignDeploymentId(bean, contextData, deploymentIdTemplate));
                logger.info("Auto-assigning deployment-id for ejb " + bean.getEjbName() + ": EjbDeployment(deployment-id=" + ejbDeployment.getDeploymentId() + ")");
            }
            if (!InitEjbDeployments.isCmpEntity(bean) || (entity = (EntityBean)bean).getAbstractSchemaName() != null) continue;
            String abstractSchemaName = bean.getEjbName().trim().replaceAll("[ \\t\\n\\r-]+", "_");
            entity.setAbstractSchemaName(abstractSchemaName);
        }
        return ejbModule;
    }

    private static boolean isCmpEntity(EnterpriseBean bean) {
        return bean instanceof EntityBean && ((EntityBean)bean).getPersistenceType() == PersistenceType.CONTAINER;
    }

    private String autoAssignDeploymentId(EnterpriseBean bean, Map<String, String> contextData, StringTemplate template) {
        contextData.put("ejbType", bean.getClass().getSimpleName());
        contextData.put("ejbClass", bean.getClass().getName());
        contextData.put("ejbClass.simpleName", bean.getClass().getSimpleName());
        contextData.put("ejbName", bean.getEjbName());
        return template.apply(contextData);
    }
}

