/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.core.webservices.WsdlResolver;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.FacesConfig;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.Webservices;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.unit.JaxbPersistenceFactory;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.oejb2.EnterpriseBean;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.openejb.jee.oejb2.JaxbOpenejbJar2;
import org.apache.openejb.jee.oejb2.OpenejbJarType;
import org.apache.openejb.jee.oejb2.RpcBean;
import org.apache.openejb.jee.oejb2.SessionBeanType;
import org.apache.openejb.jee.oejb2.TssLinkType;
import org.apache.openejb.jee.oejb2.WebServiceBindingType;
import org.apache.openejb.jee.oejb3.JaxbOpenejbJar3;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.util.URLs;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadDescriptors
implements DynamicDeployer {
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            if (ejbModule.getEjbJar() == null) {
                this.readEjbJar(ejbModule, appModule);
            }
            if (ejbModule.getOpenejbJar() == null) {
                this.readOpenejbJar(ejbModule);
            }
            this.readCmpOrm(ejbModule);
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            this.readAppClient(clientModule, appModule);
        }
        for (ConnectorModule connectorModule : appModule.getResourceModules()) {
            this.readConnector(connectorModule, appModule);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            this.readWebApp(webModule, appModule);
        }
        List persistenceUrls = (List)appModule.getAltDDs().get("persistence.xml");
        if (persistenceUrls != null) {
            for (URL persistenceUrl : persistenceUrls) {
                String moduleName = persistenceUrl.toExternalForm().replaceFirst("!/?META-INF/persistence.xml$", "");
                if ((moduleName = moduleName.replaceFirst("/?META-INF/persistence.xml$", "/")).startsWith("jar:")) {
                    moduleName = moduleName.substring("jar:".length());
                }
                if (moduleName.startsWith("file:")) {
                    moduleName = moduleName.substring("file:".length());
                }
                try {
                    Persistence persistence = JaxbPersistenceFactory.getPersistence((URL)persistenceUrl);
                    PersistenceModule persistenceModule = new PersistenceModule(moduleName, persistence);
                    persistenceModule.getWatchedResources().add(moduleName);
                    if ("file".equals(persistenceUrl.getProtocol())) {
                        persistenceModule.getWatchedResources().add(URLs.toFilePath(persistenceUrl));
                    }
                    appModule.getPersistenceModules().add(persistenceModule);
                }
                catch (Exception e1) {
                    DeploymentLoader.logger.error("Unable to load Persistence Unit from EAR: " + appModule.getJarLocation() + ", module: " + moduleName + ". Exception: " + e1.getMessage(), e1);
                }
            }
        }
        return appModule;
    }

    private void readOpenejbJar(EjbModule ejbModule) throws OpenEJBException {
        Source source1;
        Source source = this.getSource(ejbModule.getAltDDs().get("openejb-jar.xml"));
        if (source != null) {
            try {
                OpenejbJar openejbJar = (OpenejbJar)JaxbOpenejbJar3.unmarshal(OpenejbJar.class, (InputStream)source.get());
                ejbModule.setOpenejbJar(openejbJar);
            }
            catch (Exception v3ParsingException) {
                OpenejbJar openejbJar = new OpenejbJar();
                ejbModule.setOpenejbJar(openejbJar);
                try {
                    JAXBElement element = (JAXBElement)JaxbOpenejbJar2.unmarshal(OpenejbJarType.class, (InputStream)source.get());
                    OpenejbJarType o2 = (OpenejbJarType)element.getValue();
                    ejbModule.getAltDDs().put("openejb-jar.xml", o2);
                    GeronimoEjbJarType g2 = new GeronimoEjbJarType();
                    g2.setEnvironment(o2.getEnvironment());
                    g2.setSecurity(o2.getSecurity());
                    g2.getService().addAll(o2.getService());
                    g2.getMessageDestination().addAll(o2.getMessageDestination());
                    g2.getPersistence().addAll(o2.getPersistence());
                    for (EnterpriseBean bean : o2.getEnterpriseBeans()) {
                        RpcBean rpcBean;
                        g2.getAbstractNamingEntry().addAll(bean.getAbstractNamingEntry());
                        g2.getPersistenceContextRef().addAll(bean.getPersistenceContextRef());
                        g2.getPersistenceUnitRef().addAll(bean.getPersistenceUnitRef());
                        g2.getEjbLocalRef().addAll(bean.getEjbLocalRef());
                        g2.getEjbRef().addAll(bean.getEjbRef());
                        g2.getResourceEnvRef().addAll(bean.getResourceEnvRef());
                        g2.getResourceRef().addAll(bean.getResourceRef());
                        g2.getServiceRef().addAll(bean.getServiceRef());
                        if (bean instanceof RpcBean && (rpcBean = (RpcBean)bean).getTssLink() != null) {
                            g2.getTssLink().add(new TssLinkType(rpcBean.getEjbName(), rpcBean.getTssLink(), rpcBean.getJndiName()));
                        }
                        if (!(bean instanceof SessionBeanType)) continue;
                        SessionBeanType sb = (SessionBeanType)bean;
                        WebServiceBindingType b = new WebServiceBindingType();
                        b.setEjbName(sb.getEjbName());
                        b.setWebServiceAddress(sb.getWebServiceAddress());
                        b.setWebServiceVirtualHost(sb.getWebServiceVirtualHost());
                        b.setWebServiceSecurity(sb.getWebServiceSecurity());
                        if (!b.containsData()) continue;
                        g2.getWebServiceBinding().add(b);
                    }
                    ejbModule.getAltDDs().put("geronimo-openejb.xml", g2);
                }
                catch (Exception v2ParsingException) {
                    final Exception[] realIssue = new Exception[]{v3ParsingException};
                    try {
                        SAXParserFactory factory = SAXParserFactory.newInstance();
                        factory.setNamespaceAware(true);
                        factory.setValidating(false);
                        SAXParser parser = factory.newSAXParser();
                        parser.parse(source.get(), new DefaultHandler(){

                            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                                if (localName.equals("environment")) {
                                    realIssue[0] = v2ParsingException;
                                    throw new SAXException("Throw exception to stop parsing");
                                }
                                if (uri == null) {
                                    return;
                                }
                                if (uri.contains("openejb-jar-2.") || uri.contains("geronimo.apache.org/xml/ns")) {
                                    realIssue[0] = v2ParsingException;
                                    throw new SAXException("Throw exception to stop parsing");
                                }
                            }
                        });
                    }
                    catch (Exception dontCare) {
                        // empty catch block
                    }
                    String filePath = "<error: could not be written>";
                    try {
                        File tempFile = File.createTempFile("openejb-jar-", ".xml");
                        try {
                            FileOutputStream out = new FileOutputStream(tempFile);
                            InputStream in = source.get();
                            int b = in.read();
                            while (b != -1) {
                                out.write(b);
                                b = in.read();
                            }
                            out.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        filePath = tempFile.getAbsolutePath();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    Exception e = realIssue[0];
                    if (e instanceof SAXException) {
                        throw new OpenEJBException("Cannot parse the openejb-jar.xml. Xml content written to: " + filePath, e);
                    }
                    if (e instanceof JAXBException) {
                        throw new OpenEJBException("Cannot unmarshall the openejb-jar.xml. Xml content written to: " + filePath, e);
                    }
                    if (e instanceof IOException) {
                        throw new OpenEJBException("Cannot read the openejb-jar.xml.", e);
                    }
                    throw new OpenEJBException("Encountered unknown error parsing the openejb-jar.xml.", e);
                }
            }
        }
        if ((source1 = this.getSource(ejbModule.getAltDDs().get("geronimo-openejb.xml"))) != null) {
            try {
                GeronimoEjbJarType geronimoEjbJarType = null;
                Object o = JaxbOpenejbJar2.unmarshal(GeronimoEjbJarType.class, (InputStream)source1.get());
                if (o instanceof GeronimoEjbJarType) {
                    geronimoEjbJarType = (GeronimoEjbJarType)o;
                } else if (o instanceof JAXBElement) {
                    JAXBElement element = (JAXBElement)o;
                    geronimoEjbJarType = (GeronimoEjbJarType)element.getValue();
                }
                if (geronimoEjbJarType != null) {
                    OpenejbJar existingOpenejbJar;
                    Object nested = geronimoEjbJarType.getOpenejbJar();
                    if (nested != null && nested instanceof OpenejbJar && ((existingOpenejbJar = ejbModule.getOpenejbJar()) == null || existingOpenejbJar.getEjbDeploymentCount() <= 0)) {
                        OpenejbJar openejbJar = (OpenejbJar)nested;
                        ejbModule.getAltDDs().put("openejb-jar.xml", openejbJar);
                        ejbModule.setOpenejbJar(openejbJar);
                    }
                    ejbModule.getAltDDs().put("geronimo-openejb.xml", geronimoEjbJarType);
                }
            }
            catch (Exception e) {
                throw new OpenEJBException("Failed parsing geronimo-openejb.xml", e);
            }
        }
    }

    private void readAppClient(ClientModule clientModule, AppModule appModule) throws OpenEJBException {
        if (clientModule.getApplicationClient() != null) {
            return;
        }
        Object data = clientModule.getAltDDs().get("application-client.xml");
        if (data instanceof ApplicationClient) {
            clientModule.setApplicationClient((ApplicationClient)data);
        } else if (data instanceof URL) {
            URL url = (URL)data;
            ApplicationClient applicationClient = ReadDescriptors.readApplicationClient(url);
            clientModule.setApplicationClient(applicationClient);
        } else {
            DeploymentLoader.logger.warning("No application-client.xml found assuming annotations present: " + appModule.getJarLocation() + ", module: " + clientModule.getModuleId());
            clientModule.setApplicationClient(new ApplicationClient());
        }
    }

    private void readEjbJar(EjbModule ejbModule, AppModule appModule) throws OpenEJBException {
        if (ejbModule.getEjbJar() != null) {
            return;
        }
        Object data = ejbModule.getAltDDs().get("ejb-jar.xml");
        if (data instanceof EjbJar) {
            ejbModule.setEjbJar((EjbJar)data);
        } else if (data instanceof URL) {
            URL url = (URL)data;
            EjbJar ejbJar = ReadDescriptors.readEjbJar(url);
            ejbModule.setEjbJar(ejbJar);
        } else {
            DeploymentLoader.logger.debug("No ejb-jar.xml found assuming annotated beans present: " + appModule.getJarLocation() + ", module: " + ejbModule.getModuleId());
            ejbModule.setEjbJar(new EjbJar());
        }
    }

    private void readCmpOrm(EjbModule ejbModule) throws OpenEJBException {
        Object data = ejbModule.getAltDDs().get("openejb-cmp-orm.xml");
        if (data == null || data instanceof EntityMappings) {
            return;
        }
        if (data instanceof URL) {
            URL url = (URL)data;
            try {
                EntityMappings entitymappings = (EntityMappings)JaxbJavaee.unmarshal(EntityMappings.class, (InputStream)url.openStream());
                ejbModule.getAltDDs().put("openejb-cmp-orm.xml", entitymappings);
            }
            catch (SAXException e) {
                throw new OpenEJBException("Cannot parse the openejb-cmp-orm.xml file: " + url.toExternalForm(), e);
            }
            catch (JAXBException e) {
                throw new OpenEJBException("Cannot unmarshall the openejb-cmp-orm.xml file: " + url.toExternalForm(), e);
            }
            catch (IOException e) {
                throw new OpenEJBException("Cannot read the openejb-cmp-orm.xml file: " + url.toExternalForm(), e);
            }
            catch (Exception e) {
                throw new OpenEJBException("Encountered unknown error parsing the openejb-cmp-orm.xml file: " + url.toExternalForm(), e);
            }
        }
    }

    private void readConnector(ConnectorModule connectorModule, AppModule appModule) throws OpenEJBException {
        if (connectorModule.getConnector() != null) {
            return;
        }
        Object data = connectorModule.getAltDDs().get("ra.xml");
        if (data instanceof Connector) {
            connectorModule.setConnector((Connector)data);
        } else if (data instanceof URL) {
            URL url = (URL)data;
            Connector connector = ReadDescriptors.readConnector(url);
            connectorModule.setConnector(connector);
        } else {
            DeploymentLoader.logger.debug("No ra.xml found assuming annotated beans present: " + appModule.getJarLocation() + ", module: " + connectorModule.getModuleId());
            connectorModule.setConnector(new Connector());
        }
    }

    private void readWebApp(WebModule webModule, AppModule appModule) throws OpenEJBException {
        if (webModule.getWebApp() != null) {
            return;
        }
        Object data = webModule.getAltDDs().get("web.xml");
        if (data instanceof WebApp) {
            webModule.setWebApp((WebApp)data);
        } else if (data instanceof URL) {
            URL url = (URL)data;
            WebApp webApp = ReadDescriptors.readWebApp(url);
            webModule.setWebApp(webApp);
        } else {
            DeploymentLoader.logger.debug("No web.xml found assuming annotated beans present: " + appModule.getJarLocation() + ", module: " + webModule.getModuleId());
            webModule.setWebApp(new WebApp());
        }
    }

    public static ApplicationClient readApplicationClient(URL url) throws OpenEJBException {
        ApplicationClient applicationClient;
        try {
            applicationClient = (ApplicationClient)JaxbJavaee.unmarshal(ApplicationClient.class, (InputStream)url.openStream());
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the application-client.xml file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the application-client.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the application-client.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the application-client.xml file: " + url.toExternalForm(), e);
        }
        return applicationClient;
    }

    public static EjbJar readEjbJar(URL url) throws OpenEJBException {
        try {
            if (ReadDescriptors.isEmptyEjbJar(url)) {
                return new EjbJar();
            }
            return (EjbJar)JaxbJavaee.unmarshal(EjbJar.class, (InputStream)url.openStream());
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the ejb-jar.xml file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the ejb-jar.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the ejb-jar.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the ejb-jar.xml file: " + url.toExternalForm(), e);
        }
    }

    private static boolean isEmptyEjbJar(URL url) throws IOException, ParserConfigurationException, SAXException {
        InputSource inputSource = new InputSource(url.openStream());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        try {
            parser.parse(inputSource, new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
                    if (!localName.equals("ejb-jar")) {
                        throw new SAXException(localName);
                    }
                }

                public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            return true;
        }
        catch (SAXException e) {
            return false;
        }
    }

    public static Webservices readWebservices(URL url) throws OpenEJBException {
        Webservices webservices;
        try {
            webservices = (Webservices)JaxbJavaee.unmarshal(Webservices.class, (InputStream)url.openStream());
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the webservices.xml file: " + url.toExternalForm(), e);
        }
        return webservices;
    }

    public static HandlerChains readHandlerChains(URL url) throws OpenEJBException {
        HandlerChains handlerChains;
        try {
            handlerChains = (HandlerChains)JaxbJavaee.unmarshal(HandlerChains.class, (InputStream)url.openStream());
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the webservices.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the webservices.xml file: " + url.toExternalForm(), e);
        }
        return handlerChains;
    }

    public static JavaWsdlMapping readJaxrpcMapping(URL url) throws OpenEJBException {
        JavaWsdlMapping wsdlMapping;
        try {
            wsdlMapping = (JavaWsdlMapping)JaxbJavaee.unmarshal(JavaWsdlMapping.class, (InputStream)url.openStream());
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the JaxRPC mapping file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the JaxRPC mapping file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the JaxRPC mapping file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the JaxRPC mapping file: " + url.toExternalForm(), e);
        }
        return wsdlMapping;
    }

    public static Definition readWsdl(URL url) throws OpenEJBException {
        Definition definition;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", true);
            reader.setFeature("javax.wsdl.importDocuments", true);
            WsdlResolver wsdlResolver = new WsdlResolver(new URL(url, ".").toExternalForm(), new InputSource(url.openStream()));
            definition = reader.readWSDL((WSDLLocator)wsdlResolver);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the wsdl file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the wsdl file: " + url.toExternalForm(), e);
        }
        return definition;
    }

    public static Connector readConnector(URL url) throws OpenEJBException {
        Connector connector;
        try {
            connector = (Connector)JaxbJavaee.unmarshal(Connector.class, (InputStream)url.openStream());
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the ra.xml file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the ra.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the ra.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the ra.xml file: " + url.toExternalForm(), e);
        }
        return connector;
    }

    public static WebApp readWebApp(URL url) throws OpenEJBException {
        WebApp webApp;
        try {
            webApp = (WebApp)JaxbJavaee.unmarshal(WebApp.class, (InputStream)url.openStream());
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the web.xml file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the web.xml file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the web.xml file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the web.xml file: " + url.toExternalForm(), e);
        }
        return webApp;
    }

    public static TldTaglib readTldTaglib(URL url) throws OpenEJBException {
        TldTaglib tldTaglib;
        try {
            tldTaglib = (TldTaglib)JaxbJavaee.unmarshal(TldTaglib.class, (InputStream)url.openStream());
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the JSP tag library definition file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the JSP tag library definition file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the JSP tag library definition file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the JSP tag library definition file: " + url.toExternalForm(), e);
        }
        return tldTaglib;
    }

    public static FacesConfig readFacesConfig(URL url) throws OpenEJBException {
        FacesConfig facesConfig;
        try {
            JAXBElement element = (JAXBElement)JaxbJavaee.unmarshal(FacesConfig.class, (InputStream)url.openStream());
            facesConfig = (FacesConfig)element.getValue();
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the faces configuration file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the faces configuration file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the faces configuration file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the faces configuration file: " + url.toExternalForm(), e);
        }
        return facesConfig;
    }

    private Source getSource(Object o) {
        if (o instanceof URL) {
            return new UrlSource((URL)o);
        }
        if (o instanceof String) {
            return new StringSource((String)o);
        }
        return null;
    }

    public static class StringSource
    extends Source {
        private byte[] bytes;

        public StringSource(String content) {
            this.bytes = content.getBytes();
        }

        InputStream get() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    public static class UrlSource
    extends Source {
        private final URL url;

        public UrlSource(URL url) {
            this.url = url;
        }

        InputStream get() throws IOException {
            return this.url.openStream();
        }
    }

    public static abstract class Source {
        abstract InputStream get() throws IOException;
    }
}

