/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.WsModule;
import org.apache.openejb.jee.FacesConfig;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.Webservices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModule
implements WsModule {
    private final ValidationContext validation;
    private final Map<String, Object> altDDs = new HashMap<String, Object>();
    private WebApp webApp;
    private Webservices webservices;
    private String host;
    private String contextRoot;
    private ClassLoader classLoader;
    private String jarLocation;
    private final String moduleId;
    private final List<TldTaglib> taglibs = new ArrayList<TldTaglib>();
    private final Set<String> watchedResources = new TreeSet<String>();
    private final List<FacesConfig> facesConfigs = new ArrayList<FacesConfig>();

    public WebModule(WebApp webApp, String contextRoot, ClassLoader classLoader, String jarLocation, String moduleId) {
        this.webApp = webApp;
        if (contextRoot == null) {
            contextRoot = jarLocation.substring(jarLocation.lastIndexOf(47));
            if (contextRoot.endsWith(".unpacked")) {
                contextRoot = contextRoot.substring(0, contextRoot.length() - ".unpacked".length());
            }
            if (contextRoot.endsWith(".war")) {
                contextRoot = contextRoot.substring(0, contextRoot.length() - ".war".length());
            }
        }
        if (contextRoot.startsWith("/")) {
            contextRoot = contextRoot.substring(1);
        }
        this.contextRoot = contextRoot;
        this.classLoader = classLoader;
        this.jarLocation = jarLocation;
        if (webApp != null) {
            webApp.setContextRoot(contextRoot);
        }
        if (moduleId == null) {
            if (webApp != null && webApp.getId() != null) {
                moduleId = webApp.getId();
            } else {
                File file = new File(jarLocation);
                moduleId = file.getName();
                if (moduleId.endsWith(".unpacked")) {
                    moduleId = moduleId.substring(0, moduleId.length() - ".unpacked".length());
                }
            }
        }
        this.moduleId = moduleId;
        this.validation = new ValidationContext(WebModule.class, jarLocation);
    }

    @Override
    public ValidationContext getValidation() {
        return this.validation;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public Map<String, Object> getAltDDs() {
        return this.altDDs;
    }

    public WebApp getWebApp() {
        return this.webApp;
    }

    public void setWebApp(WebApp webApp) {
        this.webApp = webApp;
        if (webApp != null) {
            webApp.setContextRoot(this.contextRoot);
        }
    }

    @Override
    public Webservices getWebservices() {
        return this.webservices;
    }

    @Override
    public void setWebservices(Webservices webservices) {
        this.webservices = webservices;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getJarLocation() {
        return this.jarLocation;
    }

    public void setJarLocation(String jarLocation) {
        this.jarLocation = jarLocation;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        if (this.webApp != null) {
            this.webApp.setContextRoot(contextRoot);
        }
        this.contextRoot = contextRoot;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public List<TldTaglib> getTaglibs() {
        return this.taglibs;
    }

    @Override
    public Set<String> getWatchedResources() {
        return this.watchedResources;
    }

    public List<FacesConfig> getFacesConfigs() {
        return this.facesConfigs;
    }
}

