/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.util.List;
import java.util.Map;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.jee.AssemblyDescriptor;
import org.apache.openejb.jee.ContainerTransaction;
import org.apache.openejb.jee.InterceptorBinding;
import org.apache.openejb.jee.Method;
import org.apache.openejb.jee.MethodPermission;
import org.apache.openejb.util.Join;

public class CheckAssemblyBindings
extends ValidationBase {
    public void validate(EjbModule ejbModule) {
        Map ejbsByName = ejbModule.getEjbJar().getEnterpriseBeansByEjbName();
        AssemblyDescriptor assembly = ejbModule.getEjbJar().getAssemblyDescriptor();
        if (assembly == null) {
            return;
        }
        for (InterceptorBinding binding : assembly.getInterceptorBinding()) {
            List interceptorClasses = binding.getInterceptorClass();
            if (binding.getInterceptorOrder() != null) {
                interceptorClasses.addAll(binding.getInterceptorOrder().getInterceptorClass());
            }
            if (binding.getEjbName() != null && !binding.getEjbName().equals("*") && !ejbsByName.containsKey(binding.getEjbName())) {
                this.fail("InterceptorBinding", "interceptorBinding.noSuchEjbName", binding.getEjbName(), Join.join(",", interceptorClasses));
            }
            if (binding.getMethod() == null || binding.getEjbName() != null) continue;
            this.fail("InterceptorBinding", "interceptorBinding.ejbNameRequiredWithMethod", binding.getMethod().getMethodName(), Join.join(",", interceptorClasses));
        }
        for (MethodPermission permission : assembly.getMethodPermission()) {
            for (Method method : permission.getMethod()) {
                if (method.getEjbName() == null) {
                    this.fail("MethodPermission", "methodPermission.ejbNameRequired", method.getMethodName(), Join.join(",", permission.getRoleName()));
                    continue;
                }
                if (method.getEjbName().equals("*") || ejbsByName.containsKey(method.getEjbName())) continue;
                this.fail("MethodPermission", "methodPermission.noSuchEjbName", method.getEjbName(), method.getMethodName(), Join.join(",", permission.getRoleName()));
            }
        }
        for (ContainerTransaction transaction : assembly.getContainerTransaction()) {
            for (Method method : transaction.getMethod()) {
                if (method.getEjbName() == null) {
                    this.fail("ContainerTransaction", "containerTransaction.ejbNameRequired", method.getMethodName(), transaction.getTransAttribute());
                    continue;
                }
                if (method.getEjbName().equals("*") || ejbsByName.containsKey(method.getEjbName())) continue;
                this.fail("ContainerTransaction", "containerTransaction.noSuchEjbName", method.getEjbName(), method.getMethodName(), transaction.getTransAttribute());
            }
        }
    }
}

