/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Init;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.ejb.Timer;
import javax.interceptor.InvocationContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.finder.ClassFinder;
import org.apache.openejb.jee.AroundInvoke;
import org.apache.openejb.jee.CallbackMethod;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.Session;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.TimerConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckCallbacks
extends ValidationBase {
    @Override
    public void validate(EjbModule module) {
        for (EnterpriseBean enterpriseBean : module.getEjbJar().getEnterpriseBeans()) {
            Class ejbClass = null;
            try {
                ejbClass = this.loadClass(enterpriseBean.getEjbClass());
            }
            catch (OpenEJBException e) {
                continue;
            }
            for (AroundInvoke aroundInvoke : enterpriseBean.getAroundInvoke()) {
                this.checkAroundInvoke(ejbClass, aroundInvoke, enterpriseBean.getEjbName());
            }
            for (LifecycleCallback callback : enterpriseBean.getPostConstruct()) {
                this.checkCallback(ejbClass, "PostConstruct", (CallbackMethod)callback, enterpriseBean);
            }
            for (LifecycleCallback callback : enterpriseBean.getPreDestroy()) {
                this.checkCallback(ejbClass, "PreDestroy", (CallbackMethod)callback, enterpriseBean);
            }
            if (enterpriseBean instanceof Session) {
                SessionBean session = (SessionBean)enterpriseBean;
                if (session.getSessionType() == SessionType.STATEFUL) {
                    for (LifecycleCallback callback : session.getPrePassivate()) {
                        this.checkCallback(ejbClass, "PrePassivate", (CallbackMethod)callback, enterpriseBean);
                    }
                    for (LifecycleCallback callback : session.getPostActivate()) {
                        this.checkCallback(ejbClass, "PostActivate", (CallbackMethod)callback, enterpriseBean);
                    }
                } else {
                    for (LifecycleCallback callback : session.getPrePassivate()) {
                        this.ignoredStatefulAnnotation("PrePassivate", enterpriseBean, callback.getMethodName(), session.getSessionType().getName());
                    }
                    for (LifecycleCallback callback : session.getPostActivate()) {
                        this.ignoredStatefulAnnotation("PostActivate", enterpriseBean, callback.getMethodName(), session.getSessionType().getName());
                    }
                    for (Method method : session.getRemoveMethod()) {
                        this.ignoredStatefulAnnotation("Remove", enterpriseBean, method.getBeanMethod().getMethodName(), session.getSessionType().getName());
                    }
                    for (Method method : session.getInitMethod()) {
                        this.ignoredStatefulAnnotation("Init", enterpriseBean, method.getBeanMethod().getMethodName(), session.getSessionType().getName());
                    }
                }
            } else {
                ClassFinder finder = new ClassFinder(new Class[]{ejbClass});
                for (Method method : finder.findAnnotatedMethods(PrePassivate.class)) {
                    this.ignoredStatefulAnnotation("PrePassivate", enterpriseBean, method.getName(), enterpriseBean.getClass().getSimpleName());
                }
                for (Method method : finder.findAnnotatedMethods(PostActivate.class)) {
                    this.ignoredStatefulAnnotation("PostActivate", enterpriseBean, method.getName(), enterpriseBean.getClass().getSimpleName());
                }
                for (Method method : finder.findAnnotatedMethods(Remove.class)) {
                    this.ignoredStatefulAnnotation("Remove", enterpriseBean, method.getName(), enterpriseBean.getClass().getSimpleName());
                }
                for (Method method : finder.findAnnotatedMethods(Init.class)) {
                    this.ignoredStatefulAnnotation("Init", enterpriseBean, method.getName(), enterpriseBean.getClass().getSimpleName());
                }
            }
            if (!(enterpriseBean instanceof TimerConsumer)) continue;
            TimerConsumer timerConsumer = (TimerConsumer)enterpriseBean;
            this.checkTimeOut(ejbClass, timerConsumer.getTimeoutMethod(), enterpriseBean);
        }
        for (EnterpriseBean enterpriseBean : module.getEjbJar().getInterceptors()) {
            Class interceptorClass = null;
            try {
                interceptorClass = this.loadClass(enterpriseBean.getInterceptorClass());
            }
            catch (OpenEJBException e) {
                continue;
            }
            for (AroundInvoke aroundInvoke : enterpriseBean.getAroundInvoke()) {
                this.checkAroundInvoke(interceptorClass, aroundInvoke, "Interceptor");
            }
            for (LifecycleCallback callback : enterpriseBean.getPostConstruct()) {
                this.checkCallback(interceptorClass, "PostConstruct", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
            for (LifecycleCallback callback : enterpriseBean.getPreDestroy()) {
                this.checkCallback(interceptorClass, "PreDestroy", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
            for (LifecycleCallback callback : enterpriseBean.getPrePassivate()) {
                this.checkCallback(interceptorClass, "PrePassivate", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
            for (LifecycleCallback callback : enterpriseBean.getPostActivate()) {
                this.checkCallback(interceptorClass, "PostActivate", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
        }
    }

    private void checkAroundInvoke(Class ejbClass, AroundInvoke aroundInvoke, String componentName) {
        try {
            Method method = this.getMethod(ejbClass, aroundInvoke.getMethodName(), InvocationContext.class);
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(Object.class)) {
                this.fail(componentName, "aroundInvoke.badReturnType", aroundInvoke.getMethodName(), returnType.getName(), aroundInvoke.getClassName());
            }
            boolean throwsException = false;
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (!exceptionType.getName().equals(Exception.class.getName())) continue;
                throwsException = true;
            }
            if (!throwsException) {
                this.fail(componentName, "aroundInvoke.mustThrowException", aroundInvoke.getMethodName(), aroundInvoke.getClassName());
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(ejbClass, aroundInvoke.getMethodName());
            if (possibleMethods.size() == 0) {
                this.fail(componentName, "aroundInvoke.missing", aroundInvoke.getMethodName(), aroundInvoke.getClassName());
            }
            if (possibleMethods.size() == 1) {
                this.fail(componentName, "aroundInvoke.invalidArguments", aroundInvoke.getMethodName(), this.getParameters(possibleMethods.get(0)), aroundInvoke.getClassName());
            }
            this.fail(componentName, "aroundInvoke.missing.possibleTypo", aroundInvoke.getMethodName(), possibleMethods.size(), aroundInvoke.getClassName());
        }
    }

    private void ignoredStatefulAnnotation(String annotationType, EnterpriseBean bean, String methodName, String beanType) {
        this.warn(bean, "ignoredStatefulAnnotation", annotationType, beanType, methodName);
    }

    private void checkCallback(Class ejbClass, String type, CallbackMethod callback, EnterpriseBean bean) {
        try {
            Method method = this.getMethod(ejbClass, callback.getMethodName(), new Class[0]);
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(Void.TYPE)) {
                this.fail(bean, "callback.badReturnType", type, callback.getMethodName(), returnType.getName(), callback.getClassName());
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(ejbClass, callback.getMethodName());
            if (possibleMethods.size() == 0) {
                this.fail(bean, "callback.missing", type, callback.getMethodName(), callback.getClassName());
            }
            if (possibleMethods.size() == 1) {
                this.fail(bean, "callback.invalidArguments", type, callback.getMethodName(), this.getParameters(possibleMethods.get(0)), callback.getClassName());
            }
            this.fail(bean, "callback.missing.possibleTypo", type, callback.getMethodName(), possibleMethods.size(), callback.getClassName());
        }
    }

    private void checkCallback(Class interceptorClass, String type, CallbackMethod callback, Interceptor interceptor) {
        try {
            Method method = this.getMethod(interceptorClass, callback.getMethodName(), InvocationContext.class);
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(Void.TYPE)) {
                this.fail("Interceptor", "interceptor.callback.badReturnType", interceptorClass, type, callback.getMethodName(), returnType.getName());
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(interceptorClass, callback.getMethodName());
            if (possibleMethods.size() == 0) {
                this.fail("Interceptor", "interceptor.callback.missing", type, callback.getMethodName(), interceptorClass.getName());
            }
            if (possibleMethods.size() == 1) {
                this.fail("Interceptor", "interceptor.callback.invalidArguments", type, callback.getMethodName(), this.getParameters(possibleMethods.get(0)), interceptorClass.getName());
            }
            this.fail("Interceptor", "interceptor.callback.missing.possibleTypo", type, callback.getMethodName(), possibleMethods.size(), interceptorClass.getName());
        }
    }

    private void checkTimeOut(Class ejbClass, NamedMethod timeout, EnterpriseBean bean) {
        if (timeout == null) {
            return;
        }
        try {
            Method method = this.getMethod(ejbClass, timeout.getMethodName(), Timer.class);
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(Void.TYPE)) {
                this.fail(bean, "timeout.badReturnType", timeout.getMethodName(), returnType.getName());
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(ejbClass, timeout.getMethodName());
            if (possibleMethods.size() == 0) {
                this.fail(bean, "timeout.missing", timeout.getMethodName());
            }
            if (possibleMethods.size() == 1) {
                this.fail(bean, "timeout.invalidArguments", timeout.getMethodName(), this.getParameters(possibleMethods.get(0)));
            }
            this.fail(bean, "timeout.missing.possibleTypo", timeout.getMethodName(), possibleMethods.size());
        }
    }

    private Method getMethod(Class clazz, String methodName, Class ... parameterTypes) throws NoSuchMethodException {
        NoSuchMethodException original = null;
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (original == null) {
                    original = e;
                }
                clazz = clazz.getSuperclass();
            }
        }
        throw original;
    }

    private List<Method> getMethods(Class clazz, String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                methods.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return methods;
    }
}

