/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceContextType;
import org.apache.openejb.jee.SessionBean;

public class CheckPersistenceRefs
extends ValidationBase {
    public void validate(EjbModule ejbModule) {
        for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            String beanType = this.getType(bean);
            if (beanType.equals("Stateful")) continue;
            for (PersistenceContextRef ref : bean.getPersistenceContextRef()) {
                String prefix;
                if (!this.isExtented(ref)) continue;
                String refName = ref.getName();
                if (refName.startsWith(prefix = bean.getEjbClass() + "/")) {
                    refName = refName.substring(prefix.length());
                }
                this.fail(bean, "persistenceContextExtented.nonStateful", refName, beanType);
            }
        }
    }

    private boolean isExtented(PersistenceContextRef ref) {
        PersistenceContextType type = ref.getPersistenceContextType();
        return type != null && type.equals((Object)PersistenceContextType.EXTENDED);
    }

    private String getType(EnterpriseBean bean) {
        if (bean instanceof SessionBean) {
            SessionBean sessionBean = (SessionBean)bean;
            switch (sessionBean.getSessionType()) {
                case STATEFUL: {
                    return "Stateful";
                }
                case STATELESS: {
                    return "Stateless";
                }
                case SINGLETON: {
                    return "Singleton";
                }
            }
            throw new IllegalArgumentException("Uknown SessionBean type " + bean.getClass());
        }
        if (bean instanceof MessageDrivenBean) {
            return "MessageDriven";
        }
        if (bean instanceof EntityBean) {
            return "EJB 2.1 Entity";
        }
        throw new IllegalArgumentException("Uknown bean type " + bean.getClass());
    }
}

