/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.lang.reflect.Method;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.ValidationRule;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.PersistenceType;
import org.apache.openejb.util.SafeToolkit;

public abstract class ValidationBase
implements ValidationRule {
    DeploymentModule module;

    public void validate(AppModule appModule) {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            this.module = ejbModule;
            this.validate(ejbModule);
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            this.module = clientModule;
            this.validate(clientModule);
        }
    }

    public void validate(ClientModule appModule) {
    }

    public void validate(EjbModule appModule) {
    }

    public void error(EnterpriseBean bean, String key, Object ... details) {
        this.error(bean.getEjbName(), key, details);
    }

    private void error(String componentName, String key, Object ... details) {
        this.module.getValidation().error(componentName, key, details);
    }

    public void fail(EnterpriseBean bean, String key, Object ... details) {
        this.fail(bean.getEjbName(), key, details);
    }

    public void fail(String component, String key, Object ... details) {
        this.module.getValidation().fail(component, key, details);
    }

    public void warn(EnterpriseBean bean, String key, Object ... details) {
        this.warn(bean.getEjbName(), key, details);
    }

    private void warn(String componentName, String key, Object ... details) {
        this.module.getValidation().warn(componentName, key, details);
    }

    public void missingMethod(ValidationContext set, EnterpriseBean bean, String key, String methodName, Class returnType, Class ... paramTypes) {
        this.fail(bean, key, methodName, returnType.getName(), this.getParameters(paramTypes));
    }

    public static boolean paramsMatch(Method methodA, Method methodB) {
        if (methodA.getParameterTypes().length != methodB.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < methodA.getParameterTypes().length; ++i) {
            Class<?> b;
            Class<?> a = methodA.getParameterTypes()[i];
            if (a.equals(b = methodB.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    public String getParameters(Method method) {
        Class[] params = method.getParameterTypes();
        return this.getParameters(params);
    }

    public String getParameters(Class ... params) {
        StringBuffer paramString = new StringBuffer(512);
        if (params.length > 0) {
            paramString.append(params[0].getName());
        }
        for (int i = 1; i < params.length; ++i) {
            paramString.append(", ");
            paramString.append(params[i]);
        }
        return paramString.toString();
    }

    protected Class loadClass(String clazz) throws OpenEJBException {
        ClassLoader cl = this.module.getClassLoader();
        try {
            return cl.loadClass(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            throw new OpenEJBException(SafeToolkit.messages.format("cl0007", clazz, this.module.getJarLocation()), cnfe);
        }
    }

    public boolean isCmp(EnterpriseBean b) {
        if (b instanceof EntityBean) {
            EntityBean entityBean = (EntityBean)b;
            PersistenceType persistenceType = entityBean.getPersistenceType();
            return persistenceType == PersistenceType.CONTAINER;
        }
        return false;
    }
}

