/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.sys;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.ConfigUtils;
import org.apache.openejb.config.sys.ConnectionManager;
import org.apache.openejb.config.sys.Connector;
import org.apache.openejb.config.sys.Container;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JndiProvider;
import org.apache.openejb.config.sys.ListAdapter;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.config.sys.PropertiesAdapter;
import org.apache.openejb.config.sys.ProxyFactory;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.SecurityService;
import org.apache.openejb.config.sys.ServiceProvider;
import org.apache.openejb.config.sys.ServicesJar;
import org.apache.openejb.config.sys.TransactionManager;
import org.apache.openejb.finder.ResourceFinder;
import org.apache.openejb.jee.JAXBContextFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxbOpenejb {
    public static final ThreadLocal<Set<String>> currentPublicId = new ThreadLocal();
    private static Map<Class, JAXBContext> jaxbContexts = new HashMap<Class, JAXBContext>();

    public static <T> T create(Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (type == ConnectionManager.class) {
            return (T)JaxbOpenejb.createConnectionManager();
        }
        if (type == Connector.class) {
            return (T)JaxbOpenejb.createConnector();
        }
        if (type == Container.class) {
            return (T)JaxbOpenejb.createContainer();
        }
        if (type == Deployments.class) {
            return (T)JaxbOpenejb.createDeployments();
        }
        if (type == JndiProvider.class) {
            return (T)JaxbOpenejb.createJndiProvider();
        }
        if (type == Openejb.class) {
            return (T)JaxbOpenejb.createOpenejb();
        }
        if (type == ProxyFactory.class) {
            return (T)JaxbOpenejb.createProxyFactory();
        }
        if (type == Resource.class) {
            return (T)JaxbOpenejb.createResource();
        }
        if (type == SecurityService.class) {
            return (T)JaxbOpenejb.createSecurityService();
        }
        if (type == ServiceProvider.class) {
            return (T)JaxbOpenejb.createServiceProvider();
        }
        if (type == ServicesJar.class) {
            return (T)JaxbOpenejb.createServicesJar();
        }
        if (type == TransactionManager.class) {
            return (T)JaxbOpenejb.createTransactionManager();
        }
        throw new IllegalArgumentException("Unknown type " + type.getName());
    }

    public static <T> T create(String type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (type.equals("ConnectionManager")) {
            return (T)JaxbOpenejb.createConnectionManager();
        }
        if (type.equals("Connector")) {
            return (T)JaxbOpenejb.createConnector();
        }
        if (type.equals("Container")) {
            return (T)JaxbOpenejb.createContainer();
        }
        if (type.equals("Deployments")) {
            return (T)JaxbOpenejb.createDeployments();
        }
        if (type.equals("JndiProvider")) {
            return (T)JaxbOpenejb.createJndiProvider();
        }
        if (type.equals("Openejb")) {
            return (T)JaxbOpenejb.createOpenejb();
        }
        if (type.equals("ProxyFactory")) {
            return (T)JaxbOpenejb.createProxyFactory();
        }
        if (type.equals("Resource")) {
            return (T)JaxbOpenejb.createResource();
        }
        if (type.equals("SecurityService")) {
            return (T)JaxbOpenejb.createSecurityService();
        }
        if (type.equals("ServiceProvider")) {
            return (T)JaxbOpenejb.createServiceProvider();
        }
        if (type.equals("ServicesJar")) {
            return (T)JaxbOpenejb.createServicesJar();
        }
        if (type.equals("TransactionManager")) {
            return (T)JaxbOpenejb.createTransactionManager();
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ServicesJar readServicesJar(String providerName) throws OpenEJBException {
        ServicesJar servicesJar;
        InputStream in = null;
        URL url = null;
        try {
            try {
                ServicesJar servicesJar2;
                ResourceFinder finder = new ResourceFinder("META-INF/", Thread.currentThread().getContextClassLoader());
                url = finder.find(providerName + "/service-jar.xml");
                in = url.openStream();
                servicesJar = servicesJar2 = JaxbOpenejb.parseServicesJar(in);
                Object var7_8 = null;
                if (in == null) return servicesJar;
            }
            catch (MalformedURLException e) {
                throw new OpenEJBException("Unable to resolve service provider " + providerName, e);
            }
            catch (Exception e) {
                throw new OpenEJBException("Unable to read OpenEJB service-jar file for provider " + providerName + " at " + url, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return servicesJar;
        }
        in.close();
        return servicesJar;
    }

    private static ServicesJar parseServicesJar(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(in);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        final ServicesJar servicesJar1 = new ServicesJar();
        parser.parse(inputSource, new DefaultHandler(){
            private ServiceProvider provider;
            private StringBuilder content;

            public void startDocument() throws SAXException {
            }

            public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
                if (!localName.equals("ServiceProvider")) {
                    return;
                }
                this.provider = new ServiceProvider();
                this.provider.setId(att.getValue("", "id"));
                this.provider.setService(att.getValue("", "service"));
                this.provider.setFactoryName(att.getValue("", "factory-name"));
                this.provider.setConstructor(att.getValue("", "constructor"));
                this.provider.setClassName(att.getValue("", "class-name"));
                String typesString = att.getValue("", "types");
                if (typesString != null) {
                    ListAdapter listAdapter = new ListAdapter();
                    List<String> types = listAdapter.unmarshal(typesString);
                    this.provider.getTypes().addAll(types);
                }
                servicesJar1.getServiceProvider().add(this.provider);
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.content == null) {
                    this.content = new StringBuilder();
                }
                this.content.append(ch, start, length);
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (this.provider == null || this.content == null) {
                    return;
                }
                try {
                    PropertiesAdapter propertiesAdapter = new PropertiesAdapter();
                    this.provider.getProperties().putAll((Map<?, ?>)propertiesAdapter.unmarshal(this.content.toString()));
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
                this.provider = null;
                this.content = null;
            }
        });
        ServicesJar servicesJar = servicesJar1;
        return servicesJar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Openejb readConfig(String configFile) throws OpenEJBException {
        Openejb openejb;
        InputStream in = null;
        try {
            try {
                Openejb openejb2;
                URL url;
                if (configFile.startsWith("jar:")) {
                    url = new URL(configFile);
                    in = url.openStream();
                } else if (configFile.startsWith("file:")) {
                    url = new URL(configFile);
                    in = url.openStream();
                } else {
                    in = new FileInputStream(configFile);
                }
                openejb = openejb2 = JaxbOpenejb.unmarshal(Openejb.class, in);
                Object var5_6 = null;
                if (in == null) return openejb;
            }
            catch (MalformedURLException e) {
                throw new OpenEJBException("Unable to resolve location " + configFile, e);
            }
            catch (Exception e) {
                throw new OpenEJBException("Unable to read OpenEJB configuration file at " + configFile, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return openejb;
        }
        in.close();
        return openejb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeConfig(String configFile, Openejb openejb) throws OpenEJBException {
        OutputStream out = null;
        try {
            try {
                File file = new File(configFile);
                out = new FileOutputStream(file);
                JaxbOpenejb.marshal(Openejb.class, openejb, out);
            }
            catch (IOException e) {
                throw new OpenEJBException(ConfigUtils.messages.format("conf.1040", configFile, e.getLocalizedMessage()), e);
            }
            catch (MarshalException e) {
                if (!(e.getCause() instanceof IOException)) throw new OpenEJBException(ConfigUtils.messages.format("conf.1050", configFile, e.getLocalizedMessage()), e);
                throw new OpenEJBException(ConfigUtils.messages.format("conf.1040", configFile, e.getLocalizedMessage()), e);
            }
            catch (ValidationException e) {
                throw new OpenEJBException(ConfigUtils.messages.format("conf.1060", configFile, e.getLocalizedMessage()), e);
            }
            catch (JAXBException e) {
                throw new OpenEJBException(e);
            }
            Object var5_8 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        out.close();
        return;
    }

    public static <T> String marshal(Class<T> type, Object object) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JaxbOpenejb.marshal(type, object, baos);
        return new String(baos.toByteArray());
    }

    public static <T> void marshal(Class<T> type, Object object, OutputStream out) throws JAXBException {
        JAXBContext jaxbContext = JaxbOpenejb.getContext(type);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(object, out);
    }

    private static <T> JAXBContext getContext(Class<T> type) throws JAXBException {
        JAXBContext jaxbContext = jaxbContexts.get(type);
        if (jaxbContext == null) {
            jaxbContext = JAXBContextFactory.newInstance((Class[])new Class[]{type});
            jaxbContexts.put(type, jaxbContext);
        }
        return jaxbContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unmarshal(Class<T> type, InputStream in) throws ParserConfigurationException, SAXException, JAXBException {
        Object object;
        InputSource inputSource = new InputSource(in);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        JAXBContext ctx = JaxbOpenejb.getContext(type);
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                System.out.println(validationEvent);
                return false;
            }
        });
        NamespaceFilter xmlFilter = new NamespaceFilter(parser.getXMLReader());
        xmlFilter.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
        SAXSource source = new SAXSource(xmlFilter, inputSource);
        currentPublicId.set(new TreeSet());
        try {
            object = unmarshaller.unmarshal((Source)source);
            Object var11_10 = null;
            currentPublicId.set(null);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            currentPublicId.set(null);
            throw throwable;
        }
        return (T)object;
    }

    public static ConnectionManager createConnectionManager() {
        return new ConnectionManager();
    }

    public static Connector createConnector() {
        return new Connector();
    }

    public static Container createContainer() {
        return new Container();
    }

    public static Deployments createDeployments() {
        return new Deployments();
    }

    public static JndiProvider createJndiProvider() {
        return new JndiProvider();
    }

    public static Openejb createOpenejb() {
        return new Openejb();
    }

    public static ProxyFactory createProxyFactory() {
        return new ProxyFactory();
    }

    public static Resource createResource() {
        return new Resource();
    }

    public static SecurityService createSecurityService() {
        return new SecurityService();
    }

    public static ServiceProvider createServiceProvider() {
        return new ServiceProvider();
    }

    public static ServicesJar createServicesJar() {
        return new ServicesJar();
    }

    public static TransactionManager createTransactionManager() {
        return new TransactionManager();
    }

    public static class NamespaceFilter
    extends XMLFilterImpl {
        public NamespaceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Set<String> publicIds = currentPublicId.get();
            if (publicIds != null) {
                publicIds.add(publicId);
            }
            return super.resolveEntity(publicId, systemId);
        }

        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            super.startElement("http://www.openejb.org/System/Configuration", localName, qname, atts);
        }
    }
}

