/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.security.Principal;
import java.util.ArrayList;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.InternalErrorException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.RestrictedUserTransaction;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.EjbObjectProxyHandler;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.core.singleton.SingletonEjbObjectHandler;
import org.apache.openejb.core.stateful.StatefulEjbObjectHandler;
import org.apache.openejb.core.stateless.StatelessEjbObjectHandler;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.proxy.InvocationHandler;
import org.apache.openejb.util.proxy.ProxyManager;

public abstract class BaseSessionContext
extends BaseContext
implements SessionContext {
    protected BaseSessionContext(SecurityService securityService) {
        super(securityService);
    }

    public BaseSessionContext(SecurityService securityService, UserTransaction userTransaction) {
        super(securityService, userTransaction);
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        return ((SessionState)this.getState()).getEJBLocalObject();
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        return ((SessionState)this.getState()).getEJBObject();
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        return ((SessionState)this.getState()).getMessageContext();
    }

    public Object getBusinessObject(Class aClass) {
        return ((SessionState)this.getState()).getBusinessObject(aClass);
    }

    public Class getInvokedBusinessInterface() {
        return ((SessionState)this.getState()).getInvokedBusinessInterface();
    }

    public static class TimeoutSessionState
    extends SessionState {
        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }

        public MessageContext getMessageContext() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }
    }

    public static class BusinessSessionState
    extends SessionState {
        public MessageContext getMessageContext() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }
    }

    public static class PostConstructSessionState
    extends LifecycleSessionState {
        public UserTransaction getUserTransaction(UserTransaction userTransaction) throws IllegalStateException {
            return new RestrictedUserTransaction(super.getUserTransaction(userTransaction));
        }
    }

    public static class LifecycleSessionState
    extends SessionState {
        public MessageContext getMessageContext() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }

        public Principal getCallerPrincipal(SecurityService securityService) {
            throw new IllegalStateException();
        }

        public boolean isCallerInRole(SecurityService securityService, String roleName) {
            throw new IllegalStateException();
        }

        public void setRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isJNDIAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerFactoryAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }

        public boolean isTimerMethodAllowed() {
            return false;
        }
    }

    public static class InjectionSessionState
    extends SessionState {
        public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public EJBObject getEJBObject() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public MessageContext getMessageContext() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Object getBusinessObject(Class interfce) {
            throw new IllegalStateException();
        }

        public Class getInvokedBusinessInterface() {
            throw new IllegalStateException();
        }

        public Principal getCallerPrincipal(SecurityService securityService) {
            throw new IllegalStateException();
        }

        public boolean isCallerInRole(SecurityService securityService, String roleName) {
            throw new IllegalStateException();
        }

        public UserTransaction getUserTransaction(UserTransaction userTransaction) throws IllegalStateException {
            throw new IllegalStateException();
        }

        public void setRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public TimerService getTimerService() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerFactoryAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }

        public boolean isTimerMethodAllowed() {
            return false;
        }
    }

    protected static class SessionState
    extends BaseContext.State {
        protected SessionState() {
        }

        public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            if (di.getLocalHomeInterface() == null) {
                throw new IllegalStateException("Bean does not have an EJBLocalObject interface: " + di.getDeploymentID());
            }
            return (EJBLocalObject)EjbObjectProxyHandler.createProxy(di, threadContext.getPrimaryKey(), InterfaceType.EJB_LOCAL);
        }

        public EJBObject getEJBObject() throws IllegalStateException {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            if (di.getHomeInterface() == null) {
                throw new IllegalStateException("Bean does not have an EJBObject interface: " + di.getDeploymentID());
            }
            return (EJBObject)EjbObjectProxyHandler.createProxy(di, threadContext.getPrimaryKey(), InterfaceType.EJB_OBJECT);
        }

        public MessageContext getMessageContext() throws IllegalStateException {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            MessageContext messageContext = threadContext.get(MessageContext.class);
            if (messageContext == null) {
                throw new IllegalStateException("Only calls on the service-endpoint have a MessageContext.");
            }
            return messageContext;
        }

        public Object getBusinessObject(Class interfce) {
            if (interfce == null) {
                throw new IllegalStateException("Interface argument cannot me null.");
            }
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            InterfaceType interfaceType = di.getInterfaceType(interfce);
            if (interfaceType == null) {
                throw new IllegalStateException("Component has no such interface: " + interfce.getName());
            }
            if (!interfaceType.isBusiness()) {
                throw new IllegalStateException("Interface is not a business interface for this bean: " + interfce.getName());
            }
            try {
                EjbObjectProxyHandler handler;
                switch (di.getComponentType()) {
                    case STATEFUL: {
                        handler = new StatefulEjbObjectHandler(di, threadContext.getPrimaryKey(), interfaceType, new ArrayList<Class>());
                        break;
                    }
                    case STATELESS: {
                        handler = new StatelessEjbObjectHandler(di, threadContext.getPrimaryKey(), interfaceType, new ArrayList<Class>());
                        break;
                    }
                    case SINGLETON: {
                        handler = new SingletonEjbObjectHandler(di, threadContext.getPrimaryKey(), interfaceType, new ArrayList<Class>());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Bean is not a session bean: " + (Object)((Object)di.getComponentType()));
                    }
                }
                ArrayList<Class<IntraVmProxy>> interfaces = new ArrayList<Class<IntraVmProxy>>();
                interfaces.addAll(di.getInterfaces(interfaceType));
                interfaces.add(IntraVmProxy.class);
                return ProxyManager.newProxyInstance(interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)handler);
            }
            catch (IllegalAccessException iae) {
                throw new InternalErrorException("Could not create IVM proxy for " + interfce.getName() + " interface", iae);
            }
        }

        public Class getInvokedBusinessInterface() {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            Class invokedInterface = threadContext.getInvokedInterface();
            InterfaceType type = threadContext.getDeploymentInfo().getInterfaceType(invokedInterface);
            if (!type.isBusiness()) {
                throw new IllegalStateException("The EJB spec requires us to cripple the use of this method for anything but business interface proxy.  But FYI, your invoked interface is: " + invokedInterface.getName());
            }
            if (invokedInterface == null) {
                throw new IllegalStateException("Business interface not set into ThreadContext.");
            }
            return invokedInterface;
        }
    }
}

