/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.core.WebDeploymentInfo;
import org.apache.openejb.core.ivm.naming.IvmContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;

public class CoreContainerSystem
implements ContainerSystem {
    Map<Object, DeploymentInfo> deployments = new ConcurrentHashMap<Object, DeploymentInfo>();
    Map<Object, Container> containers = new ConcurrentHashMap<Object, Container>();
    Map<String, WebDeploymentInfo> webDeployments = new ConcurrentHashMap<String, WebDeploymentInfo>();
    IvmContext jndiRootContext = null;

    public CoreContainerSystem() {
        try {
            this.jndiRootContext = IvmContext.createRootContext();
            this.jndiRootContext.createSubcontext("java:openejb/ejb");
            this.jndiRootContext.createSubcontext("java:openejb/client");
            this.jndiRootContext.createSubcontext("java:openejb/Deployment");
            this.jndiRootContext.bind("openejb/ejb/.", (Object)"");
            this.jndiRootContext.bind("openejb/client/.", (Object)"");
            this.jndiRootContext.bind("openejb/Deployment/.", (Object)"");
        }
        catch (NamingException exception) {
            throw new RuntimeException();
        }
        SystemInstance.get().setComponent(ContainerSystem.class, (Object)this);
    }

    public DeploymentInfo getDeploymentInfo(Object deploymentID) {
        return this.deployments.get(deploymentID);
    }

    public DeploymentInfo[] deployments() {
        return this.deployments.values().toArray(new DeploymentInfo[this.deployments.size()]);
    }

    public void addDeployment(DeploymentInfo deployment) {
        this.deployments.put(deployment.getDeploymentID(), deployment);
    }

    public void removeDeploymentInfo(DeploymentInfo info) {
        this.deployments.remove(info.getDeploymentID());
    }

    public Container getContainer(Object id) {
        return this.containers.get(id);
    }

    public Container[] containers() {
        return this.containers.values().toArray(new Container[this.containers.size()]);
    }

    public void addContainer(Object id, Container c) {
        this.containers.put(id, c);
    }

    public void removeContainer(Object id) {
        this.containers.remove(id);
    }

    public WebDeploymentInfo getWebDeploymentInfo(String id) {
        return this.webDeployments.get(id);
    }

    public WebDeploymentInfo[] WebDeployments() {
        return this.webDeployments.values().toArray(new WebDeploymentInfo[this.webDeployments.size()]);
    }

    public void addWebDeployment(WebDeploymentInfo webDeployment) {
        this.webDeployments.put(webDeployment.getId(), webDeployment);
    }

    public void removeWebDeploymentInfo(WebDeploymentInfo info) {
        this.webDeployments.remove(info.getId());
    }

    public Context getJNDIContext() {
        return this.jndiRootContext;
    }
}

