/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.cmp;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.Timer;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.ContainerType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.cmp.CmpCallback;
import org.apache.openejb.core.cmp.CmpEngine;
import org.apache.openejb.core.cmp.CmpEngineFactory;
import org.apache.openejb.core.cmp.KeyGenerator;
import org.apache.openejb.core.cmp.ProxyFactory;
import org.apache.openejb.core.entity.EntrancyTracker;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Enumerator;

public class CmpContainer
implements RpcContainer {
    protected final Object containerID;
    protected final SecurityService securityService;
    protected final Map<Object, DeploymentInfo> deploymentsById = new HashMap<Object, DeploymentInfo>();
    protected final Map<Class, DeploymentInfo> deploymentsByClass = new HashMap<Class, DeploymentInfo>();
    protected final CmpEngine cmpEngine;
    protected EntrancyTracker entrancyTracker;
    protected TransactionSynchronizationRegistry synchronizationRegistry;
    private static final Object ENTITIES_TO_STORE = new Object(){

        public String toString() {
            return "EntitiesToStore";
        }
    };

    public CmpContainer(Object id, TransactionManager transactionManager, SecurityService securityService, String cmpEngineFactory) throws OpenEJBException {
        CmpEngineFactory factory;
        this.containerID = id;
        this.securityService = securityService;
        this.synchronizationRegistry = (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
        this.entrancyTracker = new EntrancyTracker(this.synchronizationRegistry);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            Class<?> cmpEngineFactoryClass = classLoader.loadClass(cmpEngineFactory);
            factory = (CmpEngineFactory)cmpEngineFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw new OpenEJBException("Unable to create cmp engine factory " + cmpEngineFactory, e);
        }
        factory.setTransactionManager(transactionManager);
        factory.setTransactionSynchronizationRegistry(this.synchronizationRegistry);
        factory.setCmpCallback(new ContainerCmpCallback());
        this.cmpEngine = factory.create();
    }

    public Object getContainerID() {
        return this.containerID;
    }

    public ContainerType getContainerType() {
        return ContainerType.CMP_ENTITY;
    }

    public synchronized DeploymentInfo[] deployments() {
        return this.deploymentsById.values().toArray(new DeploymentInfo[this.deploymentsById.size()]);
    }

    public synchronized DeploymentInfo getDeploymentInfo(Object deploymentID) {
        return this.deploymentsById.get(deploymentID);
    }

    private DeploymentInfo getDeploymentInfoByClass(Class type) {
        DeploymentInfo deploymentInfo = null;
        while (type != null && deploymentInfo == null) {
            deploymentInfo = this.deploymentsByClass.get(type);
            type = type.getSuperclass();
        }
        return deploymentInfo;
    }

    public void deploy(DeploymentInfo deploymentInfo) throws OpenEJBException {
        this.deploy((CoreDeploymentInfo)deploymentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(CoreDeploymentInfo deploymentInfo) throws OpenEJBException {
        CmpContainer cmpContainer = this;
        synchronized (cmpContainer) {
            Object deploymentId = deploymentInfo.getDeploymentID();
            this.cmpEngine.deploy(deploymentInfo);
            deploymentInfo.setContainerData(this.cmpEngine);
            try {
                Field field = deploymentInfo.getCmpImplClass().getField("deploymentInfo");
                field.set(null, deploymentInfo);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.deploymentsById.put(deploymentId, deploymentInfo);
            this.deploymentsByClass.put(deploymentInfo.getCmpImplClass(), deploymentInfo);
            deploymentInfo.setContainer(this);
        }
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    public void undeploy(DeploymentInfo deploymentInfo) throws OpenEJBException {
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.stop();
        }
        this.undeploy((CoreDeploymentInfo)deploymentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(CoreDeploymentInfo deploymentInfo) throws OpenEJBException {
        CmpContainer cmpContainer = this;
        synchronized (cmpContainer) {
            this.deploymentsById.remove(deploymentInfo.getDeploymentID());
            this.deploymentsByClass.remove(deploymentInfo.getCmpImplClass());
            try {
                Field field = deploymentInfo.getCmpImplClass().getField("deploymentInfo");
                field.set(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            deploymentInfo.setContainer(null);
            deploymentInfo.setContainerData(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEjbInstance(CoreDeploymentInfo deployInfo, Object primaryKey) {
        ThreadContext callContext = new ThreadContext(deployInfo, primaryKey);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            Object bean;
            Object object = bean = this.cmpEngine.loadBean(callContext, primaryKey);
            return object;
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deployID, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        CoreDeploymentInfo deployInfo = (CoreDeploymentInfo)this.getDeploymentInfo(deployID);
        if (deployInfo == null) {
            throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
        }
        ThreadContext callContext = new ThreadContext(deployInfo, primKey);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            Object retValue;
            boolean authorized = this.securityService.isCallerAuthorized(callMethod, deployInfo.getInterfaceType(callInterface));
            if (!authorized) {
                throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
            }
            Class<?> declaringClass = callMethod.getDeclaringClass();
            String methodName = callMethod.getName();
            if (EJBHome.class.isAssignableFrom(declaringClass) || EJBLocalHome.class.isAssignableFrom(declaringClass)) {
                if (declaringClass != EJBHome.class && declaringClass != EJBLocalHome.class) {
                    if (methodName.startsWith("create")) {
                        ProxyInfo proxyInfo = this.createEJBObject(callMethod, args, callContext);
                        return proxyInfo;
                    }
                    if (methodName.equals("findByPrimaryKey")) {
                        Object object = this.findByPrimaryKey(callMethod, args, callContext);
                        return object;
                    }
                    if (methodName.startsWith("find")) {
                        Object object = this.findEJBObject(callMethod, args, callContext);
                        return object;
                    }
                    Object object = this.homeMethod(callMethod, args, callContext);
                    return object;
                }
                if (methodName.equals("remove")) {
                    this.removeEJBObject(callMethod, callContext);
                    Object var12_16 = null;
                    return var12_16;
                }
            } else if ((EJBObject.class == declaringClass || EJBLocalObject.class == declaringClass) && methodName.equals("remove")) {
                this.removeEJBObject(callMethod, callContext);
                Object var12_17 = null;
                return var12_17;
            }
            callContext.setCurrentOperation(Operation.BUSINESS);
            callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
            Method runMethod = deployInfo.getMatchingBeanMethod(callMethod);
            callContext.set(Method.class, runMethod);
            Object object = retValue = this.businessMethod(callMethod, runMethod, args, callContext);
            return object;
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private EntityBean createNewInstance(ThreadContext callContext) {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        try {
            EntityBean bean = (EntityBean)deploymentInfo.getCmpImplClass().newInstance();
            return bean;
        }
        catch (Exception e) {
            throw new EJBException("Unable to create new entity bean instance " + deploymentInfo.getCmpImplClass(), e);
        }
    }

    private ThreadContext createThreadContext(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        CoreDeploymentInfo deployInfo = (CoreDeploymentInfo)this.getDeploymentInfoByClass(entityBean.getClass());
        KeyGenerator keyGenerator = deployInfo.getKeyGenerator();
        Object primaryKey = keyGenerator.getPrimaryKey(entityBean);
        ThreadContext callContext = new ThreadContext(deployInfo, primaryKey);
        return callContext;
    }

    private void setEntityContext(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        CoreDeploymentInfo deployInfo = (CoreDeploymentInfo)this.getDeploymentInfoByClass(entityBean.getClass());
        ThreadContext callContext = new ThreadContext(deployInfo, null);
        callContext.setCurrentOperation(Operation.SET_CONTEXT);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.setEntityContext((EntityContext)new org.apache.openejb.core.entity.EntityContext(this.securityService));
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private void unsetEntityContext(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.UNSET_CONTEXT);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.unsetEntityContext();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private void ejbLoad(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.LOAD);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.ejbLoad();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
        try {
            LinkedHashSet<EntityBean> registeredEntities = (LinkedHashSet<EntityBean>)this.synchronizationRegistry.getResource(ENTITIES_TO_STORE);
            if (registeredEntities == null) {
                registeredEntities = new LinkedHashSet<EntityBean>();
                this.synchronizationRegistry.putResource(ENTITIES_TO_STORE, registeredEntities);
                this.synchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                        LinkedHashSet registeredEntities = (LinkedHashSet)CmpContainer.this.synchronizationRegistry.getResource(ENTITIES_TO_STORE);
                        if (registeredEntities == null) {
                            return;
                        }
                        for (EntityBean entityBean : registeredEntities) {
                            CmpContainer.this.ejbStore(entityBean);
                        }
                    }

                    public void afterCompletion(int i) {
                    }
                });
            }
            registeredEntities.add(entityBean);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void ejbStore(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.STORE);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.ejbStore();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private void ejbRemove(EntityBean entityBean) throws RemoveException {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        if (this.isDeleted(entityBean)) {
            return;
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.REMOVE);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.ejbRemove();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            try {
                entityBean.getClass().getMethod("OpenEJB_deleted", new Class[0]).invoke((Object)entityBean, new Object[0]);
            }
            catch (Exception ignored) {}
            this.cancelTimers(callContext);
            ThreadContext.exit(oldCallContext);
        }
    }

    private boolean isDeleted(EntityBean entityBean) {
        try {
            return (Boolean)entityBean.getClass().getMethod("OpenEJB_isDeleted", new Class[0]).invoke((Object)entityBean, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    private void ejbActivate(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.ACTIVATE);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.ejbActivate();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    private void ejbPassivate(EntityBean entityBean) {
        if (entityBean == null) {
            throw new NullPointerException("entityBean is null");
        }
        ThreadContext callContext = this.createThreadContext(entityBean);
        callContext.setCurrentOperation(Operation.PASSIVATE);
        callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            entityBean.ejbPassivate();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object businessMethod(Method callMethod, Method runMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        Object returnValue = null;
        this.entrancyTracker.enter(deploymentInfo, callContext.getPrimaryKey());
        try {
            EntityBean bean = (EntityBean)this.cmpEngine.loadBean(callContext, callContext.getPrimaryKey());
            if (bean == null) {
                throw new NoSuchObjectException(deploymentInfo.getDeploymentID() + " : " + callContext.getPrimaryKey());
            }
            returnValue = runMethod.invoke((Object)bean, args);
            this.cmpEngine.storeBeanIfNoTx(callContext, bean);
        }
        catch (NoSuchObjectException e) {
            EjbTransactionUtil.handleApplicationException(txPolicy, e, false);
        }
        catch (Throwable e) {
            ExceptionType type;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ((type = callContext.getDeploymentInfo().getExceptionType(e)) == ExceptionType.SYSTEM) {
                EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
            } else {
                EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
            }
        }
        finally {
            this.entrancyTracker.exit(deploymentInfo, callContext.getPrimaryKey());
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object homeMethod(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        Object returnValue = null;
        try {
            EntityBean bean = this.createNewInstance(callContext);
            this.setEntityContext(bean);
            try {
                callContext.setCurrentOperation(Operation.HOME);
                callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
                Method runMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
                try {
                    returnValue = runMethod.invoke((Object)bean, args);
                }
                catch (IllegalArgumentException e) {
                    System.out.println("********************************************************");
                    System.out.println("callMethod = " + callMethod);
                    System.out.println("runMethod = " + runMethod);
                    System.out.println("bean = " + bean.getClass().getName());
                    throw e;
                }
            }
            finally {
                this.unsetEntityContext(bean);
            }
        }
        catch (Throwable e) {
            ExceptionType type;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ((type = callContext.getDeploymentInfo().getExceptionType(e)) == ExceptionType.SYSTEM) {
                EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
            } else {
                EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
            }
        }
        finally {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyInfo createEJBObject(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        Object primaryKey = null;
        try {
            EntityBean bean = this.createNewInstance(callContext);
            this.setEntityContext(bean);
            Method ejbCreateMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
            callContext.setCurrentOperation(Operation.CREATE);
            callContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
            ejbCreateMethod.invoke((Object)bean, args);
            primaryKey = this.cmpEngine.createBean(bean, callContext);
            Method ejbPostCreateMethod = deploymentInfo.getMatchingPostCreateMethod(ejbCreateMethod);
            ThreadContext postCreateContext = new ThreadContext(deploymentInfo, primaryKey);
            postCreateContext.setCurrentOperation(Operation.POST_CREATE);
            postCreateContext.setCurrentAllowedStates(org.apache.openejb.core.entity.EntityContext.getStates());
            ThreadContext oldContext = ThreadContext.enter(postCreateContext);
            try {
                ejbPostCreateMethod.invoke((Object)bean, args);
            }
            finally {
                ThreadContext.exit(oldContext);
            }
            this.cmpEngine.storeBeanIfNoTx(callContext, bean);
        }
        catch (Throwable e) {
            ExceptionType type;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ((type = callContext.getDeploymentInfo().getExceptionType(e)) == ExceptionType.SYSTEM) {
                EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
            } else {
                EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
            }
        }
        finally {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        return new ProxyInfo(deploymentInfo, primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findByPrimaryKey(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        try {
            EntityBean bean = (EntityBean)this.cmpEngine.loadBean(callContext, args[0]);
            if (bean == null) {
                throw new ObjectNotFoundException(deploymentInfo.getDeploymentID() + " : " + args[0]);
            }
            KeyGenerator kg = deploymentInfo.getKeyGenerator();
            Object primaryKey = kg.getPrimaryKey(bean);
            ProxyInfo proxyInfo = new ProxyInfo(deploymentInfo, primaryKey);
            return proxyInfo;
        }
        catch (FinderException fe) {
            EjbTransactionUtil.handleApplicationException(txPolicy, fe, false);
        }
        catch (Throwable e) {
            EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
        }
        finally {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        throw new AssertionError((Object)"Should not get here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findEJBObject(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        try {
            List<Object> results = this.cmpEngine.queryBeans(callContext, callMethod, args);
            KeyGenerator kg = deploymentInfo.getKeyGenerator();
            if (callMethod.getReturnType() == Collection.class || callMethod.getReturnType() == Enumeration.class) {
                Object i$;
                ArrayList<ProxyInfo> proxies = new ArrayList<ProxyInfo>();
                for (Object value : results) {
                    EntityBean bean = (EntityBean)value;
                    if (value == null) {
                        proxies.add(null);
                        continue;
                    }
                    Object primaryKey = kg.getPrimaryKey(bean);
                    proxies.add(new ProxyInfo(deploymentInfo, primaryKey));
                }
                if (callMethod.getReturnType() == Enumeration.class) {
                    i$ = new Enumerator(proxies);
                    return i$;
                }
                i$ = proxies;
                return i$;
            }
            if (results.size() != 1) {
                throw new ObjectNotFoundException("A Enteprise bean with deployment_id = " + deploymentInfo.getDeploymentID() + " and primarykey = " + args[0] + " Does not exist");
            }
            EntityBean bean = (EntityBean)results.get(0);
            if (bean == null) {
                Object i$ = null;
                return i$;
            }
            Object primaryKey = kg.getPrimaryKey(bean);
            ProxyInfo proxyInfo = new ProxyInfo(deploymentInfo, primaryKey);
            return proxyInfo;
        }
        catch (FinderException fe) {
            EjbTransactionUtil.handleApplicationException(txPolicy, fe, false);
        }
        catch (Throwable e) {
            EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
        }
        finally {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
        throw new AssertionError((Object)"Should not get here");
    }

    /*
     * WARNING - void declaration
     */
    public Object select(DeploymentInfo di, String methodSignature, String returnType, Object ... args) throws FinderException {
        CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)di;
        String signature = deploymentInfo.getAbstractSchemaName() + "." + methodSignature;
        try {
            List<Object> results = this.cmpEngine.queryBeans(deploymentInfo, signature, args);
            AbstractCollection proxies = returnType.equals("java.util.Set") ? new LinkedHashSet() : new ArrayList();
            boolean isSingleValued = !returnType.equals("java.util.Collection") && !returnType.equals("java.util.Set");
            ProxyFactory proxyFactory = null;
            for (Object e : results) {
                void var12_13;
                if (isSingleValued && !proxies.isEmpty()) {
                    throw new FinderException("The single valued query " + methodSignature + "returned more than one item");
                }
                if (e instanceof EntityBean) {
                    CoreDeploymentInfo resultInfo;
                    EntityBean entityBean = (EntityBean)e;
                    if (proxyFactory == null && (resultInfo = (CoreDeploymentInfo)this.getDeploymentInfoByClass(entityBean.getClass())) != null) {
                        proxyFactory = new ProxyFactory(resultInfo);
                    }
                    if (proxyFactory != null) {
                        if (deploymentInfo.isRemoteQueryResults(methodSignature)) {
                            Object object = proxyFactory.createRemoteProxy(entityBean, this);
                        } else {
                            Object object = proxyFactory.createLocalProxy(entityBean, this);
                        }
                    }
                }
                proxies.add(var12_13);
            }
            if (!isSingleValued) {
                return proxies;
            }
            if (proxies.isEmpty()) {
                throw new ObjectNotFoundException();
            }
            Object returnValue = proxies.iterator().next();
            return returnValue;
        }
        catch (RuntimeException e) {
            throw new EJBException((Exception)e);
        }
    }

    public int update(DeploymentInfo di, String methodSignature, Object ... args) throws FinderException {
        CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)di;
        String signature = deploymentInfo.getAbstractSchemaName() + "." + methodSignature;
        int result = this.cmpEngine.executeUpdateQuery(deploymentInfo, signature, args);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEJBObject(Method callMethod, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        try {
            EntityBean entityBean = (EntityBean)this.cmpEngine.loadBean(callContext, callContext.getPrimaryKey());
            if (entityBean == null) {
                throw new NoSuchObjectException(callContext.getDeploymentInfo().getDeploymentID() + " " + callContext.getPrimaryKey());
            }
            this.ejbRemove(entityBean);
            this.cmpEngine.removeBean(callContext);
        }
        catch (NoSuchObjectException e) {
            EjbTransactionUtil.handleApplicationException(txPolicy, e, false);
        }
        catch (Throwable e) {
            EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
        }
        finally {
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        }
    }

    private void cancelTimers(ThreadContext threadContext) {
        EjbTimerService timerService;
        CoreDeploymentInfo deploymentInfo = threadContext.getDeploymentInfo();
        Object primaryKey = threadContext.getPrimaryKey();
        if (primaryKey != null && deploymentInfo.getEjbTimerService() != null && (timerService = deploymentInfo.getEjbTimerService()) != null && timerService instanceof EjbTimerServiceImpl) {
            for (Timer timer : deploymentInfo.getEjbTimerService().getTimers(primaryKey)) {
                timer.cancel();
            }
        }
    }

    private class ContainerCmpCallback
    implements CmpCallback {
        private ContainerCmpCallback() {
        }

        public void setEntityContext(EntityBean entity) {
            CmpContainer.this.setEntityContext(entity);
        }

        public void unsetEntityContext(EntityBean entity) {
            CmpContainer.this.unsetEntityContext(entity);
        }

        public void ejbActivate(EntityBean entity) {
            CmpContainer.this.ejbActivate(entity);
        }

        public void ejbPassivate(EntityBean entity) {
            CmpContainer.this.ejbPassivate(entity);
        }

        public void ejbLoad(EntityBean entity) {
            CmpContainer.this.ejbLoad(entity);
        }

        public void ejbStore(EntityBean entity) {
            CmpContainer.this.ejbStore(entity);
        }

        public void ejbRemove(EntityBean entity) throws RemoveException {
            CmpContainer.this.ejbRemove(entity);
        }
    }
}

