/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.entity;

import java.security.Principal;
import java.util.ArrayList;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.InternalErrorException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.entity.EntityEjbObjectHandler;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.proxy.InvocationHandler;
import org.apache.openejb.util.proxy.ProxyManager;

public class EntityContext
extends BaseContext
implements javax.ejb.EntityContext {
    protected static final BaseContext.State[] states = new BaseContext.State[Operation.values().length];

    public static BaseContext.State[] getStates() {
        return states;
    }

    public EntityContext(SecurityService securityService) {
        super(securityService);
    }

    protected BaseContext.State getState() {
        Operation operation = ThreadContext.getThreadContext().getCurrentOperation();
        BaseContext.State state = states[operation.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Invalid operation " + (Object)((Object)operation) + " for this context");
        }
        return state;
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        return ((EntityState)this.getState()).getEJBLocalObject();
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        return ((EntityState)this.getState()).getEJBObject();
    }

    public Object getPrimaryKey() throws IllegalStateException {
        return ((EntityState)this.getState()).getPrimaryKey();
    }

    static {
        EntityContext.states[Operation.SET_CONTEXT.ordinal()] = new ContextEntityState();
        EntityContext.states[Operation.UNSET_CONTEXT.ordinal()] = new ContextEntityState();
        EntityContext.states[Operation.CREATE.ordinal()] = new CreateEntityState();
        EntityContext.states[Operation.POST_CREATE.ordinal()] = new LifecycleBusinessTimeoutEntityState();
        EntityContext.states[Operation.REMOVE.ordinal()] = new LifecycleBusinessTimeoutEntityState();
        EntityContext.states[Operation.FIND.ordinal()] = new FindEntityState();
        EntityContext.states[Operation.HOME.ordinal()] = new HomeEntityState();
        EntityContext.states[Operation.ACTIVATE.ordinal()] = new ActivatePassivateEntityState();
        EntityContext.states[Operation.PASSIVATE.ordinal()] = new ActivatePassivateEntityState();
        EntityContext.states[Operation.LOAD.ordinal()] = new LifecycleBusinessTimeoutEntityState();
        EntityContext.states[Operation.STORE.ordinal()] = new LifecycleBusinessTimeoutEntityState();
        EntityContext.states[Operation.BUSINESS.ordinal()] = new LifecycleBusinessTimeoutEntityState();
        EntityContext.states[Operation.TIMEOUT.ordinal()] = new LifecycleBusinessTimeoutEntityState();
    }

    protected static class ActivatePassivateEntityState
    extends EntityState {
        protected ActivatePassivateEntityState() {
        }

        public Principal getCallerPrincipal(SecurityService securityService) {
            throw new IllegalStateException();
        }

        public boolean isCallerInRole(SecurityService securityService, String roleName) {
            throw new IllegalStateException();
        }

        public UserTransaction getUserTransaction(UserTransaction userTransaction) throws IllegalStateException {
            throw new IllegalStateException();
        }

        public void setRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerFactoryAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }
    }

    protected static class HomeEntityState
    extends EntityState {
        protected HomeEntityState() {
        }

        public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public EJBObject getEJBObject() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Object getPrimaryKey() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public UserTransaction getUserTransaction(UserTransaction userTransaction) throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }
    }

    protected static class FindEntityState
    extends EntityState {
        protected FindEntityState() {
        }

        public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public EJBObject getEJBObject() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Object getPrimaryKey() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public UserTransaction getUserTransaction(UserTransaction userTransaction) throws IllegalStateException {
            throw new IllegalStateException();
        }

        public TimerService getTimerService() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }
    }

    protected static class LifecycleBusinessTimeoutEntityState
    extends EntityState {
        protected LifecycleBusinessTimeoutEntityState() {
        }

        public UserTransaction getUserTransaction(UserTransaction userTransaction) throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isTimerMethodAllowed() {
            return true;
        }
    }

    protected static class CreateEntityState
    extends EntityState {
        protected CreateEntityState() {
        }

        public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public EJBObject getEJBObject() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Object getPrimaryKey() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public UserTransaction getUserTransaction(UserTransaction userTransaction) throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }
    }

    protected static class ContextEntityState
    extends EntityState {
        protected ContextEntityState() {
        }

        public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public EJBObject getEJBObject() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Object getPrimaryKey() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public Principal getCallerPrincipal(SecurityService securityService) {
            throw new IllegalStateException();
        }

        public boolean isCallerInRole(SecurityService securityService, String roleName) {
            throw new IllegalStateException();
        }

        public UserTransaction getUserTransaction(UserTransaction userTransaction) throws IllegalStateException {
            throw new IllegalStateException();
        }

        public void setRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public TimerService getTimerService() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public boolean isUserTransactionAccessAllowed() {
            return false;
        }

        public boolean isMessageContextAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerFactoryAccessAllowed() {
            return false;
        }

        public boolean isEntityManagerAccessAllowed() {
            return false;
        }

        public boolean isTimerAccessAllowed() {
            return false;
        }
    }

    private static class EntityState
    extends BaseContext.State {
        private EntityState() {
        }

        public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            if (di.getLocalInterface() == null) {
                throw new IllegalStateException("EJB " + di.getDeploymentID() + " does not have a local interface");
            }
            EntityEjbObjectHandler handler = new EntityEjbObjectHandler(di, threadContext.getPrimaryKey(), InterfaceType.EJB_LOCAL, new ArrayList<Class>());
            try {
                Class[] interfaces = new Class[]{di.getLocalInterface(), IntraVmProxy.class};
                return (EJBLocalObject)ProxyManager.newProxyInstance(interfaces, (InvocationHandler)handler);
            }
            catch (IllegalAccessException iae) {
                throw new InternalErrorException("Could not create IVM proxy for " + di.getLocalInterface() + " interface", iae);
            }
        }

        public EJBObject getEJBObject() throws IllegalStateException {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            if (di.getRemoteInterface() == null) {
                throw new IllegalStateException("EJB " + di.getDeploymentID() + " does not have a remote interface");
            }
            EntityEjbObjectHandler handler = new EntityEjbObjectHandler(di.getContainer().getDeploymentInfo(di.getDeploymentID()), threadContext.getPrimaryKey(), InterfaceType.EJB_OBJECT, new ArrayList<Class>());
            try {
                Class[] interfaces = new Class[]{di.getRemoteInterface(), IntraVmProxy.class};
                return (EJBObject)ProxyManager.newProxyInstance(interfaces, (InvocationHandler)handler);
            }
            catch (IllegalAccessException iae) {
                throw new InternalErrorException("Could not create IVM proxy for " + di.getRemoteInterface() + " interface", iae);
            }
        }

        public Object getPrimaryKey() throws IllegalStateException {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            return threadContext.getPrimaryKey();
        }

        public boolean isTimerMethodAllowed() {
            return false;
        }
    }
}

