/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.interceptor.InvocationContext;
import javax.xml.rpc.handler.MessageContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.interceptor.Interceptor;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.JaxRpcInvocationContext;
import org.apache.openejb.core.interceptor.JaxWsInvocationContext;
import org.apache.openejb.core.interceptor.ReflectionInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorStack {
    private final Object beanInstance;
    private final List<Interceptor> interceptors;
    private final Method targetMethod;
    private final Operation operation;

    public InterceptorStack(Object beanInstance, Method targetMethod, Operation operation, List<InterceptorData> interceptorDatas, Map<String, Object> interceptorInstances) {
        if (interceptorDatas == null) {
            throw new NullPointerException("interceptorDatas is null");
        }
        if (interceptorInstances == null) {
            throw new NullPointerException("interceptorInstances is null");
        }
        this.beanInstance = beanInstance;
        this.targetMethod = targetMethod;
        this.operation = operation;
        this.interceptors = new ArrayList<Interceptor>(interceptorDatas.size());
        for (InterceptorData interceptorData : interceptorDatas) {
            Class interceptorClass = interceptorData.getInterceptorClass();
            Object interceptorInstance = interceptorInstances.get(interceptorClass.getName());
            if (interceptorInstance == null) {
                throw new IllegalArgumentException("No interceptor of type " + interceptorClass.getName());
            }
            List<Method> methods = interceptorData.getMethods(operation);
            for (Method method : methods) {
                Interceptor interceptor = new Interceptor(interceptorInstance, method);
                this.interceptors.add(interceptor);
            }
        }
    }

    public InvocationContext createInvocationContext(Object ... parameters) {
        ReflectionInvocationContext invocationContext = new ReflectionInvocationContext(this.operation, this.interceptors, this.beanInstance, this.targetMethod, parameters);
        return invocationContext;
    }

    public Object invoke(Object ... parameters) throws Exception {
        InvocationContext invocationContext = this.createInvocationContext(parameters);
        Object value = invocationContext.proceed();
        return value;
    }

    public Object invoke(javax.xml.ws.handler.MessageContext messageContext, Object ... parameters) throws Exception {
        JaxWsInvocationContext invocationContext = new JaxWsInvocationContext(this.operation, this.interceptors, this.beanInstance, this.targetMethod, messageContext, parameters);
        Object value = invocationContext.proceed();
        return value;
    }

    public Object invoke(MessageContext messageContext, Object ... parameters) throws Exception {
        JaxRpcInvocationContext invocationContext = new JaxRpcInvocationContext(this.operation, this.interceptors, this.beanInstance, this.targetMethod, messageContext, parameters);
        Object value = invocationContext.proceed();
        return value;
    }
}

