/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.interceptor.InvocationContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.interceptor.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionInvocationContext
implements InvocationContext {
    private final Iterator<Interceptor> interceptors;
    private final Object target;
    private final Method method;
    private final Object[] parameters;
    private final Map<String, Object> contextData = new TreeMap<String, Object>();
    private final Class<?>[] parameterTypes;
    private final Operation operation;

    public ReflectionInvocationContext(Operation operation, List<Interceptor> interceptors, Object target, Method method, Object ... parameters) {
        if (operation == null) {
            throw new NullPointerException("operation is null");
        }
        if (interceptors == null) {
            throw new NullPointerException("interceptors is null");
        }
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        this.operation = operation;
        this.interceptors = interceptors.iterator();
        this.target = target;
        this.method = method;
        this.parameters = parameters;
        this.parameterTypes = method == null ? new Class[0] : method.getParameterTypes();
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        if (this.operation.isCallback()) {
            throw new IllegalStateException(this.getIllegalParameterAccessMessage());
        }
        return (Object[])this.parameters.clone();
    }

    private String getIllegalParameterAccessMessage() {
        String m = "Callback methods cannot access parameters.";
        m = m + "  Callback Type: " + (Object)((Object)this.operation);
        if (this.method != null) {
            m = m + ", Target Method: " + this.method.getName();
        }
        if (this.target != null) {
            m = m + ", Target Bean: " + this.target.getClass().getName();
        }
        return m;
    }

    public void setParameters(Object[] parameters) {
        if (this.operation.isCallback()) {
            throw new IllegalStateException(this.getIllegalParameterAccessMessage());
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is null");
        }
        if (parameters.length != this.parameters.length) {
            throw new IllegalArgumentException("Expected " + this.parameters.length + " parameters, but only got " + parameters.length + " parameters");
        }
        System.arraycopy(parameters, 0, this.parameters, 0, parameters.length);
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    private Invocation next() {
        if (this.interceptors.hasNext()) {
            Interceptor interceptor = this.interceptors.next();
            Object nextInstance = interceptor.getInstance();
            Method nextMethod = interceptor.getMethod();
            if (nextMethod.getParameterTypes().length > 0) {
                return new InterceptorInvocation(nextInstance, nextMethod, this);
            }
            return new LifecycleInvocation(nextInstance, nextMethod, this);
        }
        if (this.method != null) {
            return new BeanInvocation(this.target, this.method, this.parameters);
        }
        return new NoOpInvocation();
    }

    public Object proceed() throws Exception {
        try {
            Invocation next = this.next();
            return next.invoke();
        }
        catch (InvocationTargetException e) {
            throw this.unwrapInvocationTargetException(e);
        }
    }

    private Exception unwrapInvocationTargetException(InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return e;
        }
        if (cause instanceof Exception) {
            return (Exception)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new AssertionError((Object)cause);
    }

    public String toString() {
        String methodName = this.method != null ? this.method.getName() : null;
        return "InvocationContext(operation=" + (Object)((Object)this.operation) + ", target=" + this.target.getClass().getName() + ", method=" + methodName + ")";
    }

    private static class NoOpInvocation
    extends Invocation {
        public NoOpInvocation() {
            super(null, null, null);
        }

        public Object invoke() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private static class LifecycleInvocation
    extends Invocation {
        private final InvocationContext invocationContext;

        public LifecycleInvocation(Object target, Method method, InvocationContext invocationContext) {
            super(target, method, new Object[0]);
            this.invocationContext = invocationContext;
        }

        public Object invoke() throws Exception {
            super.invoke();
            Object value = this.invocationContext.proceed();
            return value;
        }
    }

    private static class InterceptorInvocation
    extends Invocation {
        public InterceptorInvocation(Object target, Method method, InvocationContext invocationContext) {
            super(target, method, new Object[]{invocationContext});
        }
    }

    private static class BeanInvocation
    extends Invocation {
        public BeanInvocation(Object target, Method method, Object[] args) {
            super(target, method, args);
        }
    }

    private static abstract class Invocation {
        private final Method method;
        private final Object[] args;
        private final Object target;

        public Invocation(Object target, Method method, Object[] args) {
            this.target = target;
            this.method = method;
            this.args = args;
        }

        public Object invoke() throws Exception {
            Object value = this.method.invoke(this.target, this.args);
            return value;
        }

        public String toString() {
            return this.method.getDeclaringClass().getName() + "." + this.method.getName();
        }
    }
}

