/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntraVmArtifact
implements Externalizable {
    private static final List<Object> staticHandles = new ArrayList<Object>();
    private static final ThreadLocal<List<Object>> threadHandles = new ThreadLocal<List<Object>>(){

        @Override
        protected List<Object> initialValue() {
            return new ArrayList<Object>();
        }
    };
    private static final String NO_ARTIFACT_ERROR = "The artifact this object represents could not be found.";
    private int instanceHandle;
    private boolean staticArtifact;

    public IntraVmArtifact(Object obj) {
        this(obj, false);
    }

    public IntraVmArtifact(Object obj, boolean storeStatically) {
        this.staticArtifact = storeStatically;
        List<Object> list = IntraVmArtifact.getHandles(storeStatically);
        this.instanceHandle = list.size();
        list.add(obj);
    }

    private static List<Object> getHandles(boolean staticArtifact) {
        return staticArtifact ? staticHandles : threadHandles.get();
    }

    public IntraVmArtifact() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.instanceHandle);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.instanceHandle = in.read();
    }

    protected Object readResolve() throws ObjectStreamException {
        List<Object> list = IntraVmArtifact.getHandles(this.staticArtifact);
        Object artifact = list.get(this.instanceHandle);
        if (artifact == null) {
            throw new InvalidObjectException(NO_ARTIFACT_ERROR + this.instanceHandle);
        }
        if (list.size() == this.instanceHandle + 1) {
            list.clear();
        }
        return artifact;
    }
}

