/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm;

import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import org.apache.openejb.BeanType;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.ivm.BaseEjbProxyHandler;
import org.apache.openejb.core.ivm.IntraVmArtifact;
import org.apache.openejb.core.ivm.IntraVmCopyMonitor;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.util.proxy.ProxyManager;

public class IntraVmMetaData
implements EJBMetaData,
Serializable {
    protected Class homeClass;
    protected Class remoteClass;
    protected Class keyClass;
    protected EJBHome homeStub;
    protected BeanType type;

    public IntraVmMetaData(Class homeInterface, Class remoteInterface, BeanType typeOfBean) {
        this(homeInterface, remoteInterface, null, typeOfBean);
    }

    public IntraVmMetaData(Class homeInterface, Class remoteInterface, Class primaryKeyClass, BeanType typeOfBean) {
        this.type = typeOfBean;
        if (homeInterface == null || remoteInterface == null) {
            throw new IllegalArgumentException();
        }
        if (typeOfBean.isEntity() && primaryKeyClass == null) {
            throw new IllegalArgumentException("Entity beans must have a primary key class");
        }
        this.type = typeOfBean;
        this.homeClass = homeInterface;
        this.remoteClass = remoteInterface;
        this.keyClass = primaryKeyClass;
    }

    public Class getHomeInterfaceClass() {
        return this.homeClass;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteClass;
    }

    public Class getPrimaryKeyClass() {
        if (this.type.isEntity()) {
            return this.keyClass;
        }
        throw new UnsupportedOperationException("Session objects are private resources and do not have primary keys");
    }

    public boolean isSession() {
        return this.type.isSession();
    }

    public boolean isStatelessSession() {
        return this.type == BeanType.STATELESS;
    }

    public boolean isSingletonSession() {
        return this.type == BeanType.SINGLETON;
    }

    public boolean isStatefulSession() {
        return this.type == BeanType.STATEFUL;
    }

    public void setEJBHome(EJBHome home) {
        this.homeStub = home;
    }

    public EJBHome getEJBHome() {
        return this.homeStub;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (IntraVmCopyMonitor.isIntraVmCopyOperation()) {
            return new IntraVmArtifact(this);
        }
        if (IntraVmCopyMonitor.isStatefulPassivationOperation()) {
            return this;
        }
        if (IntraVmCopyMonitor.isCrossClassLoaderOperation()) {
            return this;
        }
        BaseEjbProxyHandler handler = (BaseEjbProxyHandler)ProxyManager.getInvocationHandler(this.homeStub);
        ApplicationServer applicationServer = ServerFederation.getApplicationServer();
        return applicationServer.getEJBMetaData(handler.getProxyInfo());
    }
}

