/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import java.io.Serializable;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import org.apache.openejb.core.ivm.naming.IvmContext;
import org.apache.openejb.core.ivm.naming.ParsedName;

public class NameNode
implements Serializable {
    private String atomicName;
    private int atomicHash;
    private NameNode lessTree;
    private NameNode grtrTree;
    private NameNode subTree;
    private NameNode parentTree;
    private NameNode parent;
    private Object myObject;
    private transient IvmContext myContext;
    private boolean unbound;

    public NameNode(NameNode parent, ParsedName name, Object obj, NameNode parentTree) {
        this.atomicName = name.getComponent();
        this.atomicHash = name.getComponentHashCode();
        this.parent = parent;
        this.parentTree = parentTree;
        if (name.next()) {
            this.subTree = new NameNode(this, name, obj, this);
        } else {
            this.myObject = obj;
        }
    }

    public Object getBinding() {
        if (this.myObject != null) {
            return this.myObject;
        }
        if (this.myContext == null) {
            this.myContext = new IvmContext(this);
        }
        return this.myContext;
    }

    public Object resolve(ParsedName name) throws NameNotFoundException {
        int compareResult = name.compareTo(this.atomicHash);
        if (compareResult == 0 && name.getComponent().equals(this.atomicName)) {
            if (name.next()) {
                if (this.subTree == null) {
                    throw new NameNotFoundException("Cannot resolve " + name);
                }
                return this.subTree.resolve(name);
            }
            if (this.unbound) {
                throw new NameNotFoundException("Cannot resolve " + name);
            }
            return this.getBinding();
        }
        if (compareResult == -1) {
            if (this.lessTree == null) {
                throw new NameNotFoundException("Cannot resolve " + name);
            }
            return this.lessTree.resolve(name);
        }
        if (this.grtrTree == null) {
            throw new NameNotFoundException("Cannot resolve " + name);
        }
        return this.grtrTree.resolve(name);
    }

    public void bind(ParsedName name, Object obj) throws NameAlreadyBoundException {
        int compareResult = name.compareTo(this.atomicHash);
        if (compareResult == 0 && name.getComponent().equals(this.atomicName)) {
            if (name.next()) {
                if (this.myObject != null) {
                    throw new NameAlreadyBoundException();
                }
                if (this.subTree == null) {
                    this.subTree = new NameNode(this, name, obj, this);
                } else {
                    this.subTree.bind(name, obj);
                }
            } else {
                if (this.subTree != null) {
                    throw new NameAlreadyBoundException();
                }
                if (this.myObject != null) {
                    throw new NameAlreadyBoundException();
                }
                this.unbound = false;
                this.myObject = obj;
            }
        } else if (compareResult == -1) {
            if (this.lessTree == null) {
                this.lessTree = new NameNode(this.parent, name, obj, this);
            } else {
                this.lessTree.bind(name, obj);
            }
        } else if (this.grtrTree == null) {
            this.grtrTree = new NameNode(this.parent, name, obj, this);
        } else {
            this.grtrTree.bind(name, obj);
        }
    }

    public int compareTo(int otherHash) {
        if (this.atomicHash == otherHash) {
            return 0;
        }
        if (this.atomicHash > otherHash) {
            return 1;
        }
        return -1;
    }

    private void bind(NameNode node) {
        int compareResult = node.compareTo(this.atomicHash);
        if (node.parent == this) {
            compareResult = 0;
        }
        if (compareResult == 0) {
            if (this.subTree == null) {
                this.subTree = node;
                this.subTree.parentTree = this;
            } else {
                this.subTree.bind(node);
            }
        } else if (compareResult == -1) {
            if (this.lessTree == null) {
                this.lessTree = node;
                this.lessTree.parentTree = this;
            } else {
                this.lessTree.bind(node);
            }
        } else if (this.grtrTree == null) {
            this.grtrTree = node;
            this.grtrTree.parentTree = this;
        } else {
            this.grtrTree.bind(node);
        }
    }

    public void unbind(ParsedName name) throws NameAlreadyBoundException {
        int compareResult = name.compareTo(this.atomicHash);
        if (compareResult == 0 && name.getComponent().equals(this.atomicName)) {
            if (name.next()) {
                if (this.subTree != null) {
                    this.subTree.unbind(name);
                }
            } else {
                this.unbound = true;
                this.myObject = null;
                this.parentTree.unbind(this);
            }
        } else if (compareResult == -1) {
            if (this.lessTree != null) {
                this.lessTree.unbind(name);
            }
        } else if (this.grtrTree != null) {
            this.grtrTree.unbind(name);
        }
    }

    private void unbind(NameNode node) {
        if (this.subTree == node) {
            this.subTree = null;
        } else if (this.grtrTree == node) {
            this.grtrTree = null;
        } else if (this.lessTree == node) {
            this.lessTree = null;
        }
        this.rebalance(this, node);
    }

    private void rebalance(NameNode tree, NameNode node) {
        if (node.subTree != null) {
            tree.bind(node.subTree);
        }
        if (node.lessTree != null) {
            this.bind(node.lessTree);
        }
        if (node.grtrTree != null) {
            this.bind(node.grtrTree);
        }
    }

    protected void prune() {
        this.prune(this);
    }

    private void prune(NameNode until) {
        if (this.subTree != null) {
            this.subTree.prune(until);
        }
        if (this.lessTree != null) {
            this.lessTree.prune(until);
        }
        if (this.grtrTree != null) {
            this.grtrTree.prune(until);
        }
        if (this == until) {
            return;
        }
        if (!this.hasChildren() && this.myObject == null) {
            this.parentTree.unbind(this);
        }
    }

    private boolean hasChildren() {
        return this.hasChildren(this);
    }

    private boolean hasChildren(NameNode node) {
        if (this.subTree != null && this.subTree.hasChildren(node)) {
            return true;
        }
        if (this.grtrTree != null && this.grtrTree.hasChildren(node)) {
            return true;
        }
        if (this.lessTree != null && this.lessTree.hasChildren(node)) {
            return true;
        }
        return this.parent == node;
    }

    protected void clearCache() {
        if (this.myContext != null) {
            this.myContext.fastCache.clear();
        }
        if (this.grtrTree != null) {
            this.grtrTree.clearCache();
        }
        if (this.lessTree != null) {
            this.lessTree.clearCache();
        }
        if (this.subTree != null) {
            this.subTree.clearCache();
        }
    }

    public IvmContext createSubcontext(ParsedName name) throws NameAlreadyBoundException {
        try {
            this.bind(name, null);
            name.reset();
            return (IvmContext)this.resolve(name);
        }
        catch (NameNotFoundException exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    public String getAtomicName() {
        return this.atomicName;
    }

    public NameNode getLessTree() {
        return this.lessTree;
    }

    public NameNode getGrtrTree() {
        return this.grtrTree;
    }

    public NameNode getSubTree() {
        return this.subTree;
    }

    public NameNode getParent() {
        return this.parent;
    }
}

