/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.ejb.EJBException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.mdb.Instance;
import org.apache.openejb.core.mdb.MdbContainer;
import org.apache.openejb.core.mdb.MdbInstanceFactory;

public class EndpointHandler
implements InvocationHandler,
MessageEndpoint {
    private final MdbContainer container;
    private final CoreDeploymentInfo deployment;
    private final MdbInstanceFactory instanceFactory;
    private final XAResource xaResource;
    private State state = State.NONE;
    private Object instance;

    public EndpointHandler(MdbContainer container, CoreDeploymentInfo deployment, MdbInstanceFactory instanceFactory, XAResource xaResource) throws UnavailableException {
        this.container = container;
        this.deployment = deployment;
        this.instanceFactory = instanceFactory;
        this.xaResource = xaResource;
        this.instance = instanceFactory.createInstance(false);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Object[] parameterTypes = method.getParameterTypes();
        if (method.getDeclaringClass() == Object.class) {
            if ("toString".equals(methodName) && parameterTypes.length == 0) {
                return this.toString();
            }
            if ("equals".equals(methodName) && parameterTypes.length == 1) {
                return this.equals(args[0]);
            }
            if ("hashCode".equals(methodName) && parameterTypes.length == 0) {
                return this.hashCode();
            }
            throw new UnsupportedOperationException("Unkown method: " + method);
        }
        if ("beforeDelivery".equals(methodName) && Arrays.deepEquals(new Class[]{Method.class}, parameterTypes)) {
            this.beforeDelivery((Method)args[0]);
            return null;
        }
        if ("afterDelivery".equals(methodName) && parameterTypes.length == 0) {
            this.afterDelivery();
            return null;
        }
        if ("release".equals(methodName) && parameterTypes.length == 0) {
            this.release();
            return null;
        }
        Object value = this.deliverMessage(method, args);
        return value;
    }

    public void beforeDelivery(Method method) throws ApplicationServerInternalException {
        switch (this.state) {
            case RELEASED: {
                throw new IllegalStateException("Message endpoint factory has been released");
            }
            case BEFORE_CALLED: {
                throw new IllegalStateException("beforeDelivery can not be called again until message is delivered and afterDelivery is called");
            }
            case METHOD_CALLED: 
            case SYSTEM_EXCEPTION: {
                throw new IllegalStateException("The last message delivery must be completed with an afterDeliver before beforeDeliver can be called again");
            }
        }
        try {
            this.container.beforeDelivery(this.deployment, this.instance, method, this.xaResource);
        }
        catch (SystemException se) {
            Throwable throwable = se.getRootCause() != null ? se.getRootCause() : se;
            throw new ApplicationServerInternalException(throwable);
        }
        this.state = State.BEFORE_CALLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object deliverMessage(Method method, Object[] args) throws Throwable {
        callBeforeAfter = false;
        switch (1.$SwitchMap$org$apache$openejb$core$mdb$EndpointHandler$State[this.state.ordinal()]) {
            case 5: {
                try {
                    this.beforeDelivery(method);
                }
                catch (ApplicationServerInternalException e) {
                    throw (EJBException)new EJBException().initCause(e.getCause());
                }
                callBeforeAfter = true;
                this.state = State.METHOD_CALLED;
                break;
            }
            case 2: {
                this.state = State.METHOD_CALLED;
                break;
            }
            case 1: {
                throw new IllegalStateException("Message endpoint factory has been released");
            }
            case 3: 
            case 4: {
                throw new IllegalStateException("The last message delivery must be completed with an afterDeliver before another message can be delivered");
            }
        }
        throwable = null;
        value = null;
        try {
            value = this.container.invoke(this.instance, method, args);
            ** if (!callBeforeAfter) goto lbl-1000
        }
        catch (SystemException se) {
            throwable = se.getRootCause() != null ? se.getRootCause() : se;
            this.state = State.SYSTEM_EXCEPTION;
            ** if (!callBeforeAfter) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                try {
                    this.afterDelivery();
                }
                catch (ApplicationServerInternalException e) {
                    throwable = throwable == null ? e.getCause() : throwable;
                }
                catch (UnavailableException e) {
                    throwable = throwable == null ? e : throwable;
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (ApplicationException ae) {
            v0 /* !! */  = throwable = ae.getRootCause() != null ? ae.getRootCause() : ae;
            ** if (!callBeforeAfter) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                try {
                    this.afterDelivery();
                }
                catch (ApplicationServerInternalException e) {
                    throwable = throwable == null ? e.getCause() : throwable;
                }
                catch (UnavailableException e) {
                    throwable = throwable == null ? e : throwable;
                }
            }
lbl-1000:
            // 2 sources

            {
            }
            {
                catch (Throwable var7_15) {
                    if (callBeforeAfter) {
                        try {
                            this.afterDelivery();
                        }
                        catch (ApplicationServerInternalException e) {
                            throwable = throwable == null ? e.getCause() : throwable;
                        }
                        catch (UnavailableException e) {
                            throwable = throwable == null ? e : throwable;
                        }
                    }
                    throw var7_15;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.afterDelivery();
            }
            catch (ApplicationServerInternalException e) {
                throwable = throwable == null ? e.getCause() : throwable;
            }
            catch (UnavailableException e) {
                throwable = throwable == null ? e : throwable;
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (throwable != null) {
            throwable.printStackTrace();
            if (this.isValidException(method, throwable)) {
                throw throwable;
            }
            throw new EJBException().initCause(throwable);
        }
        return value;
    }

    public void afterDelivery() throws ApplicationServerInternalException, UnavailableException {
        switch (this.state) {
            case RELEASED: {
                throw new IllegalStateException("Message endpoint factory has been released");
            }
            case BEFORE_CALLED: {
                throw new IllegalStateException("Exactally one message must be delivered between beforeDelivery and afterDelivery");
            }
            case NONE: {
                throw new IllegalStateException("afterDelivery may only be called if message delivery began with a beforeDelivery call");
            }
        }
        boolean exceptionThrown = false;
        try {
            this.container.afterDelivery(this.instance);
        }
        catch (SystemException se) {
            exceptionThrown = true;
            Throwable throwable = se.getRootCause() != null ? se.getRootCause() : se;
            throwable.printStackTrace();
            throw new ApplicationServerInternalException(throwable);
        }
        finally {
            if (this.state == State.SYSTEM_EXCEPTION) {
                this.recreateInstance(exceptionThrown);
            }
            this.state = State.NONE;
        }
    }

    private void recreateInstance(boolean exceptionAlreadyThrown) throws UnavailableException {
        block2: {
            try {
                this.instance = this.instanceFactory.recreateInstance(this.instance);
            }
            catch (UnavailableException e) {
                this.state = State.RELEASED;
                if (exceptionAlreadyThrown) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.state == State.RELEASED) {
            return;
        }
        this.state = State.RELEASED;
        try {
            this.container.release(this.deployment, this.instance);
        }
        finally {
            this.instanceFactory.freeInstance((Instance)this.instance, false);
            this.instance = null;
        }
    }

    private boolean isValidException(Method method, Throwable throwable) {
        Class<?>[] exceptionTypes;
        if (throwable instanceof RuntimeException || throwable instanceof Error) {
            return true;
        }
        for (Class<?> exceptionType : exceptionTypes = method.getExceptionTypes()) {
            if (!exceptionType.isInstance(throwable)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NONE,
        BEFORE_CALLED,
        METHOD_CALLED,
        SYSTEM_EXCEPTION,
        RELEASED;

    }
}

