/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.ContainerType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.mdb.EndpointFactory;
import org.apache.openejb.core.mdb.Instance;
import org.apache.openejb.core.mdb.MdbContext;
import org.apache.openejb.core.mdb.MdbInstanceFactory;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class MdbContainer
implements RpcContainer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private static final Object[] NO_ARGS = new Object[0];
    private final Object containerID;
    private final SecurityService securityService;
    private final ResourceAdapter resourceAdapter;
    private final Class messageListenerInterface;
    private final Class activationSpecClass;
    private final int instanceLimit;
    private final ConcurrentMap<Object, CoreDeploymentInfo> deployments = new ConcurrentHashMap<Object, CoreDeploymentInfo>();
    private final XAResourceWrapper xaResourceWrapper;

    public MdbContainer(Object containerID, SecurityService securityService, ResourceAdapter resourceAdapter, Class messageListenerInterface, Class activationSpecClass, int instanceLimit) {
        this.containerID = containerID;
        this.securityService = securityService;
        this.resourceAdapter = resourceAdapter;
        this.messageListenerInterface = messageListenerInterface;
        this.activationSpecClass = activationSpecClass;
        this.instanceLimit = instanceLimit;
        this.xaResourceWrapper = (XAResourceWrapper)SystemInstance.get().getComponent(XAResourceWrapper.class);
    }

    public DeploymentInfo[] deployments() {
        return this.deployments.values().toArray(new DeploymentInfo[this.deployments.size()]);
    }

    public DeploymentInfo getDeploymentInfo(Object deploymentID) {
        return (DeploymentInfo)this.deployments.get(deploymentID);
    }

    public ContainerType getContainerType() {
        return ContainerType.MESSAGE_DRIVEN;
    }

    public Object getContainerID() {
        return this.containerID;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public Class getMessageListenerInterface() {
        return this.messageListenerInterface;
    }

    public Class getActivationSpecClass() {
        return this.activationSpecClass;
    }

    public void deploy(DeploymentInfo info) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)info;
        Object deploymentId = deploymentInfo.getDeploymentID();
        if (!deploymentInfo.getMdbInterface().equals(this.messageListenerInterface)) {
            throw new OpenEJBException("Deployment '" + deploymentId + "' has message listener interface " + deploymentInfo.getMdbInterface().getName() + " but this MDB container only supports " + this.messageListenerInterface);
        }
        ActivationSpec activationSpec = this.createActivationSpec(deploymentInfo);
        MdbInstanceFactory instanceFactory = new MdbInstanceFactory(deploymentInfo, this.securityService, this.instanceLimit);
        EndpointFactory endpointFactory = new EndpointFactory(activationSpec, this, deploymentInfo, instanceFactory, this.xaResourceWrapper);
        deploymentInfo.setContainer(this);
        deploymentInfo.setContainerData(endpointFactory);
        this.deployments.put(deploymentId, deploymentInfo);
        try {
            this.resourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, activationSpec);
        }
        catch (ResourceException e) {
            deploymentInfo.setContainer(null);
            deploymentInfo.setContainerData(null);
            this.deployments.remove(deploymentId);
            throw new OpenEJBException(e);
        }
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    private ActivationSpec createActivationSpec(DeploymentInfo deploymentInfo) throws OpenEJBException {
        try {
            ObjectRecipe objectRecipe = new ObjectRecipe(this.activationSpecClass);
            objectRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            objectRecipe.disallow(Option.FIELD_INJECTION);
            Map<String, String> activationProperties = deploymentInfo.getActivationProperties();
            for (Map.Entry<String, String> entry : activationProperties.entrySet()) {
                objectRecipe.setMethodProperty(entry.getKey(), (Object)entry.getValue());
            }
            ActivationSpec activationSpec = (ActivationSpec)objectRecipe.create(this.activationSpecClass.getClassLoader());
            TreeSet unusedProperties = new TreeSet(objectRecipe.getUnsetProperties().keySet());
            unusedProperties.remove("destination");
            unusedProperties.remove("destinationType");
            if (!unusedProperties.isEmpty()) {
                throw new IllegalArgumentException("No setter found for the activation spec properties: " + unusedProperties);
            }
            try {
                activationSpec.validate();
            }
            catch (UnsupportedOperationException uoe) {
                logger.info("ActivationSpec does not support validate. Implementation of validate is optional");
            }
            activationSpec.setResourceAdapter(this.resourceAdapter);
            return activationSpec;
        }
        catch (Exception e) {
            throw new OpenEJBException("Unable to create activation spec", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentInfo info) throws OpenEJBException {
        if (!(info instanceof CoreDeploymentInfo)) {
            return;
        }
        CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)info;
        try {
            EndpointFactory endpointFactory = (EndpointFactory)deploymentInfo.getContainerData();
            if (endpointFactory != null) {
                this.resourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, endpointFactory.getActivationSpec());
            }
        }
        finally {
            deploymentInfo.setContainer(null);
            deploymentInfo.setContainerData(null);
            this.deployments.remove(deploymentInfo.getDeploymentID());
        }
    }

    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deploymentId, Class callInterface, Method method, Object[] args, Object primKey) throws OpenEJBException {
        Instance instance;
        CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)this.getDeploymentInfo(deploymentId);
        EndpointFactory endpointFactory = (EndpointFactory)deploymentInfo.getContainerData();
        MdbInstanceFactory instanceFactory = endpointFactory.getInstanceFactory();
        try {
            instance = (Instance)instanceFactory.createInstance(true);
        }
        catch (UnavailableException e) {
            throw new SystemException("Unable to create instance for invocation", e);
        }
        try {
            this.beforeDelivery(deploymentInfo, instance, method, null);
            Object value = this.invoke((Object)instance, method, args);
            this.afterDelivery(instance);
            Object object = value;
            return object;
        }
        finally {
            instanceFactory.freeInstance(instance, true);
        }
    }

    public void beforeDelivery(CoreDeploymentInfo deployInfo, Object instance, Method method, XAResource xaResource) throws SystemException {
        ThreadContext callContext = new ThreadContext(deployInfo, null);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        MdbCallContext mdbCallContext = new MdbCallContext();
        callContext.set(MdbCallContext.class, mdbCallContext);
        mdbCallContext.deliveryMethod = method;
        mdbCallContext.oldCallContext = oldContext;
        try {
            mdbCallContext.txPolicy = EjbTransactionUtil.createTransactionPolicy(deployInfo.getTransactionType(method), callContext);
            if (xaResource != null && mdbCallContext.txPolicy.isNewTransaction()) {
                mdbCallContext.txPolicy.enlistResource(xaResource);
            }
        }
        catch (ApplicationException e) {
            ThreadContext.exit(oldContext);
            throw new SystemException("Should never get an Application exception", e);
        }
        catch (SystemException e) {
            ThreadContext.exit(oldContext);
            throw e;
        }
        catch (Exception e) {
            ThreadContext.exit(oldContext);
            throw new SystemException("Unable to enlist xa resource in the transaction", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object instance, Method method, Object ... args) throws SystemException, ApplicationException {
        Object object;
        if (args == null) {
            args = NO_ARGS;
        }
        ThreadContext callContext = ThreadContext.getThreadContext();
        CoreDeploymentInfo deployInfo = callContext.getDeploymentInfo();
        MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
        if (mdbCallContext == null) {
            throw new IllegalStateException("beforeDelivery was not called");
        }
        if (!mdbCallContext.deliveryMethod.getName().equals(method.getName())) throw new IllegalStateException("Delivery method specified in beforeDelivery is not the delivery method called");
        if (!Arrays.deepEquals(mdbCallContext.deliveryMethod.getParameterTypes(), method.getParameterTypes())) {
            throw new IllegalStateException("Delivery method specified in beforeDelivery is not the delivery method called");
        }
        Object returnValue = null;
        OpenEJBException openEjbException = null;
        Operation oldOperation = callContext.getCurrentOperation();
        callContext.setCurrentOperation(Operation.BUSINESS);
        BaseContext.State[] originalStates = callContext.setCurrentAllowedStates(MdbContext.getStates());
        try {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("invoking method " + method.getName() + " on " + deployInfo.getDeploymentID());
                }
                Method targetMethod = deployInfo.getMatchingBeanMethod(method);
                callContext.set(Method.class, targetMethod);
                object = returnValue = this._invoke(instance, targetMethod, args, deployInfo, mdbCallContext);
                Object var14_15 = null;
                callContext.setCurrentOperation(oldOperation);
                callContext.setCurrentAllowedStates(originalStates);
            }
            catch (ApplicationException e) {
                openEjbException = e;
                throw e;
            }
            catch (SystemException e) {
                openEjbException = e;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            callContext.setCurrentOperation(oldOperation);
            callContext.setCurrentAllowedStates(originalStates);
            if (!logger.isDebugEnabled()) throw throwable;
            if (openEjbException == null) {
                logger.debug("finished invoking method " + method.getName() + ". Return value:" + returnValue);
                throw throwable;
            }
            Throwable exception = openEjbException.getRootCause() != null ? openEjbException.getRootCause() : openEjbException;
            logger.debug("finished invoking method " + method.getName() + " with exception " + exception);
            throw throwable;
        }
        if (!logger.isDebugEnabled()) return object;
        if (openEjbException == null) {
            logger.debug("finished invoking method " + method.getName() + ". Return value:" + returnValue);
            return object;
        }
        Throwable exception = openEjbException.getRootCause() != null ? openEjbException.getRootCause() : openEjbException;
        logger.debug("finished invoking method " + method.getName() + " with exception " + exception);
        return object;
    }

    private Object _invoke(Object instance, Method runMethod, Object[] args, DeploymentInfo deploymentInfo, MdbCallContext mdbCallContext) throws SystemException, ApplicationException {
        try {
            List<InterceptorData> interceptors = deploymentInfo.getMethodInterceptors(runMethod);
            InterceptorStack interceptorStack = new InterceptorStack(((Instance)instance).bean, runMethod, Operation.BUSINESS, interceptors, ((Instance)instance).interceptors);
            Object returnValue = interceptorStack.invoke(args);
            return returnValue;
        }
        catch (Throwable e) {
            ExceptionType type;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ((type = deploymentInfo.getExceptionType(e)) == ExceptionType.SYSTEM) {
                EjbTransactionUtil.handleSystemException(mdbCallContext.txPolicy, e, ThreadContext.getThreadContext());
            } else {
                EjbTransactionUtil.handleApplicationException(mdbCallContext.txPolicy, e, false);
            }
            throw new AssertionError((Object)"Should not get here");
        }
    }

    public void afterDelivery(Object instance) throws SystemException {
        ThreadContext callContext = ThreadContext.getThreadContext();
        MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
        try {
            try {
                EjbTransactionUtil.afterInvoke(mdbCallContext.txPolicy, callContext);
            }
            catch (ApplicationException e) {
                throw new SystemException("Should never get an Application exception", e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            ThreadContext.exit(mdbCallContext.oldCallContext);
            throw throwable;
        }
        ThreadContext.exit(mdbCallContext.oldCallContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release(CoreDeploymentInfo deployInfo, Object instance) {
        MdbCallContext mdbCallContext;
        ThreadContext callContext = ThreadContext.getThreadContext();
        if (callContext == null) {
            callContext = new ThreadContext(deployInfo, null);
            ThreadContext.enter(callContext);
        }
        if ((mdbCallContext = callContext.get(MdbCallContext.class)) == null) return;
        try {
            try {
                EjbTransactionUtil.afterInvoke(mdbCallContext.txPolicy, callContext);
            }
            catch (Exception e) {
                logger.error("error while releasing message endpoint", e);
                Object var7_6 = null;
                EndpointFactory endpointFactory = (EndpointFactory)deployInfo.getContainerData();
                endpointFactory.getInstanceFactory().freeInstance((Instance)instance, false);
                ThreadContext.exit(mdbCallContext.oldCallContext);
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            EndpointFactory endpointFactory = (EndpointFactory)deployInfo.getContainerData();
            endpointFactory.getInstanceFactory().freeInstance((Instance)instance, false);
            ThreadContext.exit(mdbCallContext.oldCallContext);
            throw throwable;
        }
        EndpointFactory endpointFactory = (EndpointFactory)deployInfo.getContainerData();
        endpointFactory.getInstanceFactory().freeInstance((Instance)instance, false);
        ThreadContext.exit(mdbCallContext.oldCallContext);
    }

    private static class MdbCallContext {
        private Method deliveryMethod;
        private TransactionPolicy txPolicy;
        private ThreadContext oldCallContext;

        private MdbCallContext() {
        }
    }
}

