/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security;

import java.net.URL;
import java.net.URLDecoder;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.openejb.core.security.AbstractSecurityService;
import org.apache.openejb.core.security.jaas.UsernamePasswordCallbackHandler;
import org.apache.openejb.core.security.jacc.BasicJaccProvider;
import org.apache.openejb.util.ConfUtils;

public class SecurityServiceImpl
extends AbstractSecurityService {
    public SecurityServiceImpl() {
        this(BasicJaccProvider.class.getName());
    }

    public SecurityServiceImpl(String jaccProviderClass) {
        super(jaccProviderClass);
        SecurityServiceImpl.installJaas();
        try {
            this.login("", "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void installJaas() {
        String path = System.getProperty("java.security.auth.login.config");
        if (path != null) {
            return;
        }
        URL loginConfig = ConfUtils.getConfResource("login.config");
        System.setProperty("java.security.auth.login.config", URLDecoder.decode(loginConfig.toExternalForm()));
    }

    public UUID login(String realmName, String username, String password) throws LoginException {
        if (realmName == null) {
            realmName = this.getRealmName();
        }
        LoginContext context = new LoginContext(realmName, new UsernamePasswordCallbackHandler(username, password));
        context.login();
        Subject subject = context.getSubject();
        return this.registerSubject(subject);
    }
}

