/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.singleton;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.Injection;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.singleton.EjbWsContext;
import org.apache.openejb.core.singleton.Instance;
import org.apache.openejb.core.singleton.SingletonContext;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SafeToolkit;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class SingletonInstanceManager {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    protected final SafeToolkit toolkit = SafeToolkit.getToolkit("SingletonInstanceManager");
    private SecurityService securityService;

    public SingletonInstanceManager(SecurityService securityService) {
        this.securityService = securityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance getInstance(ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Data data = (Data)deploymentInfo.getContainerData();
        if (data.instance == null) {
            Class beanClass = deploymentInfo.getBeanClass();
            ObjectRecipe objectRecipe = new ObjectRecipe(beanClass);
            objectRecipe.allow(Option.FIELD_INJECTION);
            objectRecipe.allow(Option.PRIVATE_PROPERTIES);
            objectRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            objectRecipe.allow(Option.NAMED_PARAMETERS);
            Operation originalOperation = callContext.getCurrentOperation();
            BaseContext.State[] originalAllowedStates = callContext.getCurrentAllowedStates();
            try {
                SessionContext sessionContext;
                Context ctx = deploymentInfo.getJndiEnc();
                SingletonInstanceManager singletonInstanceManager = this;
                synchronized (singletonInstanceManager) {
                    try {
                        sessionContext = (SessionContext)ctx.lookup("java:comp/EJBContext");
                    }
                    catch (NamingException e1) {
                        sessionContext = this.createSessionContext();
                        ctx.bind("java:comp/EJBContext", (Object)sessionContext);
                    }
                }
                if (SessionBean.class.isAssignableFrom(beanClass) || this.hasSetSessionContext(beanClass)) {
                    callContext.setCurrentOperation(Operation.INJECTION);
                    callContext.setCurrentAllowedStates(SingletonContext.getStates());
                    objectRecipe.setProperty("sessionContext", (Object)sessionContext);
                }
                singletonInstanceManager = this;
                synchronized (singletonInstanceManager) {
                    try {
                        ctx.lookup("java:comp/WebServiceContext");
                    }
                    catch (NamingException e) {
                        EjbWsContext wsContext = new EjbWsContext(sessionContext);
                        ctx.bind("java:comp/WebServiceContext", (Object)wsContext);
                    }
                }
                SingletonInstanceManager.fillInjectionProperties(objectRecipe, beanClass, deploymentInfo, ctx);
                Object bean = objectRecipe.create(beanClass.getClassLoader());
                Map unsetProperties = objectRecipe.getUnsetProperties();
                if (unsetProperties.size() > 0) {
                    for (Object property : unsetProperties.keySet()) {
                        logger.warning("Injection: No such property '" + property + "' in class " + beanClass.getName());
                    }
                }
                HashMap<String, Object> interceptorInstances = new HashMap<String, Object>();
                for (InterceptorData interceptorData : deploymentInfo.getAllInterceptors()) {
                    if (interceptorData.getInterceptorClass().equals(beanClass)) continue;
                    Class clazz = interceptorData.getInterceptorClass();
                    ObjectRecipe interceptorRecipe = new ObjectRecipe(clazz);
                    interceptorRecipe.allow(Option.FIELD_INJECTION);
                    interceptorRecipe.allow(Option.PRIVATE_PROPERTIES);
                    interceptorRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                    interceptorRecipe.allow(Option.NAMED_PARAMETERS);
                    SingletonInstanceManager.fillInjectionProperties(interceptorRecipe, clazz, deploymentInfo, ctx);
                    try {
                        Object interceptorInstance = interceptorRecipe.create(clazz.getClassLoader());
                        interceptorInstances.put(clazz.getName(), interceptorInstance);
                    }
                    catch (ConstructionException e) {
                        throw new Exception("Failed to create interceptor: " + clazz.getName(), e);
                    }
                }
                interceptorInstances.put(beanClass.getName(), bean);
                callContext.setCurrentOperation(Operation.POST_CONSTRUCT);
                callContext.setCurrentAllowedStates(SingletonContext.getStates());
                List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(bean, null, Operation.POST_CONSTRUCT, callbackInterceptors, interceptorInstances);
                interceptorStack.invoke(new Object[0]);
                if (bean instanceof SessionBean) {
                    callContext.setCurrentOperation(Operation.CREATE);
                    callContext.setCurrentAllowedStates(SingletonContext.getStates());
                    Method create = deploymentInfo.getCreateMethod();
                    interceptorStack = new InterceptorStack(bean, create, Operation.CREATE, new ArrayList<InterceptorData>(), new HashMap<String, Object>());
                    interceptorStack.invoke(new Object[0]);
                }
                ReadWriteLock lock = deploymentInfo.isBeanManagedConcurrency() ? new BeanManagedLock() : new ReentrantReadWriteLock();
                data.instance = new Instance(bean, interceptorInstances, lock);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                String t = "The bean instance threw a system exception:" + e;
                logger.error(t, e);
                throw new ApplicationException(new RemoteException("Cannot obtain a free instance.", e));
            }
            finally {
                callContext.setCurrentOperation(originalOperation);
                callContext.setCurrentAllowedStates(originalAllowedStates);
            }
        }
        return data.instance;
    }

    private static void fillInjectionProperties(ObjectRecipe objectRecipe, Class clazz, CoreDeploymentInfo deploymentInfo, Context context) {
        boolean usePrefix = true;
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            usePrefix = false;
        }
        for (Injection injection : deploymentInfo.getInjections()) {
            if (!injection.getTarget().isAssignableFrom(clazz)) continue;
            try {
                String jndiName = injection.getJndiName();
                Object object = context.lookup("java:comp/env/" + jndiName);
                String prefix = usePrefix ? injection.getTarget().getName() + "/" : "";
                if (object instanceof String) {
                    String string = (String)object;
                    objectRecipe.setProperty(prefix + injection.getName(), (Object)string);
                    continue;
                }
                objectRecipe.setProperty(prefix + injection.getName(), object);
            }
            catch (NamingException e) {
                logger.warning("Injection data not found in enc: jndiName='" + injection.getJndiName() + "', target=" + injection.getTarget() + "/" + injection.getName());
            }
        }
    }

    private boolean hasSetSessionContext(Class beanClass) {
        try {
            beanClass.getMethod("setSessionContext", SessionContext.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private SessionContext createSessionContext() {
        return new SingletonContext(this.securityService);
    }

    public void freeInstance(ThreadContext callContext) {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Data data = (Data)deploymentInfo.getContainerData();
        Instance instance = data.instance;
        if (instance == null) {
            return;
        }
        try {
            callContext.setCurrentOperation(Operation.PRE_DESTROY);
            callContext.setCurrentAllowedStates(SingletonContext.getStates());
            Method remove = instance.bean instanceof SessionBean ? deploymentInfo.getCreateMethod() : null;
            List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
            InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
            interceptorStack.invoke(new Object[0]);
        }
        catch (Throwable re) {
            logger.error("Singleton shutdown failed: " + deploymentInfo.getDeploymentID(), re);
        }
    }

    public void discardInstance(ThreadContext callContext, Object bean) {
    }

    public void deploy(CoreDeploymentInfo deploymentInfo) {
        Data data = new Data();
        deploymentInfo.setContainerData(data);
    }

    public void undeploy(CoreDeploymentInfo deploymentInfo) {
        Data data = (Data)deploymentInfo.getContainerData();
        if (data == null) {
            return;
        }
        deploymentInfo.setContainerData(null);
    }

    private static class BeanManagedLock
    implements ReadWriteLock {
        private final Lock lock = new Lock(){

            public void lock() {
            }

            public void lockInterruptibly() {
            }

            public Condition newCondition() {
                throw new UnsupportedOperationException("newCondition()");
            }

            public boolean tryLock() {
                return true;
            }

            public boolean tryLock(long time, TimeUnit unit) {
                return true;
            }

            public void unlock() {
            }
        };

        private BeanManagedLock() {
        }

        public Lock readLock() {
            return this.lock;
        }

        public Lock writeLock() {
            return this.lock;
        }
    }

    private static final class Data {
        private Instance instance;

        private Data() {
        }
    }
}

