/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openejb.core.stateful.Cache;
import org.apache.openejb.core.stateful.PassivationStrategy;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCache<K, V>
implements Cache<K, V> {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final ConcurrentHashMap<K, Entry> cache = new ConcurrentHashMap();
    private final Queue<Entry> lru = new LinkedBlockingQueue<Entry>();
    private Cache.CacheListener<V> listener;
    private PassivationStrategy passivator;
    private int capacity;
    private int bulkPassivate;
    private long timeOut;

    public SimpleCache() {
    }

    public SimpleCache(Cache.CacheListener<V> listener, PassivationStrategy passivator, int capacity, int bulkPassivate, Duration timeOut) {
        this.listener = listener;
        this.passivator = passivator;
        this.capacity = capacity;
        this.bulkPassivate = bulkPassivate;
        this.timeOut = timeOut.getUnit().convert(timeOut.getTime(), TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized Cache.CacheListener<V> getListener() {
        return this.listener;
    }

    @Override
    public synchronized void setListener(Cache.CacheListener<V> listener) {
        this.listener = listener;
    }

    public synchronized PassivationStrategy getPassivator() {
        return this.passivator;
    }

    public synchronized void setPassivator(PassivationStrategy passivator) {
        this.passivator = passivator;
    }

    public synchronized void setPassivator(Class<? extends PassivationStrategy> passivatorClass) throws Exception {
        this.passivator = passivatorClass.newInstance();
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public synchronized void setPoolSize(int capacity) {
        this.capacity = capacity;
    }

    public synchronized int getBulkPassivate() {
        return this.bulkPassivate;
    }

    public synchronized void setBulkPassivate(int bulkPassivate) {
        this.bulkPassivate = bulkPassivate;
    }

    public synchronized long getTimeOut() {
        return this.timeOut;
    }

    public synchronized void setTimeOut(long timeOut) {
        this.timeOut = timeOut * 60L * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(K key, V value) {
        Entry entry = this.cache.get(key);
        if (entry != null) {
            entry.lock.lock();
            try {
                if (entry.getState() != EntryState.REMOVED) {
                    throw new IllegalStateException("An entry for the key " + key + " already exists");
                }
                this.cache.remove(key);
                this.lru.remove(entry);
                Object var5_4 = null;
                entry.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                entry.lock.unlock();
                throw throwable;
            }
        }
        entry = new Entry(key, value, EntryState.CHECKED_OUT);
        this.cache.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V checkOut(K key) throws Exception {
        block8: for (int i = 0; i < 10; ++i) {
            Object object;
            Object var6_5;
            Entry entry;
            block12: {
                V v;
                block11: {
                    entry = this.cache.get(key);
                    if (entry == null && (entry = this.loadEntry(key)) == null) {
                        return null;
                    }
                    entry.lock.lock();
                    try {
                        switch (entry.getState()) {
                            case AVAILABLE: {
                                break;
                            }
                            case CHECKED_OUT: {
                                throw new IllegalStateException("The entry " + key + " is already checked-out");
                            }
                            case PASSIVATED: {
                                this.cache.remove(key, entry);
                                var6_5 = null;
                                entry.lock.unlock();
                                continue block8;
                            }
                            case REMOVED: {
                                v = null;
                                break block11;
                            }
                        }
                        entry.setState(EntryState.CHECKED_OUT);
                        this.lru.remove(entry);
                        object = entry.getValue();
                        break block12;
                    }
                    catch (Throwable throwable) {
                        var6_5 = null;
                        entry.lock.unlock();
                        throw throwable;
                    }
                }
                var6_5 = null;
                entry.lock.unlock();
                return v;
            }
            var6_5 = null;
            entry.lock.unlock();
            return (V)object;
        }
        Entry entry = this.cache.remove(key);
        if (entry != null) {
            this.lru.remove(entry);
        }
        throw new RuntimeException("Cache is corrupted: the entry " + key + " in the Map 'cache' is in state PASSIVATED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIn(K key) {
        Entry entry = this.cache.get(key);
        if (entry == null) {
            return;
        }
        entry.lock.lock();
        try {
            switch (entry.getState()) {
                case AVAILABLE: {
                    throw new IllegalStateException("The entry " + key + " is not checked-out");
                }
                case PASSIVATED: {
                    throw new IllegalStateException("The entry " + key + " is not checked-out");
                }
                case REMOVED: {
                    Object var4_3 = null;
                    entry.lock.unlock();
                    return;
                }
            }
            entry.setState(EntryState.AVAILABLE);
            this.lru.add(entry);
            entry.resetTimeOut();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            entry.lock.unlock();
            throw throwable;
        }
        Object var4_4 = null;
        entry.lock.unlock();
        this.processLRU();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        Object object;
        Entry entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        entry.lock.lock();
        try {
            this.cache.remove(key);
            this.lru.remove(entry);
            entry.setState(EntryState.REMOVED);
            object = entry.getValue();
            Object var5_4 = null;
            entry.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            entry.lock.unlock();
            throw throwable;
        }
        return (V)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Cache.CacheFilter<V> filter) {
        Iterator<Entry> iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            Object var5_4;
            Entry entry = iterator.next();
            entry.lock.lock();
            try {
                if (filter.matches(entry.getValue())) {
                    iterator.remove();
                    this.lru.remove(entry);
                    entry.setState(EntryState.REMOVED);
                }
                var5_4 = null;
                entry.lock.unlock();
            }
            catch (Throwable throwable) {
                var5_4 = null;
                entry.lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processLRU() {
        Entry entry;
        Cache.CacheListener<Object> listener = this.getListener();
        Iterator iterator = this.lru.iterator();
        block22: while (iterator.hasNext()) {
            Object var6_6;
            Entry entry2 = (Entry)iterator.next();
            entry2.lock.lock();
            try {
                switch (entry2.getState()) {
                    case AVAILABLE: {
                        break;
                    }
                    case CHECKED_OUT: {
                        var6_6 = null;
                        entry2.lock.unlock();
                        continue block22;
                    }
                    case PASSIVATED: {
                        iterator.remove();
                        var6_6 = null;
                        entry2.lock.unlock();
                        continue block22;
                    }
                    case REMOVED: {
                        iterator.remove();
                        var6_6 = null;
                        entry2.lock.unlock();
                        continue block22;
                    }
                }
                if (entry2.isTimedOut()) {
                    iterator.remove();
                    this.cache.remove(entry2.getKey());
                    entry2.setState(EntryState.REMOVED);
                    if (listener != null) {
                        try {
                            listener.timedOut(entry2.getValue());
                        }
                        catch (Exception e) {
                            logger.error("An unexpected exception occured from timedOut callback", e);
                        }
                    }
                } else {
                    var6_6 = null;
                    entry2.lock.unlock();
                    break;
                }
                var6_6 = null;
                entry2.lock.unlock();
            }
            catch (Throwable throwable) {
                var6_6 = null;
                entry2.lock.unlock();
                throw throwable;
            }
        }
        if (this.lru.size() < this.getCapacity()) return;
        LinkedHashMap<Object, Object> valuesToStore = new LinkedHashMap<Object, Object>();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        int bulkPassivate = this.getBulkPassivate();
        if (bulkPassivate < 1) {
            bulkPassivate = 1;
        }
        block23: for (int i = 0; i < bulkPassivate && (entry = this.lru.poll()) != null; ++i) {
            Object var10_12;
            if (!entry.lock.tryLock()) continue;
            try {
                switch (entry.getState()) {
                    case AVAILABLE: {
                        break;
                    }
                    case CHECKED_OUT: {
                        var10_12 = null;
                        entry.lock.unlock();
                        continue block23;
                    }
                    case PASSIVATED: {
                        this.lru.remove(entry);
                        var10_12 = null;
                        entry.lock.unlock();
                        continue block23;
                    }
                    case REMOVED: {
                        this.lru.remove(entry);
                        var10_12 = null;
                        entry.lock.unlock();
                        continue block23;
                    }
                }
                this.cache.remove(entry.getKey());
                this.lru.remove(entry);
                if (entry.isTimedOut()) {
                    entry.setState(EntryState.REMOVED);
                    if (listener != null) {
                        try {
                            listener.timedOut(entry.getValue());
                        }
                        catch (Exception e) {
                            logger.error("An unexpected exception occured from timedOut callback", e);
                        }
                    }
                } else {
                    entry.lock.lock();
                    entries.add(entry);
                    entry.setState(EntryState.PASSIVATED);
                    valuesToStore.put(entry.getKey(), entry.getValue());
                }
                var10_12 = null;
                entry.lock.unlock();
                continue;
            }
            catch (Throwable throwable) {
                var10_12 = null;
                entry.lock.unlock();
                throw throwable;
            }
        }
        if (valuesToStore.isEmpty()) return;
        try {
            this.storeEntries(valuesToStore);
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            Iterator i$ = entries.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    throw throwable;
                }
                Entry entry3 = (Entry)i$.next();
                entry3.lock.unlock();
            }
        }
        for (Entry entry3 : entries) {
            entry3.lock.unlock();
        }
        return;
    }

    private Entry loadEntry(K key) throws Exception {
        PassivationStrategy passivator = this.getPassivator();
        if (passivator == null) {
            return null;
        }
        Object value = null;
        try {
            value = passivator.activate(key);
        }
        catch (Exception e) {
            logger.error("An unexpected exception occured while reading entries from disk", e);
        }
        if (value == null) {
            return null;
        }
        Cache.CacheListener<Object> listener = this.getListener();
        if (listener != null) {
            listener.afterLoad(value);
        }
        Entry entry = new Entry(key, value, EntryState.AVAILABLE);
        this.cache.put(key, entry);
        return entry;
    }

    private void storeEntries(Map<K, V> entriesToStore) {
        Cache.CacheListener<V> listener = this.getListener();
        Iterator<Map.Entry<K, V>> iterator = entriesToStore.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (listener == null) continue;
            try {
                listener.beforeStore(entry.getValue());
            }
            catch (Exception e) {
                iterator.remove();
                logger.error("An unexpected exception occured from beforeStore callback", e);
            }
        }
        PassivationStrategy passivator = this.getPassivator();
        if (passivator == null) {
            return;
        }
        try {
            passivator.passivate(entriesToStore);
        }
        catch (Exception e) {
            logger.error("An unexpected exception occured while writting the entries to disk", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        private final K key;
        private final V value;
        private final ReentrantLock lock = new ReentrantLock();
        private EntryState state;
        private long lastAccess;

        private Entry(K key, V value, EntryState state) {
            this.key = key;
            this.value = value;
            this.state = state;
            this.lastAccess = System.currentTimeMillis();
        }

        private K getKey() {
            this.assertLockHeld();
            return this.key;
        }

        private V getValue() {
            this.assertLockHeld();
            return this.value;
        }

        private EntryState getState() {
            this.assertLockHeld();
            return this.state;
        }

        private void setState(EntryState state) {
            this.assertLockHeld();
            this.state = state;
        }

        private boolean isTimedOut() {
            this.assertLockHeld();
            long timeOut = SimpleCache.this.getTimeOut();
            if (timeOut == 0L) {
                return false;
            }
            long now = System.currentTimeMillis();
            return now - this.lastAccess > timeOut;
        }

        private void resetTimeOut() {
            this.assertLockHeld();
            if (SimpleCache.this.getTimeOut() > 0L) {
                this.lastAccess = System.currentTimeMillis();
            }
        }

        private void assertLockHeld() {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Entry must be locked");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EntryState {
        AVAILABLE,
        CHECKED_OUT,
        PASSIVATED,
        REMOVED;

    }
}

