/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateless;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.interceptor.AroundInvoke;
import javax.xml.rpc.handler.MessageContext;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.ContainerType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.stateless.Instance;
import org.apache.openejb.core.stateless.StatelessContext;
import org.apache.openejb.core.stateless.StatelessInstanceManager;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.webservices.AddressingSupport;
import org.apache.openejb.core.webservices.NoAddressingSupport;
import org.apache.openejb.finder.ClassFinder;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;

public class StatelessContainer
implements RpcContainer {
    private StatelessInstanceManager instanceManager;
    private HashMap<String, DeploymentInfo> deploymentRegistry = new HashMap();
    private Object containerID = null;
    private SecurityService securityService;

    public StatelessContainer(Object id, SecurityService securityService, int timeOut, int poolSize, boolean strictPooling) throws OpenEJBException {
        this.containerID = id;
        this.securityService = securityService;
        this.instanceManager = new StatelessInstanceManager(securityService, new Duration(timeOut, TimeUnit.MILLISECONDS), poolSize, strictPooling);
        for (DeploymentInfo deploymentInfo : this.deploymentRegistry.values()) {
            CoreDeploymentInfo di = (CoreDeploymentInfo)deploymentInfo;
            di.setContainer(this);
        }
    }

    public synchronized DeploymentInfo[] deployments() {
        return this.deploymentRegistry.values().toArray(new DeploymentInfo[this.deploymentRegistry.size()]);
    }

    public synchronized DeploymentInfo getDeploymentInfo(Object deploymentID) {
        String id = (String)deploymentID;
        return this.deploymentRegistry.get(id);
    }

    public ContainerType getContainerType() {
        return ContainerType.STATELESS;
    }

    public Object getContainerID() {
        return this.containerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentInfo info) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = (CoreDeploymentInfo)info;
        this.instanceManager.deploy(deploymentInfo);
        String id = (String)deploymentInfo.getDeploymentID();
        StatelessContainer statelessContainer = this;
        synchronized (statelessContainer) {
            this.deploymentRegistry.put(id, deploymentInfo);
            deploymentInfo.setContainer(this);
        }
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    public void undeploy(DeploymentInfo info) {
        this.undeploy((CoreDeploymentInfo)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy(CoreDeploymentInfo deploymentInfo) {
        this.instanceManager.undeploy(deploymentInfo);
        EjbTimerService timerService = deploymentInfo.getEjbTimerService();
        if (timerService != null) {
            timerService.stop();
        }
        StatelessContainer statelessContainer = this;
        synchronized (statelessContainer) {
            String id = (String)deploymentInfo.getDeploymentID();
            deploymentInfo.setContainer(null);
            deploymentInfo.setContainerData(null);
            this.deploymentRegistry.remove(id);
        }
    }

    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deployID, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        ThreadContext oldCallContext;
        ThreadContext callContext;
        CoreDeploymentInfo deployInfo;
        block9: {
            Class<?> declaringClass;
            block7: {
                block8: {
                    ProxyInfo proxyInfo;
                    deployInfo = (CoreDeploymentInfo)this.getDeploymentInfo(deployID);
                    if (deployInfo == null) {
                        throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
                    }
                    callContext = new ThreadContext(deployInfo, primKey);
                    oldCallContext = ThreadContext.enter(callContext);
                    try {
                        boolean authorized = this.getSecurityService().isCallerAuthorized(callMethod, deployInfo.getInterfaceType(callInterface));
                        if (!authorized) {
                            throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
                        }
                        declaringClass = callMethod.getDeclaringClass();
                        if (!EJBHome.class.isAssignableFrom(declaringClass) && !EJBLocalHome.class.isAssignableFrom(declaringClass)) break block7;
                        if (!callMethod.getName().startsWith("create")) break block8;
                        proxyInfo = this.createEJBObject(deployInfo, callMethod);
                        Object var16_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_19 = null;
                        ThreadContext.exit(oldCallContext);
                        throw throwable;
                    }
                    ThreadContext.exit(oldCallContext);
                    return proxyInfo;
                }
                Object var11_12 = null;
                Object var16_16 = null;
                ThreadContext.exit(oldCallContext);
                return var11_12;
            }
            if (EJBObject.class != declaringClass && EJBLocalObject.class != declaringClass) break block9;
            Object var11_13 = null;
            Object var16_17 = null;
            ThreadContext.exit(oldCallContext);
            return var11_13;
        }
        Object bean = this.instanceManager.getInstance(callContext);
        callContext.setCurrentOperation(Operation.BUSINESS);
        callContext.setCurrentAllowedStates(StatelessContext.getStates());
        Method runMethod = deployInfo.getMatchingBeanMethod(callMethod);
        callContext.set(Method.class, runMethod);
        callContext.setInvokedInterface(callInterface);
        Object retValue = this._invoke(callInterface, callMethod, runMethod, args, (Instance)bean, callContext);
        this.instanceManager.poolInstance(callContext, bean);
        Object object = retValue;
        Object var16_18 = null;
        ThreadContext.exit(oldCallContext);
        return object;
    }

    private SecurityService getSecurityService() {
        return this.securityService;
    }

    public StatelessInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    protected Object _invoke(Class callInterface, Method callMethod, Method runMethod, Object[] args, Object object, ThreadContext callContext) throws OpenEJBException {
        return this._invoke(callInterface, callMethod, runMethod, args, (Instance)object, callContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object _invoke(Class callInterface, Method callMethod, Method runMethod, Object[] args, Instance instance, ThreadContext callContext) throws OpenEJBException {
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(deploymentInfo.getTransactionType(callMethod), callContext);
        Object returnValue = null;
        try {
            try {
                InterfaceType type = deploymentInfo.getInterfaceType(callInterface);
                if (type == InterfaceType.SERVICE_ENDPOINT) {
                    callContext.setCurrentOperation(Operation.BUSINESS_WS);
                    returnValue = this.invokeWebService(args, deploymentInfo, runMethod, instance, returnValue);
                }
                List<InterceptorData> interceptors = deploymentInfo.getMethodInterceptors(runMethod);
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS, interceptors, instance.interceptors);
                returnValue = interceptorStack.invoke(args);
            }
            catch (Throwable re) {
                ExceptionType type = deploymentInfo.getExceptionType(re);
                if (type == ExceptionType.SYSTEM) {
                    EjbTransactionUtil.handleSystemException(txPolicy, re, callContext);
                } else {
                    this.instanceManager.poolInstance(callContext, instance);
                    EjbTransactionUtil.handleApplicationException(txPolicy, re, type == ExceptionType.APPLICATION_ROLLBACK);
                }
                Object var14_16 = null;
                EjbTransactionUtil.afterInvoke(txPolicy, callContext);
                return returnValue;
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            throw throwable;
        }
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
        return returnValue;
    }

    private Object invokeWebService(Object[] args, CoreDeploymentInfo deploymentInfo, Method runMethod, Instance instance, Object returnValue) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("WebService calls must follow format {messageContext, interceptor, [arg...]}.");
        }
        Object messageContext = args[0];
        Object interceptor = args[1];
        HashMap<String, Object> interceptors = new HashMap<String, Object>(instance.interceptors);
        interceptors.put(interceptor.getClass().getName(), interceptor);
        ArrayList<InterceptorData> interceptorDatas = new ArrayList<InterceptorData>(deploymentInfo.getMethodInterceptors(runMethod));
        InterceptorData providerData = new InterceptorData(interceptor.getClass());
        ClassFinder finder = new ClassFinder(new Class[]{interceptor.getClass()});
        providerData.getAroundInvoke().addAll(finder.findAnnotatedMethods(AroundInvoke.class));
        interceptorDatas.add(providerData);
        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS_WS, interceptorDatas, interceptors);
        Object[] params = new Object[runMethod.getParameterTypes().length];
        if (messageContext instanceof MessageContext) {
            ThreadContext.getThreadContext().set(MessageContext.class, (MessageContext)messageContext);
            returnValue = interceptorStack.invoke((MessageContext)messageContext, params);
        } else if (messageContext instanceof javax.xml.ws.handler.MessageContext) {
            AddressingSupport wsaSupport = NoAddressingSupport.INSTANCE;
            for (int i = 2; i < args.length; ++i) {
                if (!(args[i] instanceof AddressingSupport)) continue;
                wsaSupport = (AddressingSupport)args[i];
            }
            ThreadContext.getThreadContext().set(AddressingSupport.class, wsaSupport);
            ThreadContext.getThreadContext().set(javax.xml.ws.handler.MessageContext.class, (javax.xml.ws.handler.MessageContext)messageContext);
            returnValue = interceptorStack.invoke((javax.xml.ws.handler.MessageContext)messageContext, params);
        }
        return returnValue;
    }

    protected ProxyInfo createEJBObject(CoreDeploymentInfo deploymentInfo, Method callMethod) {
        return new ProxyInfo(deploymentInfo, null);
    }
}

