/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.transaction;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionRolledbackException;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public abstract class JtaTransactionPolicy
implements TransactionPolicy {
    protected static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    protected static final Logger txLogger = Logger.getInstance(LogCategory.TRANSACTION, "org.apache.openejb.util.resources");
    protected final TransactionType transactionType;
    protected final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry synchronizationRegistry;
    private Map<Object, Object> resources;
    private final List<TransactionPolicy.TransactionSynchronization> synchronizations = new LinkedList<TransactionPolicy.TransactionSynchronization>();
    private boolean rollbackOnly;

    public JtaTransactionPolicy(TransactionType transactionType, TransactionManager transactionManager) {
        this.transactionType = transactionType;
        this.transactionManager = transactionManager;
        this.synchronizationRegistry = (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    protected abstract Transaction getCurrentTrasaction();

    public boolean isTransactionActive() {
        Transaction trasaction = this.getCurrentTrasaction();
        if (trasaction == null) {
            return false;
        }
        try {
            int status = trasaction.getStatus();
            return status == 0 || status == 1;
        }
        catch (javax.transaction.SystemException e) {
            return false;
        }
    }

    public boolean isRollbackOnly() {
        Transaction trasaction = this.getCurrentTrasaction();
        if (trasaction != null) {
            try {
                int status = trasaction.getStatus();
                return status == 1;
            }
            catch (javax.transaction.SystemException e) {
                return false;
            }
        }
        return this.rollbackOnly;
    }

    public void setRollbackOnly() {
        Transaction trasaction = this.getCurrentTrasaction();
        if (trasaction != null) {
            this.setRollbackOnly(trasaction);
        } else {
            this.rollbackOnly = true;
        }
    }

    public Object getResource(Object key) {
        if (this.isTransactionActive()) {
            return this.synchronizationRegistry.getResource(key);
        }
        if (this.resources == null) {
            return null;
        }
        return this.resources.get(key);
    }

    public void putResource(Object key, Object value) {
        if (this.isTransactionActive()) {
            this.synchronizationRegistry.putResource(key, value);
        }
        if (this.resources == null) {
            this.resources = new LinkedHashMap<Object, Object>();
        }
        this.resources.put(key, value);
    }

    public Object removeResource(Object key) {
        if (this.isTransactionActive()) {
            Object value = this.synchronizationRegistry.getResource(key);
            this.synchronizationRegistry.putResource(key, null);
            return value;
        }
        if (this.resources == null) {
            return null;
        }
        return this.resources.remove(key);
    }

    public void registerSynchronization(final TransactionPolicy.TransactionSynchronization synchronization) {
        if (this.isTransactionActive()) {
            this.synchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                public void beforeCompletion() {
                    synchronization.beforeCompletion();
                }

                public void afterCompletion(int s) {
                    TransactionPolicy.TransactionSynchronization.Status status = s == 3 ? TransactionPolicy.TransactionSynchronization.Status.COMMITTED : (s == 4 ? TransactionPolicy.TransactionSynchronization.Status.ROLLEDBACK : TransactionPolicy.TransactionSynchronization.Status.UNKNOWN);
                    synchronization.afterCompletion(status);
                }
            });
        } else {
            this.synchronizations.add(synchronization);
        }
    }

    protected void fireNonTransactionalCompletion() {
        for (TransactionPolicy.TransactionSynchronization synchronization : new ArrayList<TransactionPolicy.TransactionSynchronization>(this.synchronizations)) {
            try {
                synchronization.beforeCompletion();
            }
            catch (Throwable e) {
                logger.error("Exception thrown from beforeCompletion() of TransactionSynchronization " + synchronization);
            }
        }
        TransactionPolicy.TransactionSynchronization.Status status = this.isRollbackOnly() ? TransactionPolicy.TransactionSynchronization.Status.ROLLEDBACK : TransactionPolicy.TransactionSynchronization.Status.COMMITTED;
        for (TransactionPolicy.TransactionSynchronization synchronization : new ArrayList<TransactionPolicy.TransactionSynchronization>(this.synchronizations)) {
            try {
                synchronization.afterCompletion(status);
            }
            catch (Exception e) {
                logger.error("Exception thrown from afterCompletion(" + (Object)((Object)status) + ") of TransactionSynchronization " + synchronization);
            }
        }
    }

    public void enlistResource(XAResource xaResource) throws SystemException {
        Transaction transaction = this.getCurrentTrasaction();
        if (transaction != null) {
            try {
                if (transaction.enlistResource(xaResource)) {
                    return;
                }
            }
            catch (Exception e) {
                throw new SystemException("Unable to enlist xa resource in the transaction", e);
            }
        }
        throw new SystemException("Unable to enlist xa resource in the transaction");
    }

    public String toString() {
        return this.transactionType.toString();
    }

    protected Transaction getTransaction() throws SystemException {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (javax.transaction.SystemException e) {
            txLogger.error("The Transaction Manager has encountered an unexpected error condition while attempting to obtain current transaction: {}", e.getMessage());
            throw new SystemException(e);
        }
    }

    protected void setRollbackOnly(Transaction tx) {
        try {
            if (tx != null && tx.getStatus() == 0) {
                tx.setRollbackOnly();
                txLogger.debug("TX {}: setRollbackOnly() on transaction {}", new Object[]{this.transactionType, tx});
            }
        }
        catch (Exception e) {
            txLogger.error("Exception during setRollbackOnly()", e);
            throw new IllegalStateException("No transaction active", e);
        }
    }

    protected Transaction beginTransaction() throws SystemException {
        Transaction transaction;
        try {
            this.transactionManager.begin();
            transaction = this.transactionManager.getTransaction();
        }
        catch (Exception e) {
            txLogger.error("The Transaction Manager has encountered an unexpected error condition while attempting to begin a new transaction: {}", e.getMessage());
            throw new SystemException(e);
        }
        if (transaction == null) {
            throw new SystemException("Failed to begin a new transaction");
        }
        txLogger.debug("TX {}: Started transaction {}", new Object[]{this.transactionType, transaction});
        return transaction;
    }

    protected Transaction suspendTransaction() throws SystemException {
        try {
            Transaction tx = this.transactionManager.suspend();
            txLogger.info("TX {}: Suspended transaction {}", new Object[]{this.transactionType, tx});
            return tx;
        }
        catch (javax.transaction.SystemException se) {
            txLogger.error("Exception during suspend()", se);
            throw new SystemException(se);
        }
    }

    protected void resumeTransaction(Transaction tx) throws SystemException {
        try {
            if (tx == null) {
                txLogger.debug("TX {}: No transaction to resume", new Object[]{this.transactionType});
            } else {
                txLogger.debug("TX {}: Resuming transaction {}", new Object[]{this.transactionType, tx});
                this.transactionManager.resume(tx);
            }
        }
        catch (InvalidTransactionException ite) {
            txLogger.error("Could not resume the client's transaction, the transaction is no longer valid: {}", ite.getMessage());
            throw new SystemException(ite);
        }
        catch (IllegalStateException e) {
            txLogger.error("Could not resume the client's transaction: {}", e.getMessage());
            throw new SystemException(e);
        }
        catch (javax.transaction.SystemException e) {
            txLogger.error("Could not resume the client's transaction: The transaction reported a system exception: {}", e.getMessage());
            throw new SystemException(e);
        }
    }

    protected void completeTransaction(Transaction tx) throws SystemException, ApplicationException {
        boolean shouldRollback;
        try {
            shouldRollback = tx.getStatus() != 0;
        }
        catch (javax.transaction.SystemException e) {
            txLogger.error("The Transaction Manager has encountered an unexpected error condition while attempting to obtain transaction status: {}", e.getMessage());
            throw new SystemException(e);
        }
        if (shouldRollback) {
            this.rollbackTransaction(tx);
            return;
        }
        try {
            txLogger.debug("TX {}: Committing transaction {}", new Object[]{this.transactionType, tx});
            if (tx.equals(this.transactionManager.getTransaction())) {
                this.transactionManager.commit();
            } else {
                tx.commit();
            }
        }
        catch (RollbackException e) {
            txLogger.debug("The transaction has been rolled back rather than commited: {}", e.getMessage());
            TransactionRolledbackException txe = new TransactionRolledbackException("Transaction was rolled back, presumably because setRollbackOnly was called during a synchronization").initCause(e);
            throw new ApplicationException((Throwable)((Object)txe));
        }
        catch (HeuristicMixedException e) {
            txLogger.debug("A heuristic decision was made, some relevant updates have been committed while others have been rolled back: {}", e.getMessage());
            throw new ApplicationException(new RemoteException("A heuristic decision was made, some relevant updates have been committed while others have been rolled back").initCause(e));
        }
        catch (HeuristicRollbackException e) {
            txLogger.debug("A heuristic decision was made while commiting the transaction, some relevant updates have been rolled back: {}", e.getMessage());
            throw new ApplicationException(new RemoteException("A heuristic decision was made while commiting the transaction, some relevant updates have been rolled back").initCause(e));
        }
        catch (SecurityException e) {
            txLogger.error("The current thread is not allowed to commit the transaction: {}", e.getMessage());
            throw new SystemException(e);
        }
        catch (IllegalStateException e) {
            txLogger.error("The current thread is not associated with a transaction: {}", e.getMessage());
            throw new SystemException(e);
        }
        catch (javax.transaction.SystemException e) {
            txLogger.error("The Transaction Manager has encountered an unexpected error condition while attempting to commit the transaction: {}", e.getMessage());
            throw new SystemException(e);
        }
    }

    protected void rollbackTransaction(Transaction tx) throws SystemException {
        try {
            txLogger.debug("TX {}: Rolling back transaction {}", new Object[]{this.transactionType, tx});
            if (tx.equals(this.transactionManager.getTransaction())) {
                this.transactionManager.rollback();
            } else {
                tx.rollback();
            }
        }
        catch (IllegalStateException e) {
            logger.error("The TransactionManager reported an exception while attempting to rollback the transaction: " + e.getMessage());
            throw new SystemException(e);
        }
        catch (javax.transaction.SystemException e) {
            logger.error("The TransactionManager reported an exception while attempting to rollback the transaction: " + e.getMessage());
            throw new SystemException(e);
        }
    }
}

