/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.transaction;

import java.rmi.RemoteException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.CoreUserTransaction;
import org.apache.openejb.core.transaction.BeanTransactionPolicy;
import org.apache.openejb.core.transaction.JtaTransactionPolicy;
import org.apache.openejb.core.transaction.TransactionType;

public class TxBeanManaged
extends JtaTransactionPolicy
implements BeanTransactionPolicy {
    private Transaction clientTx = this.suspendTransaction();

    public TxBeanManaged(TransactionManager transactionManager) throws SystemException {
        super(TransactionType.BeanManaged, transactionManager);
    }

    public boolean isNewTransaction() {
        return false;
    }

    protected Transaction getCurrentTrasaction() {
        try {
            return this.getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Exception getting current transaction");
        }
    }

    public UserTransaction getUserTransaction() {
        return new CoreUserTransaction(this.transactionManager);
    }

    public BeanTransactionPolicy.SuspendedTransaction suspendUserTransaction() throws SystemException {
        Transaction currentTx = this.suspendTransaction();
        if (currentTx == null) {
            return null;
        }
        txLogger.info("TX {}: Suspended transaction {}", new Object[]{this.transactionType, currentTx});
        return new JtaSuspendedTransaction(currentTx);
    }

    public void resumeUserTransaction(BeanTransactionPolicy.SuspendedTransaction suspendedTransaction) throws SystemException {
        if (suspendedTransaction == null) {
            throw new NullPointerException("suspendedTransaction is null");
        }
        Transaction beanTransaction = ((JtaSuspendedTransaction)suspendedTransaction).transaction;
        if (beanTransaction == null) {
            throw new SystemException("Bean transaction has already been resumed or destroyed");
        }
        try {
            this.resumeTransaction(beanTransaction);
        }
        catch (SystemException e) {
            suspendedTransaction.destroy();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws ApplicationException, SystemException {
        try {
            Transaction currentTx = this.getTransaction();
            if (currentTx != null) {
                String message = "The EJB started a transaction but did not complete it.";
                logger.error(message);
                try {
                    this.rollbackTransaction(currentTx);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ApplicationException(new RemoteException(message));
            }
            this.fireNonTransactionalCompletion();
        }
        finally {
            this.resumeTransaction(this.clientTx);
        }
    }

    private static class JtaSuspendedTransaction
    implements BeanTransactionPolicy.SuspendedTransaction {
        private Transaction transaction;

        public JtaSuspendedTransaction(Transaction transaction) {
            if (transaction == null) {
                throw new NullPointerException("transaction is null");
            }
            this.transaction = transaction;
        }

        public void destroy() {
            Transaction beanTransaction = this.transaction;
            this.transaction = null;
            if (beanTransaction == null) {
                return;
            }
            try {
                beanTransaction.rollback();
            }
            catch (Exception e) {
                JtaTransactionPolicy.logger.error("Error rolling back suspended transaction for discarded stateful session bean instance");
            }
        }
    }
}

