/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.persistence;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.persistence.JtaQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtaEntityManager
implements EntityManager {
    private final JtaEntityManagerRegistry registry;
    private final EntityManagerFactory entityManagerFactory;
    private final Map properties;
    private final boolean extended;

    public JtaEntityManager(JtaEntityManagerRegistry registry, EntityManagerFactory entityManagerFactory, Map properties) {
        this(registry, entityManagerFactory, properties, false);
    }

    public JtaEntityManager(JtaEntityManagerRegistry registry, EntityManagerFactory entityManagerFactory, Map properties, boolean extended) {
        if (registry == null) {
            throw new NullPointerException("registry is null");
        }
        if (entityManagerFactory == null) {
            throw new NullPointerException("entityManagerFactory is null");
        }
        this.registry = registry;
        this.entityManagerFactory = entityManagerFactory;
        this.properties = properties;
        this.extended = extended;
    }

    private EntityManager getEntityManager() {
        return this.registry.getEntityManager(this.entityManagerFactory, this.properties, this.extended);
    }

    private boolean isTransactionActive() {
        return this.registry.isTransactionActive();
    }

    private void assertTransactionActive() throws TransactionRequiredException {
        if (!this.extended && !this.isTransactionActive()) {
            throw new TransactionRequiredException();
        }
    }

    private void closeIfNoTx(EntityManager entityManager) {
        if (!this.extended && !this.isTransactionActive()) {
            entityManager.close();
        }
    }

    public EntityManager getDelegate() {
        return this.getEntityManager();
    }

    public void persist(Object entity) {
        this.assertTransactionActive();
        this.getEntityManager().persist(entity);
    }

    public <T> T merge(T entity) {
        this.assertTransactionActive();
        return (T)this.getEntityManager().merge(entity);
    }

    public void remove(Object entity) {
        this.assertTransactionActive();
        this.getEntityManager().remove(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        Object object;
        EntityManager entityManager = this.getEntityManager();
        try {
            object = entityManager.find(entityClass, primaryKey);
            Object var6_5 = null;
            this.closeIfNoTx(entityManager);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.closeIfNoTx(entityManager);
            throw throwable;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        Object object;
        EntityManager entityManager = this.getEntityManager();
        try {
            object = entityManager.getReference(entityClass, primaryKey);
            Object var6_5 = null;
            this.closeIfNoTx(entityManager);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.closeIfNoTx(entityManager);
            throw throwable;
        }
        return (T)object;
    }

    public void flush() {
        this.assertTransactionActive();
        this.getEntityManager().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        EntityManager entityManager = this.getEntityManager();
        try {
            entityManager.setFlushMode(flushMode);
            Object var4_3 = null;
            this.closeIfNoTx(entityManager);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.closeIfNoTx(entityManager);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        EntityManager entityManager = this.getEntityManager();
        try {
            FlushModeType flushModeType = entityManager.getFlushMode();
            Object var4_3 = null;
            this.closeIfNoTx(entityManager);
            return flushModeType;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.closeIfNoTx(entityManager);
            throw throwable;
        }
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.assertTransactionActive();
        this.getEntityManager().lock(entity, lockMode);
    }

    public void refresh(Object entity) {
        this.assertTransactionActive();
        this.getEntityManager().refresh(entity);
    }

    public void clear() {
        if (!this.isTransactionActive()) {
            return;
        }
        this.getEntityManager().clear();
    }

    public boolean contains(Object entity) {
        return this.isTransactionActive() && this.getEntityManager().contains(entity);
    }

    public Query createQuery(String qlString) {
        EntityManager entityManager = this.getEntityManager();
        Query query = entityManager.createQuery(qlString);
        return this.proxyIfNoTx(entityManager, query);
    }

    public Query createNamedQuery(String name) {
        EntityManager entityManager = this.getEntityManager();
        Query query = entityManager.createNamedQuery(name);
        return this.proxyIfNoTx(entityManager, query);
    }

    public Query createNativeQuery(String sqlString) {
        EntityManager entityManager = this.getEntityManager();
        Query query = entityManager.createNativeQuery(sqlString);
        return this.proxyIfNoTx(entityManager, query);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        EntityManager entityManager = this.getEntityManager();
        Query query = entityManager.createNativeQuery(sqlString, resultClass);
        return this.proxyIfNoTx(entityManager, query);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        EntityManager entityManager = this.getEntityManager();
        Query query = entityManager.createNativeQuery(sqlString, resultSetMapping);
        return this.proxyIfNoTx(entityManager, query);
    }

    private Query proxyIfNoTx(EntityManager entityManager, Query query) {
        if (!this.extended && !this.isTransactionActive()) {
            return new JtaQuery(entityManager, query);
        }
        return query;
    }

    public void joinTransaction() {
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("A JTA Entity Manager can not use an entity transaction");
    }
}

