/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;

public class OpenEjbBrokerFactory
implements BrokerFactory.BrokerFactoryHandler {
    private static final ThreadLocal<Properties> threadProperties = new ThreadLocal();

    public static void setThreadProperties(Properties value) {
        threadProperties.set(value);
    }

    public BrokerService createBroker(URI brokerURI) throws Exception {
        URI uri = new URI(brokerURI.getRawSchemeSpecificPart());
        BrokerService broker = BrokerFactory.createBroker((URI)uri);
        Properties properties = this.getLowerCaseProperties();
        Object value = properties.get("datasource");
        if (value instanceof String && value.toString().length() == 0) {
            value = null;
        }
        if (value != null) {
            DataSource dataSource;
            if (value instanceof DataSource) {
                dataSource = (DataSource)value;
            } else {
                String resouceId = (String)value;
                try {
                    ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
                    Context context = containerSystem.getJNDIContext();
                    Object obj = context.lookup("java:openejb/Resource/" + resouceId);
                    if (!(obj instanceof DataSource)) {
                        throw new IllegalArgumentException("Resource with id " + resouceId + " is not a DataSource, but is " + obj.getClass().getName());
                    }
                    dataSource = (DataSource)obj;
                }
                catch (NamingException e) {
                    throw new IllegalArgumentException("Unknown datasource " + resouceId);
                }
            }
            JDBCPersistenceAdapter persistenceAdapter = new JDBCPersistenceAdapter();
            persistenceAdapter.setDataSource(dataSource);
            broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        } else {
            MemoryPersistenceAdapter persistenceAdapter = new MemoryPersistenceAdapter();
            broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        }
        return broker;
    }

    private Properties getLowerCaseProperties() {
        Properties properties = threadProperties.get();
        Properties newProperties = new Properties();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    key = ((String)key).toLowerCase();
                }
                newProperties.put(key, entry.getValue());
            }
        }
        return newProperties;
    }
}

