/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.openejb.finder.ResourceFinder;
import org.apache.openejb.resource.jdbc.DataSourcePlugin;

public final class BasicDataSourceUtil {
    private BasicDataSourceUtil() {
    }

    public static DataSourcePlugin getDataSourcePlugin(String jdbcUrl) throws SQLException {
        String vendor = BasicDataSourceUtil.getJdbcName(jdbcUrl);
        if (vendor == null) {
            return null;
        }
        String pluginClassName = null;
        try {
            ResourceFinder finder = new ResourceFinder("META-INF");
            Map plugins = finder.mapAvailableStrings(DataSourcePlugin.class.getName());
            pluginClassName = (String)plugins.get(vendor);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (pluginClassName == null || pluginClassName.length() <= 0) {
            return null;
        }
        try {
            Class<?> pluginClass = Class.forName(pluginClassName);
            DataSourcePlugin plugin = (DataSourcePlugin)pluginClass.newInstance();
            return plugin;
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Unable to load data source helper class '" + pluginClassName + "' for database '" + vendor + "'");
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Unable to create data source helper class '" + pluginClassName + "' for database '" + vendor + "'").initCause(e);
        }
    }

    public static String getJdbcName(String jdbcUrl) {
        if (jdbcUrl == null) {
            return null;
        }
        if (!jdbcUrl.startsWith("jdbc:")) {
            return null;
        }
        int index = (jdbcUrl = jdbcUrl.substring("jdbc:".length())).indexOf(58);
        if (index >= 0) {
            jdbcUrl = jdbcUrl.substring(0, index);
        }
        return jdbcUrl;
    }
}

