/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.File;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.BasicDataSourceUtil;
import org.apache.openejb.resource.jdbc.DataSourcePlugin;
import org.apache.openejb.resource.jdbc.IsolationLevels;

public class BasicManagedDataSource
extends org.apache.commons.dbcp.managed.BasicManagedDataSource {
    public synchronized String getUserName() {
        return super.getUsername();
    }

    public synchronized void setUserName(String string) {
        super.setUsername(string);
    }

    public synchronized String getJdbcDriver() {
        return super.getDriverClassName();
    }

    public synchronized void setJdbcDriver(String string) {
        super.setDriverClassName(string);
    }

    public synchronized String getJdbcUrl() {
        return super.getUrl();
    }

    public synchronized void setJdbcUrl(String string) {
        super.setUrl(string);
    }

    public synchronized void setDefaultTransactionIsolation(String s) {
        if (s == null || s.equals("")) {
            return;
        }
        int level = IsolationLevels.getIsolationLevel(s);
        super.setDefaultTransactionIsolation(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized DataSource createDataSource() throws SQLException {
        Properties systemProperties;
        if (this.dataSource != null) {
            return this.dataSource;
        }
        DataSourcePlugin helper = BasicDataSourceUtil.getDataSourcePlugin(this.getUrl());
        if (helper != null) {
            helper.configure((BasicDataSource)this);
        }
        this.wrapTransactionManager();
        if (helper == null || !helper.enableUserDirHack()) {
            return super.createDataSource();
        }
        Properties properties = systemProperties = System.getProperties();
        synchronized (properties) {
            DataSource dataSource;
            String userDir = systemProperties.getProperty("user.dir");
            try {
                File base = SystemInstance.get().getBase().getDirectory();
                systemProperties.setProperty("user.dir", base.getAbsolutePath());
                dataSource = super.createDataSource();
                systemProperties.setProperty("user.dir", userDir);
            }
            catch (Throwable throwable) {
                systemProperties.setProperty("user.dir", userDir);
                throw throwable;
            }
            return dataSource;
        }
    }

    protected void wrapTransactionManager() {
    }
}

