/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Debug {
    public static String printStackTrace(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(baos));
        return new String(baos.toByteArray());
    }

    public static Map<String, Object> contextToMap(Context context) throws NamingException {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        Debug.contextToMap(context, "", map);
        return map;
    }

    public static void contextToMap(Context context, String baseName, Map<String, Object> results) throws NamingException {
        NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
        while (namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.nextElement();
            String name = binding.getName();
            String fullName = baseName + name;
            Object object = binding.getObject();
            results.put(fullName, object);
            if (!(object instanceof Context)) continue;
            Debug.contextToMap((Context)object, fullName + "/", results);
        }
    }

    public static Map<String, Object> printContext(Context context) throws NamingException {
        return Debug.printContext(context, System.out);
    }

    public static Map<String, Object> printContext(Context context, PrintStream out) throws NamingException {
        Map<String, Object> map = Debug.contextToMap(context);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            out.println(entry.getKey() + "=" + entry.getValue().getClass().getName());
        }
        return map;
    }

    public static Map<String, Object> printContextValues(Context context) throws NamingException {
        return Debug.printContextValues(context, System.out);
    }

    public static Map<String, Object> printContextValues(Context context, PrintStream out) throws NamingException {
        Map<String, Object> map = Debug.contextToMap(context);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            out.println(entry.getKey() + "=" + entry.getValue());
        }
        return map;
    }
}

