/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class FactoryFinder {
    private final String path;
    private final ConcurrentHashMap classMap = new ConcurrentHashMap();

    public FactoryFinder(String path) {
        this.path = path;
    }

    public Object newInstance(String key) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        return this.newInstance(key, null);
    }

    public Object newInstance(String key, String propertyPrefix) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        Class clazz;
        if (propertyPrefix == null) {
            propertyPrefix = "";
        }
        if ((clazz = (Class)this.classMap.get(propertyPrefix + key)) == null) {
            clazz = this.newInstance(this.doFindFactoryProperies(key), propertyPrefix);
            this.classMap.put(propertyPrefix + key, clazz);
        }
        return clazz.newInstance();
    }

    private Class newInstance(Properties properties, String propertyPrefix) throws ClassNotFoundException, IOException {
        Class<?> clazz;
        String className = properties.getProperty(propertyPrefix + "class");
        if (className == null) {
            throw new IOException("Expected property is missing: " + propertyPrefix + "class");
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            clazz = FactoryFinder.class.getClassLoader().loadClass(className);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties doFindFactoryProperies(String key) throws IOException {
        Properties properties;
        String uri = this.path + key;
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
        if (in == null && (in = FactoryFinder.class.getClassLoader().getResourceAsStream(uri)) == null) {
            throw new IOException("Could not find factory class for resource: " + uri);
        }
        BufferedInputStream reader = null;
        try {
            reader = new BufferedInputStream(in);
            Properties properties2 = new Properties();
            properties2.load(reader);
            properties = properties2;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                reader.close();
            }
            catch (Exception e) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return properties;
    }
}

