/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class JarExtractor {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");

    public static File extract(File file, String pathname) throws IOException {
        File docBase = new File(file.getParentFile(), pathname);
        JarExtractor.extract(file, docBase);
        return docBase;
    }

    /*
     * Loose catch block
     */
    public static void extract(File file, File destinationDir) throws IOException {
        block18: {
            Throwable t22;
            InputStream input;
            JarFile jarFile;
            block17: {
                if (destinationDir.exists()) {
                    return;
                }
                logger.info("Extracting jar: " + file.getAbsolutePath());
                destinationDir.mkdirs();
                jarFile = null;
                input = null;
                jarFile = new JarFile(file);
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String name = jarEntry.getName();
                    int last = name.lastIndexOf(47);
                    if (last >= 0) {
                        File parent = new File(destinationDir, name.substring(0, last));
                        parent.mkdirs();
                    }
                    if (name.endsWith("/")) continue;
                    input = jarFile.getInputStream(jarEntry);
                    File extractedFile = JarExtractor.extract(input, destinationDir, name);
                    long lastModified = jarEntry.getTime();
                    if (lastModified != -1L && lastModified != 0L && extractedFile != null) {
                        extractedFile.setLastModified(lastModified);
                    }
                    input.close();
                    input = null;
                }
                Object var12_11 = null;
                if (input == null) break block17;
                try {
                    input.close();
                }
                catch (Throwable t22) {
                    // empty catch block
                }
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t22) {}
            }
            break block18;
            {
                catch (IOException e) {
                    JarExtractor.deleteDir(destinationDir);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Throwable t22;
                Object var12_12 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable t22) {
                        // empty catch block
                    }
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable t22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        logger.info("Extracted path: " + destinationDir.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean copy(File src, File dest) {
        String[] files;
        boolean result = true;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            IOException e2222;
            Object var11_10;
            AbstractInterruptibleChannel oc;
            FileChannel ic;
            File fileDest;
            File fileSrc;
            block20: {
                fileSrc = new File(src, files[i]);
                fileDest = new File(dest, files[i]);
                if (fileSrc.isDirectory()) {
                    result = JarExtractor.copy(fileSrc, fileDest);
                    continue;
                }
                ic = null;
                oc = null;
                ic = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic.transferTo(0L, ic.size(), (WritableByteChannel)((Object)oc));
                var11_10 = null;
                if (ic == null) break block20;
                try {
                    ic.close();
                }
                catch (IOException e2222) {
                    // empty catch block
                }
            }
            if (oc == null) continue;
            try {
                oc.close();
            }
            catch (IOException e2222) {}
            continue;
            {
                catch (IOException e3) {
                    logger.error("Copy failed: src: " + fileSrc + ", dest: " + fileDest, e3);
                    result = false;
                    var11_10 = null;
                    if (ic != null) {
                        try {
                            ic.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (oc == null) continue;
                    try {
                        oc.close();
                    }
                    catch (IOException e2222) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_10 = null;
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                if (oc != null) {
                    try {
                        oc.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    public static boolean delete(File dir) {
        if (dir == null) {
            return true;
        }
        if (dir.isDirectory()) {
            return JarExtractor.deleteDir(dir);
        }
        return dir.delete();
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return true;
        }
        String[] fileNames = dir.list();
        if (fileNames == null) {
            fileNames = new String[]{};
        }
        for (String fileName : fileNames) {
            File file = new File(dir, fileName);
            if (file.isDirectory()) {
                JarExtractor.deleteDir(file);
                continue;
            }
            file.delete();
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static File extract(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        BufferedOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                output.write(buffer, 0, n);
            }
            Object var8_7 = null;
            if (output == null) return file;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (output == null) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            output.close();
            return file;
        }
        catch (IOException e) {}
        return file;
    }
}

