/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.Properties;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, Options.class);

    public static int getInt(Properties p, String property, int defaultValue) {
        String value = p.getProperty(property);
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
            return defaultValue;
        }
        catch (NumberFormatException e) {
            Options.warn(property, value, defaultValue, e);
            return defaultValue;
        }
    }

    public static long getLong(Properties p, String property, long defaultValue) {
        String value = p.getProperty(property);
        try {
            if (value != null) {
                return Long.parseLong(value);
            }
            return defaultValue;
        }
        catch (NumberFormatException e) {
            Options.warn(property, value, defaultValue, e);
            return defaultValue;
        }
    }

    public static boolean getBoolean(Properties p, String property, boolean defaultValue) {
        String value = p.getProperty(property);
        try {
            if (value != null) {
                return Boolean.parseBoolean(value);
            }
            return defaultValue;
        }
        catch (NumberFormatException e) {
            Options.warn(property, value, defaultValue, e);
            return defaultValue;
        }
    }

    public static <T extends Enum<T>> T getEnum(Properties p, String property, T defaultValue) {
        String value = p.getProperty(property);
        try {
            if (value != null) {
                Class<?> enumType = defaultValue.getClass();
                return (T)Enum.valueOf(enumType, value.toUpperCase());
            }
            return defaultValue;
        }
        catch (IllegalArgumentException e) {
            Options.warn(property, value, defaultValue, e);
            return defaultValue;
        }
    }

    private static void warn(String property, String value, Object defaultValue, Exception e) {
        logger.warning("Cannot parse supplied value \"" + value + "\" for option \"" + property + "\".  Using default of \"" + defaultValue + "\"", e);
    }
}

