/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import org.apache.openejb.util.CircularReferencesException;
import org.apache.openejb.util.Join;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class References {
    public static <T> List<T> sort(List<T> objects, Visitor<T> visitor) {
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        for (T obj : objects) {
            String name = visitor.getName(obj);
            Node node = new Node(name, obj);
            nodes.put(name, node);
        }
        for (Node node : nodes.values()) {
            for (String name : visitor.getReferences(node.object)) {
                Node ref = (Node)nodes.get(name);
                if (ref == null) {
                    throw new IllegalArgumentException("No such object in list: " + name);
                }
                node.references.add(ref);
                ref.refernceCount++;
            }
        }
        ArrayList<Node> sortedNodes = new ArrayList<Node>(nodes.size());
        LinkedList<Node> leafNodes = new LinkedList<Node>();
        for (Node n : nodes.values()) {
            if (n.refernceCount != 0) continue;
            if (n.references.size() == 0) {
                sortedNodes.add(n);
                continue;
            }
            leafNodes.add(n);
        }
        while (!leafNodes.isEmpty()) {
            Node node = (Node)leafNodes.removeFirst();
            sortedNodes.add(node);
            for (Node ref : node.references) {
                ref.refernceCount--;
                if (ref.refernceCount != 0) continue;
                leafNodes.add(ref);
            }
        }
        if (sortedNodes.size() != nodes.size()) {
            LinkedHashSet<Circuit> circuits = new LinkedHashSet<Circuit>();
            for (Node node : nodes.values()) {
                References.findCircuits(circuits, node, new Stack<Node>());
            }
            ArrayList list = new ArrayList(circuits);
            Collections.sort(list);
            ArrayList<List> all = new ArrayList<List>();
            for (Circuit circuit : list) {
                all.add(References.unwrap(circuit.nodes));
            }
            throw new CircularReferencesException(all);
        }
        List<T> sortedObjects = References.unwrap(sortedNodes);
        Collections.reverse(sortedObjects);
        return sortedObjects;
    }

    private static <T> List<T> unwrap(List<Node> nodes) {
        ArrayList<Object> referees = new ArrayList<Object>(nodes.size());
        for (Node node : nodes) {
            referees.add(node.object);
        }
        return referees;
    }

    private static void findCircuits(Set<Circuit> circuits, Node node, Stack<Node> stack) {
        if (stack.contains(node)) {
            int fromIndex = stack.indexOf(node);
            int toIndex = stack.size();
            ArrayList<Node> circularity = new ArrayList<Node>(stack.subList(fromIndex, toIndex));
            circularity.add(node);
            Circuit circuit = new Circuit(circularity);
            circuits.add(circuit);
            return;
        }
        stack.push(node);
        for (Node reference : node.references) {
            References.findCircuits(circuits, reference, stack);
        }
        stack.pop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Circuit
    implements Comparable<Circuit> {
        private final List<Node> nodes;
        private final List<Node> atomic;

        public Circuit(List<Node> nodes) {
            this.nodes = nodes;
            this.atomic = new ArrayList<Node>(nodes);
            this.atomic.remove(this.atomic.size() - 1);
            Collections.sort(this.atomic);
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Circuit circuit = (Circuit)o;
            return ((Object)this.atomic).equals(circuit.atomic);
        }

        public int hashCode() {
            return ((Object)this.atomic).hashCode();
        }

        @Override
        public int compareTo(Circuit o) {
            int i = this.atomic.size() - o.atomic.size();
            if (i != 0) {
                return i;
            }
            ListIterator<Node> iterA = this.atomic.listIterator();
            ListIterator<Node> iterB = o.atomic.listIterator();
            while (iterA.hasNext() && iterB.hasNext()) {
                Node b;
                Node a = (Node)iterA.next();
                i = a.compareTo(b = (Node)iterB.next());
                if (i == 0) continue;
                return i;
            }
            return 0;
        }

        public String toString() {
            return "Circuit(" + Join.join(",", References.unwrap(this.nodes)) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node
    implements Comparable<Node> {
        private final String name;
        private Object object;
        private final List<Node> references = new ArrayList<Node>();
        private int refernceCount;

        public Node(String name, Object object) {
            this.name = name;
            this.object = object;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.name.equals(node.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Node o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "Node(" + this.name + " : " + Join.join(",", References.unwrap(this.references)) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor<T> {
        public String getName(T var1);

        public Set<String> getReferences(T var1);
    }
}

