/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedSet<E> {
    private Set<E> current;
    private ReadWriteLock sync = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(E o) {
        Set nextVersion;
        Lock lock;
        block6: {
            lock = this.sync.writeLock();
            lock.lock();
            nextVersion = null;
            try {
                if (this.current.set().contains(o)) break block6;
                nextVersion = new Set(this.current);
                boolean bl = nextVersion.set().add(o);
                Object var6_6 = null;
                if (nextVersion != null) {
                    this.current = nextVersion;
                }
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (nextVersion != null) {
                    this.current = nextVersion;
                }
                lock.unlock();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var6_7 = null;
        if (nextVersion != null) {
            this.current = nextVersion;
        }
        lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        Set nextVersion;
        Lock lock;
        block6: {
            lock = this.sync.writeLock();
            lock.lock();
            nextVersion = null;
            try {
                if (!this.current.set().contains(o)) break block6;
                nextVersion = new Set(this.current);
                boolean bl = nextVersion.set().remove(o);
                Object var6_6 = null;
                if (nextVersion != null) {
                    this.current = nextVersion;
                }
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (nextVersion != null) {
                    this.current = nextVersion;
                }
                lock.unlock();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var6_7 = null;
        if (nextVersion != null) {
            this.current = nextVersion;
        }
        lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<E> currentSet() {
        Lock lock = this.sync.readLock();
        lock.lock();
        try {
            Set<E> set = this.current;
            Object var4_3 = null;
            lock.unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Set<E>
    implements java.util.Set<E> {
        private final int version;
        private final java.util.Set set;

        Set() {
            this.version = 0;
            this.set = new LinkedHashSet();
        }

        Set(Set v) {
            this.version = v.version + 1;
            this.set = new LinkedHashSet(v.set);
        }

        java.util.Set set() {
            return this.set;
        }

        public int getVersion() {
            return this.version;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.set.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.set).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.set).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return this.set.iterator();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.set.toArray(a);
        }
    }
}

