/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.InterceptedMarker;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.BeanCreator;
import org.apache.webbeans.component.creation.ManagedBeanCreatorImpl;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.deployment.StereoTypeModel;
import org.apache.webbeans.deployment.stereotype.IStereoTypeModel;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.inject.InconsistentSpecializationException;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.portable.events.ProcessAnnotatedTypeImpl;
import org.apache.webbeans.portable.events.discovery.AfterBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.discovery.AfterDeploymentValidationImpl;
import org.apache.webbeans.portable.events.discovery.BeforeBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public class BeansDeployer {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(BeansDeployer.class);
    protected final WebBeansXMLConfigurator xmlConfigurator;
    private final WebBeansContext webBeansContext;

    public BeansDeployer(WebBeansXMLConfigurator xmlConfigurator, WebBeansContext webBeansContext) {
        this.xmlConfigurator = xmlConfigurator;
        this.webBeansContext = webBeansContext;
    }

    void configureDefaultBeans() {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        WebBeansUtil webBeansUtil = this.webBeansContext.getWebBeansUtil();
        beanManager.addInternalBean((Bean)webBeansUtil.getManagerBean());
        beanManager.addBean((Bean)webBeansUtil.getConversationBean());
        beanManager.addBean((Bean)webBeansUtil.getInjectionPointBean());
        beanManager.addBean((Bean)webBeansUtil.getInstanceBean());
        beanManager.addBean((Bean)webBeansUtil.getEventBean());
        this.addDefaultBean(beanManager, "org.apache.webbeans.ee.common.beans.PrincipalBean");
        this.addDefaultBean(beanManager, "org.apache.webbeans.ee.beans.ValidatorBean");
        this.addDefaultBean(beanManager, "org.apache.webbeans.ee.beans.ValidatorFactoryBean");
        this.addDefaultBean(beanManager, "org.apache.webbeans.ee.beans.UserTransactionBean");
    }

    private void addDefaultBean(BeanManagerImpl manager, String className) {
        Bean bean = null;
        Class beanClass = ClassUtil.getClassFromName((String)className);
        if (beanClass != null) {
            bean = (Bean)ClassUtil.newInstance((WebBeansContext)this.webBeansContext, (Class)beanClass);
        }
        if (bean != null) {
            manager.addBean(bean);
        }
    }

    void fireBeforeBeanDiscoveryEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.fireEvent((Object)new BeforeBeanDiscoveryImpl(this.webBeansContext), new Annotation[0]);
    }

    void fireAfterBeanDiscoveryEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.fireEvent((Object)new AfterBeanDiscoveryImpl(this.webBeansContext), new Annotation[0]);
        this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by AfterBeanDiscovery event observers. Look at logs for further details");
    }

    void fireAfterDeploymentValidationEvent() {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        manager.fireEvent((Object)new AfterDeploymentValidationImpl(manager), new Annotation[0]);
        this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by AfterDeploymentValidation event observers. Look at logs for further details");
    }

    void validateInjectionPoints() {
        logger.debug("Validation of injection points has started.");
        this.webBeansContext.getDecoratorsManager().validateDecoratorClasses();
        this.webBeansContext.getInterceptorsManager().validateInterceptorClasses();
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        Set<Object> beans = new HashSet();
        Set decorators = manager.getDecorators();
        for (Decorator decorator : decorators) {
            WebBeansDecorator wbDec = (WebBeansDecorator)decorator;
            beans.add((Bean<?>)wbDec);
        }
        logger.debug("Validation of the decorator's injection points has started.");
        this.validate(beans);
        beans.clear();
        for (Interceptor interceptor : manager.getInterceptors()) {
            WebBeansInterceptor wbInt = (WebBeansInterceptor)interceptor;
            beans.add((Bean<?>)wbInt);
        }
        logger.debug("Validation of the interceptor's injection points has started.");
        this.validate(beans);
        beans.clear();
        beans = manager.getBeans();
        this.validate(beans);
        logger.info("INFO_0003");
    }

    private void validate(Set<Bean<?>> beans) {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        if (beans != null && beans.size() > 0) {
            Stack<String> beanNames = new Stack<String>();
            for (Bean<?> bean : beans) {
                String beanName = bean.getName();
                if (beanName != null) {
                    beanNames.push(beanName);
                }
                if (bean instanceof InjectionTargetBean) {
                    if (!(bean instanceof Decorator || bean instanceof Interceptor || bean instanceof NewBean)) {
                        new DefinitionUtil(this.webBeansContext).defineDecoratorStack((AbstractInjectionTargetBean)bean);
                    }
                    if (bean instanceof InterceptedMarker) {
                        new DefinitionUtil(this.webBeansContext).defineBeanInterceptorStack((AbstractInjectionTargetBean)bean);
                    }
                }
                this.checkPassivationScope(bean);
                Set injectionPoints = bean.getInjectionPoints();
                if (injectionPoints == null) continue;
                for (InjectionPoint injectionPoint : injectionPoints) {
                    if (!injectionPoint.isDelegate()) {
                        manager.validate(injectionPoint);
                        continue;
                    }
                    if (bean.getBeanClass().isAnnotationPresent(javax.decorator.Decorator.class) || this.webBeansContext.getBeanManagerImpl().containsCustomDecoratorClass(bean.getBeanClass())) continue;
                    throw new WebBeansConfigurationException("Delegate injection points can not defined by beans that are not decorator. Injection point : " + injectionPoint);
                }
            }
            this.validateBeanNames(beanNames);
            beanNames.clear();
        }
    }

    private void validateBeanNames(Stack<String> beanNames) {
        if (beanNames.size() > 0) {
            for (String beanName : beanNames) {
                for (String other : beanNames) {
                    String part = null;
                    int i = beanName.lastIndexOf(46);
                    if (i != -1) {
                        part = beanName.substring(0, i);
                    }
                    if (beanName.equals(other)) {
                        InjectionResolver resolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
                        Set beans = resolver.implResolveByName(beanName);
                        if (beans.size() <= 1 || (beans = resolver.findByAlternatives(beans)).size() <= 1) continue;
                        throw new WebBeansConfigurationException("There are two different beans with name : " + beanName + " in the deployment archieve");
                    }
                    if (part == null || !part.equals(other)) continue;
                    throw new WebBeansConfigurationException("EL name of one bean is of the form x.y, where y is a valid bean EL name, and x is the EL name of the other bean for the bean name : " + beanName);
                }
            }
        }
    }

    protected void deployFromXML(ScannerService scanner) throws WebBeansDeploymentException {
    }

    protected void checkSpecializations(ScannerService scanner) {
        logger.debug("Checking Specialization constraints has started.");
        try {
            Set beanClasses = scanner.getBeanClasses();
            if (beanClasses != null && beanClasses.size() > 0) {
                ArrayList superClassList = new ArrayList();
                ArrayList<Class> specialClassList = new ArrayList<Class>();
                for (Class specialClass : beanClasses) {
                    if (!AnnotationUtil.hasClassAnnotation((Class)specialClass, Specializes.class)) continue;
                    Class superClass = specialClass.getSuperclass();
                    if (superClass.equals(Object.class)) {
                        throw new WebBeansConfigurationException(logger.getTokenString("EXCEPT_0003") + specialClass.getName() + logger.getTokenString("EXCEPT_0004"));
                    }
                    if (superClassList.contains(superClass)) {
                        throw new InconsistentSpecializationException(logger.getTokenString("EXCEPT_0005") + superClass.getName());
                    }
                    superClassList.add(superClass);
                    specialClassList.add(specialClass);
                }
                this.webBeansContext.getWebBeansUtil().configureSpecializations(specialClassList);
            }
            this.webBeansContext.getWebBeansUtil().configureProducerMethodSpecializations();
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException((Throwable)e);
        }
        logger.debug("Checking Specialization constraints has ended.");
    }

    protected void checkPassivationScope(Bean<?> beanObj) {
        boolean validate = false;
        if (EnterpriseBeanMarker.class.isAssignableFrom(beanObj.getClass())) {
            EnterpriseBeanMarker marker = (EnterpriseBeanMarker)beanObj;
            if (marker.isPassivationCapable()) {
                validate = true;
            }
        } else if (this.webBeansContext.getBeanManagerImpl().isPassivatingScope(beanObj.getScope())) {
            if (WebBeansUtil.isPassivationCapable(beanObj) == null) {
                if (!(beanObj instanceof AbstractProducerBean)) {
                    throw new WebBeansConfigurationException("Passivation scoped defined bean must be passivation capable, but bean : " + beanObj.toString() + " is not passivation capable");
                }
                validate = true;
            }
            validate = true;
        }
        if (validate) {
            ((OwbBean)beanObj).validatePassivationDependencies();
        }
    }

    protected void checkStereoTypes(ScannerService scanner) {
        logger.debug("Checking StereoType constraints has started.");
        this.addDefaultStereoTypes();
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        Set beanClasses = scanner.getBeanClasses();
        if (beanClasses != null && beanClasses.size() > 0) {
            for (Class beanClass : beanClasses) {
                Class stereoClass;
                if (!beanClass.isAnnotation() || !annotationManager.isStereoTypeAnnotation(stereoClass = beanClass)) continue;
                annotationManager.checkStereoTypeClass(stereoClass, stereoClass.getDeclaredAnnotations());
                StereoTypeModel model = new StereoTypeModel(this.webBeansContext, stereoClass);
                this.webBeansContext.getStereoTypeManager().addStereoTypeModel((IStereoTypeModel)model);
            }
        }
        logger.debug("Checking StereoType constraints has ended.");
    }

    protected void addDefaultStereoTypes() {
        StereoTypeModel model = new StereoTypeModel(this.webBeansContext, Model.class);
        this.webBeansContext.getStereoTypeManager().addStereoTypeModel((IStereoTypeModel)model);
        model = new StereoTypeModel(this.webBeansContext, javax.decorator.Decorator.class);
        this.webBeansContext.getStereoTypeManager().addStereoTypeModel((IStereoTypeModel)model);
        model = new StereoTypeModel(this.webBeansContext, javax.interceptor.Interceptor.class);
        this.webBeansContext.getStereoTypeManager().addStereoTypeModel((IStereoTypeModel)model);
    }

    protected <T> boolean defineManagedBean(Class<T> clazz, ProcessAnnotatedTypeImpl<T> processAnnotatedEvent) {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        AnnotatedType annotatedType = processAnnotatedEvent.getAnnotatedType();
        GProcessInjectionTarget processInjectionTargetEvent = null;
        if (this.webBeansContext.getWebBeansUtil().supportsJavaEeComponentInjections(clazz)) {
            processInjectionTargetEvent = this.webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEventForJavaEeComponents(clazz);
            this.webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessInjectionTarget event observers. Look at logs for further details");
            if (processInjectionTargetEvent.isSet()) {
                manager.putInjectionTargetWrapperForJavaEeComponents(clazz, new InjectionTargetWrapper(processInjectionTargetEvent.getInjectionTarget()));
            }
            this.webBeansContext.getAnnotationManager().checkInjectionPointForInjectInjectionPoint(clazz);
        }
        if (this.webBeansContext.getManagedBeanConfigurator().isManagedBean(clazz)) {
            this.webBeansContext.getManagedBeanConfigurator().checkManagedBeanCondition(clazz);
            ManagedBean managedBean = new ManagedBean(clazz, WebBeansType.MANAGED, this.webBeansContext);
            ManagedBeanCreatorImpl managedBeanCreator = new ManagedBeanCreatorImpl(managedBean);
            boolean annotationTypeSet = false;
            if (processAnnotatedEvent.isModifiedAnnotatedType()) {
                annotationTypeSet = true;
                managedBean.setAnnotatedType(annotatedType);
                annotatedType = processAnnotatedEvent.getAnnotatedType();
                managedBeanCreator.setAnnotatedType(annotatedType);
                managedBeanCreator.setMetaDataProvider(BeanCreator.MetaDataProvider.THIRDPARTY);
            }
            if (processInjectionTargetEvent == null) {
                processInjectionTargetEvent = this.webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEvent((AbstractInjectionTargetBean)managedBean);
            }
            if (WebBeansUtil.isAnnotatedTypeDecorator((AnnotatedType)annotatedType)) {
                if (logger.wblWillLogDebug()) {
                    logger.debug("Found Managed Bean Decorator with class name : [{0}]", new Object[]{annotatedType.getJavaClass().getName()});
                }
                if (annotationTypeSet) {
                    this.webBeansContext.getWebBeansUtil().defineDecorator(annotatedType);
                } else {
                    this.webBeansContext.getWebBeansUtil().defineDecorator(managedBeanCreator, (ProcessInjectionTarget)processInjectionTargetEvent);
                }
            } else if (WebBeansUtil.isAnnotatedTypeInterceptor((AnnotatedType)annotatedType)) {
                if (logger.wblWillLogDebug()) {
                    logger.debug("Found Managed Bean Interceptor with class name : [{0}]", new Object[]{annotatedType.getJavaClass().getName()});
                }
                if (annotationTypeSet) {
                    this.webBeansContext.getWebBeansUtil().defineInterceptor(annotatedType);
                } else {
                    this.webBeansContext.getWebBeansUtil().defineInterceptor(managedBeanCreator, (ProcessInjectionTarget)processInjectionTargetEvent);
                }
            } else {
                if (this.webBeansContext.getBeanManagerImpl().containsCustomDecoratorClass(annotatedType.getJavaClass()) || this.webBeansContext.getBeanManagerImpl().containsCustomInterceptorClass(annotatedType.getJavaClass())) {
                    return false;
                }
                if (logger.wblWillLogDebug()) {
                    logger.debug("Found Managed Bean with class name : [{0}]", new Object[]{annotatedType.getJavaClass().getName()});
                }
                this.webBeansContext.getWebBeansUtil().defineManagedBean(managedBeanCreator, (ProcessInjectionTarget)processInjectionTargetEvent, false);
            }
            return true;
        }
        return false;
    }
}

