/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.util.List;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.cdi.OWBContextThreadListener;
import org.apache.openejb.cdi.RequestScopedThreadContextListener;
import org.apache.openejb.cdi.StartupObject;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.cdi.ThreadSingletonServiceImpl;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.SingletonService;

public class CdiBuilder {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(CdiBuilder.class);

    public void build(AppInfo appInfo, AppContext appContext, List<BeanContext> allDeployments) {
        ThreadContext.addThreadContextListener(new RequestScopedThreadContextListener());
        ThreadSingletonService singletonService = (ThreadSingletonService)SystemInstance.get().getComponent(ThreadSingletonService.class);
        logger.info("existing thread singleton service in SystemInstance() " + singletonService);
        if (singletonService == null) {
            singletonService = CdiBuilder.initializeOWB(this.getClass().getClassLoader());
        }
        singletonService.initialize(new StartupObject(appContext, appInfo, allDeployments));
    }

    private boolean hasBeans(AppInfo appInfo) {
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            if (ejbJar.beans == null) continue;
            return true;
        }
        return false;
    }

    public static ThreadSingletonService initializeOWB(ClassLoader classLoader) {
        ThreadSingletonServiceImpl singletonService = new ThreadSingletonServiceImpl();
        logger.info("Created new singletonService " + singletonService);
        SystemInstance.get().setComponent(ThreadSingletonService.class, (Object)singletonService);
        try {
            WebBeansFinder.setSingletonService((SingletonService)singletonService);
            logger.info("succeeded in installing singleton service");
        }
        catch (Exception e) {
            logger.info("Could not install our singleton service", (Throwable)e);
        }
        ThreadContext.addThreadContextListener(new OWBContextThreadListener());
        return singletonService;
    }
}

