/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Remove;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.assembler.classic.ProxyInterfaceResolver;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;

public class CdiEjbBean<T>
extends BaseEjbBean<T> {
    private final BeanContext beanContext;

    public CdiEjbBean(BeanContext beanContext, WebBeansContext webBeansContext) {
        this(beanContext, webBeansContext, beanContext.getBeanClass());
    }

    public CdiEjbBean(BeanContext beanContext, WebBeansContext webBeansContext, Class beanClass) {
        super(beanClass, CdiEjbBean.toSessionType(beanContext.getComponentType()), webBeansContext);
        this.beanContext = beanContext;
        if (beanContext.isLocalbean()) {
            this.addApiType(beanContext.getBeanClass());
        }
        this.addApiType(beanContext.getHomeInterface());
        this.addApiType(beanContext.getLocalHomeInterface());
        for (Class clazz : beanContext.getBusinessLocalInterfaces()) {
            this.addApiType(clazz);
        }
        beanContext.set(Bean.class, this);
    }

    public void addApiType(Class<?> apiType) {
        if (apiType == null) {
            return;
        }
        super.addApiType(apiType);
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    private static SessionBeanType toSessionType(BeanType beanType) {
        switch (beanType) {
            case SINGLETON: {
                return SessionBeanType.SINGLETON;
            }
            case STATELESS: {
                return SessionBeanType.STATELESS;
            }
            case STATEFUL: 
            case MANAGED: {
                return SessionBeanType.STATEFUL;
            }
        }
        throw new IllegalStateException("Unknown Session BeanType " + (Object)((Object)beanType));
    }

    public String getId() {
        return (String)this.beanContext.getDeploymentID() + this.getReturnType().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getInstance(CreationalContext<T> creationalContext) {
        List<Class> classes = this.beanContext.getBusinessLocalInterfaces();
        CurrentCreationalContext currentCreationalContext = this.beanContext.get(CurrentCreationalContext.class);
        CreationalContext existing = currentCreationalContext.get();
        currentCreationalContext.set(creationalContext);
        try {
            if (classes.size() == 0 && this.beanContext.isLocalbean()) {
                BeanContext.BusinessLocalBeanHome home = this.beanContext.getBusinessLocalBeanHome();
                Object object = home.create();
                return (T)object;
            }
            Class mainInterface = classes.get(0);
            List<Class> interfaces = ProxyInterfaceResolver.getInterfaces(this.beanContext.getBeanClass(), mainInterface, classes);
            BeanContext.BusinessLocalHome home = this.beanContext.getBusinessLocalHome(interfaces, mainInterface);
            Object object = home.create();
            return (T)object;
        }
        finally {
            currentCreationalContext.set(existing);
        }
    }

    protected void afterConstructor(T instance, CreationalContext<T> tCreationalContext) {
    }

    public String getEjbName() {
        return this.beanContext.getEjbName();
    }

    public List<Class<?>> getBusinessLocalInterfaces() {
        ArrayList clazzes = new ArrayList();
        if (this.beanContext.isLocalbean()) {
            clazzes.add(this.beanContext.getBeanClass());
        } else if (this.beanContext.getProxyClass() != null) {
            clazzes.add(this.beanContext.getProxyClass());
        } else {
            List<Class> cl = this.beanContext.getBusinessLocalInterfaces();
            if (cl != null && !cl.isEmpty()) {
                for (Class c : cl) {
                    clazzes.add(c);
                }
            }
        }
        return clazzes;
    }

    protected void destroyComponentInstance(T instance, CreationalContext<T> creational) {
        if (instance instanceof BeanContext.Removable) {
            BeanContext.Removable removable = (BeanContext.Removable)instance;
            removable.$$remove();
        }
    }

    protected void destroyStatefulSessionBeanInstance(T proxyInstance, Object ejbInstance) {
        super.destroyStatefulSessionBeanInstance(proxyInstance, ejbInstance);
    }

    public List<Method> getRemoveMethods() {
        return this.findRemove(this.beanContext.getBeanClass(), this.beanContext.getBusinessLocalInterface());
    }

    public List<InjectionPoint> getInjectionPoint(Member member) {
        if (member instanceof Method) {
            Method method = (Method)member;
            member = this.beanContext.getMatchingBeanMethod(method);
        }
        ArrayList<InjectionPoint> points = new ArrayList<InjectionPoint>();
        for (InjectionPoint ip : this.injectionPoints) {
            if (!ip.getMember().equals(member)) continue;
            points.add(ip);
        }
        return points;
    }

    protected void specialize(CdiEjbBean<?> superBean) {
        CdiEjbBean bean = this;
        bean.setName(superBean.getName());
        bean.setSerializable(superBean.isSerializable());
        this.implScopeType = superBean.implScopeType;
        this.scopeClass = superBean.scopeClass;
        this.implQualifiers.addAll(superBean.getImplQualifiers());
        this.stereoTypeClasses.addAll(superBean.stereoTypeClasses);
        this.stereoTypes.addAll(superBean.stereoTypes);
    }

    public boolean isPassivationCapable() {
        return this.getWebBeansContext().getBeanManagerImpl().isPassivatingScope(this.getScope());
    }

    private List<Method> findRemove(Class beanClass, Class beanInterface) {
        Method[] methods;
        ArrayList<Method> toReturn = new ArrayList<Method>();
        for (Method method : methods = beanClass.getMethods()) {
            Remove annotation = method.getAnnotation(Remove.class);
            if (annotation == null) continue;
            try {
                Method interfaceMethod = beanInterface.getMethod(method.getName(), method.getParameterTypes());
                toReturn.add(interfaceMethod);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return toReturn;
    }
}

