/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.ActivationConfig;
import org.apache.openejb.jee.ActivationConfigProperty;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ActivationConfigPropertyOverride
implements DynamicDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, ActivationConfigPropertyOverride.class);

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        Properties system = new Properties(System.getProperties());
        system.putAll((Map<?, ?>)SystemInstance.get().getProperties());
        system.putAll((Map<?, ?>)appModule.getProperties());
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            Properties module = new Properties(system);
            module.putAll((Map<?, ?>)openejbJar.getProperties());
            Map deployments = openejbJar.getDeploymentsByEjbName();
            for (EnterpriseBean bean : ejbJar.getEnterpriseBeans()) {
                String ejbName = bean.getEjbName();
                EjbDeployment ejbDeployment = (EjbDeployment)deployments.get(ejbName);
                if (!(bean instanceof MessageDrivenBean)) continue;
                Properties properties = new Properties(module);
                properties.putAll((Map<?, ?>)ejbDeployment.getProperties());
                MessageDrivenBean mdb = (MessageDrivenBean)bean;
                Properties overrides = ConfigurationFactory.getOverrides(properties, "mdb.activation", "EnterpriseBean");
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, mdb.getMessagingType() + ".activation", "EnterpriseBean"));
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, ejbName + ".activation", "EnterpriseBean"));
                overrides.putAll((Map<?, ?>)ConfigurationFactory.getOverrides(properties, ejbDeployment.getDeploymentId() + ".activation", "EnterpriseBean"));
                if (overrides.size() == 0) continue;
                Properties activation = this.asProperties(mdb.getActivationConfig());
                for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                    String property = entry.getKey() + "";
                    String value = entry.getValue() + "";
                    if (activation.contains(property)) {
                        logger.info(String.format("Overriding %s bean activation-config property %s=%s", ejbName, property, value));
                    } else {
                        logger.info(String.format("Adding %s bean activation-config property %s=%s", ejbName, property, value));
                    }
                    activation.put(property, value);
                }
            }
        }
        return appModule;
    }

    private Properties asProperties(ActivationConfig activationConfig) {
        Properties properties = new Properties();
        for (ActivationConfigProperty property : activationConfig.getActivationConfigProperty()) {
            properties.put(property.getActivationConfigPropertyName(), property.getActivationConfigPropertyValue());
        }
        return properties;
    }
}

