/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentFilterable;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.RequireDescriptors;
import org.apache.openejb.config.UnknownModuleTypeException;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.apache.xbean.finder.filter.IncludeExcludeFilter;

public class DeploymentsResolver
implements DeploymentFilterable {
    private static final Logger logger = DeploymentLoader.logger;

    public static void loadFrom(Deployments dep, FileUtils path, List<URL> jarList) {
        if (dep.getDir() == null && dep.getJar() != null) {
            try {
                File jar = path.getFile(dep.getJar(), false);
                if (!jarList.contains(jar.getAbsolutePath())) {
                    jarList.add(jar.toURI().toURL());
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            return;
        }
        File dir = null;
        try {
            dir = path.getFile(dep.getDir(), false);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File ejbJarXml = new File(dir, "META-INF" + File.separator + "ejb-jar.xml");
        if (ejbJarXml.exists()) {
            try {
                if (!jarList.contains(dir.getAbsolutePath())) {
                    jarList.add(dir.toURI().toURL());
                }
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
            return;
        }
        File appXml = new File(dir, "META-INF" + File.separator + "application.xml");
        if (appXml.exists()) {
            try {
                if (!jarList.contains(dir.getAbsolutePath())) {
                    jarList.add(dir.toURI().toURL());
                }
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
            return;
        }
        File raXml = new File(dir, "META-INF" + File.separator + "ra.xml");
        if (raXml.exists()) {
            try {
                if (!jarList.contains(dir.getAbsolutePath())) {
                    jarList.add(dir.toURI().toURL());
                }
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
            return;
        }
        boolean hasNestedArchives = false;
        for (File file : dir.listFiles()) {
            try {
                if (file.getName().endsWith(".jar") || file.getName().endsWith(".war") || file.getName().endsWith(".rar") || file.getName().endsWith(".ear")) {
                    if (jarList.contains(file.getAbsolutePath())) continue;
                    jarList.add(file.toURI().toURL());
                    hasNestedArchives = true;
                    continue;
                }
                if (new File(file, "META-INF").exists()) {
                    jarList.add(file.toURI().toURL());
                    hasNestedArchives = true;
                    continue;
                }
                if (!new File(file, "WEB-INF").exists()) continue;
                jarList.add(file.toURI().toURL());
                hasNestedArchives = true;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (!hasNestedArchives) {
            HashMap<String, URL> files = new HashMap<String, URL>();
            DeploymentLoader.scanDir(dir, files, "");
            for (String fileName : files.keySet()) {
                if (!fileName.endsWith(".class")) continue;
                try {
                    if (!jarList.contains(dir.getAbsolutePath())) {
                        jarList.add(dir.toURI().toURL());
                    }
                }
                catch (MalformedURLException ignore) {
                    // empty catch block
                }
                return;
            }
        }
    }

    public static void loadFromClasspath(FileUtils base, List<URL> jarList, ClassLoader classLoader) {
        Options options = SystemInstance.get().getOptions();
        String include = options.get("openejb.deployments.classpath.include", ".*");
        String exclude = options.get("openejb.deployments.classpath.exclude", "");
        Set requireDescriptors = options.getAll("openejb.deployments.classpath.require.descriptor", (Enum[])new RequireDescriptors[]{RequireDescriptors.CLIENT});
        boolean filterDescriptors = options.get("openejb.deployments.classpath.filter.descriptors", false);
        boolean filterSystemApps = options.get("openejb.deployments.classpath.filter.systemapps", true);
        try {
            List urls;
            int size;
            UrlSet urlSet = new UrlSet(classLoader);
            UrlSet includes = urlSet.matching(include);
            urlSet = urlSet.exclude(ClassLoader.getSystemClassLoader().getParent());
            urlSet = urlSet.excludeJavaExtDirs();
            urlSet = urlSet.excludeJavaEndorsedDirs();
            urlSet = urlSet.excludeJavaHome();
            urlSet = urlSet.excludePaths(System.getProperty("sun.boot.class.path", ""));
            UrlSet prefiltered = urlSet = urlSet.exclude(".*/JavaVM.framework/.*");
            IncludeExcludeFilter filter = new IncludeExcludeFilter(Filters.patterns((String[])new String[]{include}), Filters.patterns((String[])new String[]{exclude}));
            urlSet = urlSet.filter((Filter)filter);
            if (prefiltered.size() == urlSet.size()) {
                urlSet = NewLoaderLogic.applyBuiltinExcludes(urlSet);
                if (filterSystemApps) {
                    urlSet = urlSet.exclude(".*/openejb-[^/]+(.(jar|ear|war)(!/)?|/target/(test-)?classes/?)");
                }
            }
            if ((size = (urls = urlSet.getUrls()).size()) == 0 && include.length() > 0) {
                logger.warning("No classpath URLs matched.  Current settings: openejb.deployments.classpath.exclude='" + exclude + "', " + "openejb.deployments.classpath.include" + "='" + include + "'");
                return;
            }
            if (size == 0 && !filterDescriptors && prefiltered.getUrls().size() == 0) {
                return;
            }
            if (size < 20) {
                logger.debug("Inspecting classpath for applications: " + urls.size() + " urls.");
            } else {
                boolean willScrape;
                boolean bl = willScrape = requireDescriptors.size() < RequireDescriptors.values().length;
                if (size < 50 && willScrape) {
                    logger.info("Inspecting classpath for applications: " + urls.size() + " urls. Consider adjusting your exclude/include.  Current settings: " + "openejb.deployments.classpath.exclude" + "='" + exclude + "', " + "openejb.deployments.classpath.include" + "='" + include + "'");
                } else if (willScrape) {
                    logger.warning("Inspecting classpath for applications: " + urls.size() + " urls.");
                    logger.warning("ADJUST THE EXCLUDE/INCLUDE!!!.  Current settings: openejb.deployments.classpath.exclude='" + exclude + "', " + "openejb.deployments.classpath.include" + "='" + include + "'");
                }
            }
            long begin = System.currentTimeMillis();
            DeploymentsResolver.processUrls(urls, classLoader, requireDescriptors, base, jarList);
            long end = System.currentTimeMillis();
            long time = end - begin;
            UrlSet unchecked = new UrlSet(new URL[0]);
            if (!filterDescriptors) {
                unchecked = prefiltered.exclude(urlSet);
                if (filterSystemApps) {
                    unchecked = unchecked.exclude(".*/openejb-[^/]+(.(jar|ear|war)(./)?|/target/classes/?)");
                }
                DeploymentsResolver.processUrls(unchecked.getUrls(), classLoader, EnumSet.allOf(RequireDescriptors.class), base, jarList);
            }
            if (logger.isDebugEnabled()) {
                int urlCount = urlSet.getUrls().size() + unchecked.getUrls().size();
                logger.debug("URLs after filtering: " + urlCount);
                for (URL uRL : urlSet.getUrls()) {
                    logger.debug("Annotations path: " + uRL);
                }
                for (URL uRL : unchecked.getUrls()) {
                    logger.debug("Descriptors path: " + uRL);
                }
            }
            if (urls.size() == 0) {
                return;
            }
            if (time < 1000L) {
                logger.debug("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
            } else if (time < 4000L || urls.size() < 3) {
                logger.info("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
            } else if (time < 10000L) {
                logger.warning("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.");
                logger.warning("Consider adjusting your openejb.deployments.classpath.exclude and openejb.deployments.classpath.include settings.  Current settings: exclude='" + exclude + "', include='" + include + "'");
            } else {
                logger.fatal("Searched " + urls.size() + " classpath urls in " + time + " milliseconds.  Average " + time / (long)urls.size() + " milliseconds per url.  TOO LONG!");
                logger.fatal("ADJUST THE EXCLUDE/INCLUDE!!!.  Current settings: openejb.deployments.classpath.exclude='" + exclude + "', " + "openejb.deployments.classpath.include" + "='" + include + "'");
                ArrayList<String> list = new ArrayList<String>();
                for (URL uRL : urls) {
                    list.add(uRL.toExternalForm());
                }
                Collections.sort(list);
                for (String string : list) {
                    logger.info("Matched: " + string);
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            logger.warning("Unable to search classpath for modules: Received Exception: " + e1.getClass().getName() + " " + e1.getMessage(), e1);
        }
    }

    private static boolean shouldFilter(String include, String exclude, Set<RequireDescriptors> requireDescriptors) {
        boolean includeNothing = include.equals("");
        boolean excludeEverything = exclude.equals(".*");
        if (includeNothing && excludeEverything) {
            return false;
        }
        return requireDescriptors.size() != RequireDescriptors.values().length;
    }

    private static UrlSet applyBuiltinExcludes(UrlSet urlSet) throws MalformedURLException {
        urlSet = urlSet.exclude(".*/activation(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/activeio-core(-[\\d.]+)?(-incubator)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/activemq-(core|ra)(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/annotations-api-6.[01].[\\d.]+.jar(!/)?");
        urlSet = urlSet.exclude(".*/asm-(all|commons|util|tree)?[\\d.]+.jar(!/)?");
        urlSet = urlSet.exclude(".*/avalon-framework(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/axis2-jaxws-api(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/backport-util-concurrent(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/bcprov-jdk15(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/catalina(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/cglib-(nodep-)?[\\d.]+.jar(!/)?");
        urlSet = urlSet.exclude(".*/com\\.ibm\\.ws\\.[^/]*.jar(!/)?");
        urlSet = urlSet.exclude(".*/commons-(logging|logging-api|cli|pool|lang|collections|dbcp|dbcp-all)(-[\\d.r-]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/cxf-bundle(-[\\d.]+)?(incubator)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/derby(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/ejb31-api-experimental(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/geronimo-(connector|transaction)(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/geronimo-[^/]+_spec(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/geronimo-javamail_([\\d.]+)_mail(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/hibernate-(entitymanager|annotations)?(-[\\d.]+(ga)?)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/howl(-[\\d.-]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/hsqldb(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/idb(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/idea_rt.jar(!/)?");
        urlSet = urlSet.exclude(".*/javaee-api(-embedded)?-[\\d.-]+.jar(!/)?");
        urlSet = urlSet.exclude(".*/javassist[^/]*.jar(!/)?");
        urlSet = urlSet.exclude(".*/jaxb-(impl|api)(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/jboss-[^/]*.jar(!/)?");
        urlSet = urlSet.exclude(".*/jbossall-[^/]*.jar(!/)?");
        urlSet = urlSet.exclude(".*/jbosscx-[^/]*.jar(!/)?");
        urlSet = urlSet.exclude(".*/jbossjts-?[^/]*.jar(!/)?");
        urlSet = urlSet.exclude(".*/jbosssx-[^/]*.jar(!/)?");
        urlSet = urlSet.exclude(".*/jmdns(-[\\d.]+)?(-RC\\d)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/juli(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/junit(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/log4j(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/logkit(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/mail(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/neethi(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/org\\.eclipse\\.persistence\\.[^/]*.jar(!/)?");
        urlSet = urlSet.exclude(".*/org\\.junit_.[^/]*.jar(!/)?");
        urlSet = urlSet.exclude(".*/openjpa-(jdbc|kernel|lib|persistence|persistence-jdbc)(-5)?(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/openjpa(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/opensaml(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/quartz(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/saaj-impl(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/serp(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/servlet-api(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/slf4j-api(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/slf4j-jdk14(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/stax-api(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/swizzle-stream(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/sxc-(jaxb|runtime)(-[\\d.]+)?(-SNAPSHOT)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/wsdl4j(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/wss4j(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/wstx-asl(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/xbean-(reflect|naming|finder)-(shaded-)?[\\d.]+.jar(!/)?");
        urlSet = urlSet.exclude(".*/xmlParserAPIs(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/xmlunit(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/xmlsec(-[\\d.]+)?.jar(!/)?");
        urlSet = urlSet.exclude(".*/XmlSchema(-[\\d.]+)?.jar(!/)?");
        return urlSet;
    }

    public static void processUrls(List<URL> urls, ClassLoader classLoader, Set<RequireDescriptors> requireDescriptors, FileUtils base, List<URL> jarList) {
        for (URL url : urls) {
            boolean isValidURL;
            String urlProtocol = url.getProtocol();
            boolean bl = isValidURL = urlProtocol.equals("jar") || urlProtocol.equals("file");
            if (!isValidURL) {
                logger.warning("Unknown protocol " + urlProtocol);
                continue;
            }
            String path = "";
            try {
                File file;
                DeploymentLoader deploymentLoader = new DeploymentLoader();
                Class<? extends DeploymentModule> moduleType = deploymentLoader.discoverModuleType(url, classLoader, requireDescriptors);
                if (!AppModule.class.isAssignableFrom(moduleType) && !EjbModule.class.isAssignableFrom(moduleType) && !PersistenceModule.class.isAssignableFrom(moduleType) && !ConnectorModule.class.isAssignableFrom(moduleType) && !ClientModule.class.isAssignableFrom(moduleType)) continue;
                Deployments deployment = JaxbOpenejb.createDeployments();
                if (urlProtocol.equals("jar")) {
                    url = new URL(url.getFile().replaceFirst("!.*$", ""));
                    file = URLs.toFile(url);
                    path = file.getAbsolutePath();
                    deployment.setJar(path);
                } else if (urlProtocol.equals("file")) {
                    file = URLs.toFile(url);
                    path = file.getAbsolutePath();
                    deployment.setDir(path);
                }
                logger.info("Found " + moduleType.getSimpleName() + " in classpath: " + path);
                if (AppModule.class.isAssignableFrom(moduleType) || ConnectorModule.class.isAssignableFrom(moduleType)) {
                    DeploymentsResolver.loadFrom(deployment, base, jarList);
                    continue;
                }
                if (jarList.contains(path)) continue;
                jarList.add(url);
            }
            catch (IOException e) {
                logger.warning("Unable to determine the module type of " + url.toExternalForm() + ": Exception: " + e.getMessage(), e);
            }
            catch (UnknownModuleTypeException ignore) {}
        }
    }
}

