/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.net.URL;
import org.apache.openejb.config.AggregatedArchive;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.ClasspathArchive;

public class FinderFactory {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, FinderFactory.class);
    private static final FinderFactory factory = new FinderFactory();

    private static FinderFactory get() {
        FinderFactory factory = (FinderFactory)SystemInstance.get().getComponent(FinderFactory.class);
        return factory != null ? factory : FinderFactory.factory;
    }

    public static IAnnotationFinder createFinder(DeploymentModule module) throws Exception {
        return FinderFactory.get().create(module);
    }

    public IAnnotationFinder create(DeploymentModule module) throws Exception {
        if (module instanceof WebModule) {
            WebModule webModule = (WebModule)module;
            ClassLoader webClassLoader = webModule.getClassLoader();
            return new AnnotationFinder((Archive)new AggregatedArchive(webClassLoader, webModule.getUrls())).link();
        }
        if (module instanceof ConnectorModule) {
            ConnectorModule connectorModule = (ConnectorModule)module;
            ClassLoader connectorClassLoader = connectorModule.getClassLoader();
            return new AnnotationFinder((Archive)new ClasspathArchive(connectorClassLoader, connectorModule.getLibraries())).link();
        }
        if (module.getJarLocation() != null) {
            URL url;
            String location = module.getJarLocation();
            File file = new File(location);
            if (file.exists()) {
                url = file.toURI().toURL();
                File webInfClassesFolder = new File(file, "WEB-INF/classes");
                if (webInfClassesFolder.exists() && webInfClassesFolder.isDirectory()) {
                    url = webInfClassesFolder.toURI().toURL();
                }
            } else {
                url = new URL(location);
            }
            return new AnnotationFinder((Archive)new ClasspathArchive(module.getClassLoader(), new URL[]{url})).link();
        }
        return new AnnotationFinder((Archive)new ClassesArchive(new Class[0])).link();
    }
}

